/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.util.Arrays;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachine;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class RepeatedlyStateMachine
extends TriggerStateMachine {
    private static final @UnknownKeyFor @NonNull @Initialized int REPEATED = 0;

    public static @UnknownKeyFor @NonNull @Initialized RepeatedlyStateMachine forever(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine repeated) {
        return new RepeatedlyStateMachine(repeated);
    }

    private RepeatedlyStateMachine(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine repeated) {
        super(Arrays.asList(repeated));
    }

    @Override
    public void prefetchOnElement(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.PrefetchContext c) {
        this.getRepeated(c).invokePrefetchOnElement(c);
    }

    @Override
    public void onElement(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.OnElementContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.getRepeated(c).invokeOnElement(c);
    }

    @Override
    public void prefetchOnMerge(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.MergingPrefetchContext c) {
        this.getRepeated(c).invokePrefetchOnMerge(c);
    }

    @Override
    public void onMerge(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.OnMergeContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.getRepeated(c).invokeOnMerge(c);
    }

    @Override
    public void prefetchShouldFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.PrefetchContext c) {
        this.getRepeated(c).invokePrefetchShouldFire(c);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean shouldFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return this.getRepeated(context).invokeShouldFire(context);
    }

    @Override
    public void onFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.getRepeated(context).invokeOnFire(context);
        if (context.trigger().isFinished(0)) {
            context.forTrigger(this.getRepeated(context)).trigger().resetTree();
        }
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("Repeatedly.forever(%s)", this.subTriggers.get(0));
    }

    private @UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine getRepeated(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext context) {
        return context.trigger().subTrigger(0);
    }

    private @UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine getRepeated(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.PrefetchContext context) {
        return context.trigger().subTriggers().get(0);
    }
}

