/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.veneer.repackaged.io.opencensus.implcore.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class VarInt {
    public static final int MAX_VARINT_SIZE = 5;
    public static final int MAX_VARLONG_SIZE = 10;

    private VarInt() {
    }

    public static int varIntSize(int i) {
        int result = 0;
        do {
            ++result;
        } while ((i >>>= 7) != 0);
        return result;
    }

    public static int getVarInt(byte[] src, int offset, int[] dst) {
        byte b;
        int result = 0;
        int shift = 0;
        do {
            if (shift >= 32) {
                throw new IndexOutOfBoundsException("varint too long");
            }
            b = src[offset++];
            result |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        dst[0] = result;
        return offset;
    }

    public static int putVarInt(int v, byte[] sink, int offset) {
        do {
            int bits = v & 0x7F;
            byte b = (byte)(bits + ((v >>>= 7) != 0 ? 128 : 0));
            sink[offset++] = b;
        } while (v != 0);
        return offset;
    }

    public static int getVarInt(ByteBuffer src) {
        byte tmp = src.get();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = src.get();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = src.get();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = src.get();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = src.get();
                    result |= tmp << 28;
                    while (tmp < 0) {
                        tmp = src.get();
                    }
                }
            }
        }
        return result;
    }

    public static void putVarInt(int v, ByteBuffer sink) {
        while (true) {
            int bits = v & 0x7F;
            if ((v >>>= 7) == 0) {
                sink.put((byte)bits);
                return;
            }
            sink.put((byte)(bits | 0x80));
        }
    }

    public static int getVarInt(InputStream inputStream) throws IOException {
        int b;
        int result = 0;
        int shift = 0;
        do {
            if (shift >= 32) {
                throw new IndexOutOfBoundsException("varint too long");
            }
            b = inputStream.read();
            result |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return result;
    }

    public static void putVarInt(int v, OutputStream outputStream) throws IOException {
        byte[] bytes = new byte[VarInt.varIntSize(v)];
        VarInt.putVarInt(v, bytes, 0);
        outputStream.write(bytes);
    }

    public static int varLongSize(long v) {
        int result = 0;
        do {
            ++result;
        } while ((v >>>= 7) != 0L);
        return result;
    }

    public static long getVarLong(ByteBuffer src) {
        long tmp = src.get();
        if (tmp >= 0L) {
            return tmp;
        }
        long result = tmp & 0x7FL;
        tmp = src.get();
        if (tmp >= 0L) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7FL) << 7;
            tmp = src.get();
            if (tmp >= 0L) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7FL) << 14;
                tmp = src.get();
                if (tmp >= 0L) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7FL) << 21;
                    tmp = src.get();
                    if (tmp >= 0L) {
                        result |= tmp << 28;
                    } else {
                        result |= (tmp & 0x7FL) << 28;
                        tmp = src.get();
                        if (tmp >= 0L) {
                            result |= tmp << 35;
                        } else {
                            result |= (tmp & 0x7FL) << 35;
                            tmp = src.get();
                            if (tmp >= 0L) {
                                result |= tmp << 42;
                            } else {
                                result |= (tmp & 0x7FL) << 42;
                                tmp = src.get();
                                if (tmp >= 0L) {
                                    result |= tmp << 49;
                                } else {
                                    result |= (tmp & 0x7FL) << 49;
                                    tmp = src.get();
                                    if (tmp >= 0L) {
                                        result |= tmp << 56;
                                    } else {
                                        result |= (tmp & 0x7FL) << 56;
                                        result |= (long)src.get() << 63;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    public static void putVarLong(long v, ByteBuffer sink) {
        while (true) {
            int bits = (int)v & 0x7F;
            if ((v >>>= 7) == 0L) {
                sink.put((byte)bits);
                return;
            }
            sink.put((byte)(bits | 0x80));
        }
    }
}

