/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.mutaterows;

import com.google.api.core.InternalApi;
import com.google.api.gax.batching.BatchEntry;
import com.google.api.gax.batching.BatchResource;
import com.google.api.gax.batching.BatchingDescriptor;
import com.google.api.gax.batching.BatchingRequestBuilder;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.MutateRowsException;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsBatchResource;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;

@InternalApi(value="For internal use only")
public class MutateRowsBatchingDescriptor
implements BatchingDescriptor<RowMutationEntry, Void, BulkMutation, Void> {
    public BatchingRequestBuilder<RowMutationEntry, BulkMutation> newRequestBuilder(BulkMutation prototype) {
        return new RequestBuilder(prototype);
    }

    public void splitResponse(Void response, List<BatchEntry<RowMutationEntry, Void>> entries) {
        for (BatchEntry<RowMutationEntry, Void> batchResponse : entries) {
            batchResponse.getResultFuture().set(null);
        }
    }

    public void splitException(Throwable throwable, List<BatchEntry<RowMutationEntry, Void>> entries) {
        if (!(throwable instanceof MutateRowsException)) {
            for (BatchEntry<RowMutationEntry, Void> entry : entries) {
                entry.getResultFuture().setException(throwable);
            }
            return;
        }
        List<MutateRowsException.FailedMutation> failedMutations = ((MutateRowsException)((Object)throwable)).getFailedMutations();
        HashMap entryErrors = Maps.newHashMap();
        for (MutateRowsException.FailedMutation failure : failedMutations) {
            entryErrors.put(failure.getIndex(), failure.getError());
        }
        int i = 0;
        for (BatchEntry<RowMutationEntry, Void> entry : entries) {
            Throwable entryError;
            if ((entryError = (Throwable)entryErrors.get(i++)) == null) {
                entry.getResultFuture().set(null);
                continue;
            }
            entry.getResultFuture().setException(entryError);
        }
    }

    public long countBytes(RowMutationEntry entry) {
        return entry.toProto().getSerializedSize();
    }

    public BatchResource createResource(RowMutationEntry element) {
        long byteCount = this.countBytes(element);
        return MutateRowsBatchResource.create(1L, byteCount, element.toProto().getMutationsCount());
    }

    public BatchResource createEmptyResource() {
        return MutateRowsBatchResource.create(0L, 0L, 0L);
    }

    static class RequestBuilder
    implements BatchingRequestBuilder<RowMutationEntry, BulkMutation> {
        private BulkMutation bulkMutation;

        RequestBuilder(BulkMutation prototype) {
            this.bulkMutation = prototype.clone();
        }

        public void add(RowMutationEntry entry) {
            this.bulkMutation.add(entry);
        }

        public BulkMutation build() {
            return this.bulkMutation;
        }
    }
}

