/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.clonerow;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.clonerow.CloneRowData;
import org.apache.hop.pipeline.transforms.clonerow.CloneRowMeta;

public class CloneRow
extends BaseTransform<CloneRowMeta, CloneRowData> {
    private static final Class<?> PKG = CloneRowMeta.class;

    public CloneRow(TransformMeta transformMeta, CloneRowMeta meta, CloneRowData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            String realnumfield;
            String realflagfield;
            this.first = false;
            ((CloneRowData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((CloneRowData)this.data).nrPrevFields = this.getInputRowMeta().size();
            ((CloneRowMeta)this.meta).getFields(((CloneRowData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            boolean bl = ((CloneRowData)this.data).addInfosToRow = ((CloneRowMeta)this.meta).isAddCloneFlag() || ((CloneRowMeta)this.meta).isAddCloneNum();
            if (((CloneRowMeta)this.meta).isAddCloneFlag() && Utils.isEmpty((CharSequence)(realflagfield = this.resolve(((CloneRowMeta)this.meta).getCloneFlagField())))) {
                this.logError(BaseMessages.getString(PKG, (String)"CloneRow.Error.CloneFlagFieldMissing", (String[])new String[0]));
                throw new HopException(BaseMessages.getString(PKG, (String)"CloneRow.Error.CloneFlagFieldMissing", (String[])new String[0]));
            }
            if (((CloneRowMeta)this.meta).isAddCloneNum() && Utils.isEmpty((CharSequence)(realnumfield = this.resolve(((CloneRowMeta)this.meta).getCloneNumField())))) {
                this.logError(BaseMessages.getString(PKG, (String)"CloneRow.Error.CloneNumFieldMissing", (String[])new String[0]));
                throw new HopException(BaseMessages.getString(PKG, (String)"CloneRow.Error.CloneNumFieldMissing", (String[])new String[0]));
            }
            if (((CloneRowMeta)this.meta).isNrCloneInField()) {
                String cloneinfieldname = ((CloneRowMeta)this.meta).getNrCloneField();
                if (Utils.isEmpty((CharSequence)cloneinfieldname)) {
                    this.logError(BaseMessages.getString(PKG, (String)"CloneRow.Error.NrCloneInFieldMissing", (String[])new String[0]));
                    throw new HopException(BaseMessages.getString(PKG, (String)"CloneRow.Error.NrCloneInFieldMissing", (String[])new String[0]));
                }
                if (((CloneRowData)this.data).indexOfNrCloneField < 0) {
                    ((CloneRowData)this.data).indexOfNrCloneField = this.getInputRowMeta().indexOfValue(cloneinfieldname);
                    if (((CloneRowData)this.data).indexOfNrCloneField < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"CloneRow.Log.ErrorFindingField", (String[])new String[0]) + "[" + cloneinfieldname + "]");
                        throw new HopException(BaseMessages.getString(PKG, (String)"CloneRow.Exception.CouldnotFindField", (String[])new String[]{cloneinfieldname}));
                    }
                }
            } else {
                String nrclonesString = this.resolve(((CloneRowMeta)this.meta).getNrClones());
                ((CloneRowData)this.data).nrclones = Const.toInt((String)nrclonesString, (int)0);
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"CloneRow.Log.NrClones", (String[])new String[]{"" + ((CloneRowData)this.data).nrclones}));
                }
            }
        }
        Object[] outputRowData = r;
        if (((CloneRowData)this.data).addInfosToRow) {
            outputRowData = RowDataUtil.createResizedCopy((Object[])r, (int)((CloneRowData)this.data).outputRowMeta.size());
            int rowIndex = ((CloneRowData)this.data).nrPrevFields;
            if (((CloneRowMeta)this.meta).isAddCloneFlag()) {
                outputRowData[rowIndex] = false;
                ++rowIndex;
            }
            if (((CloneRowMeta)this.meta).isAddCloneNum()) {
                outputRowData[rowIndex] = 0L;
            }
        }
        this.putRow(((CloneRowData)this.data).outputRowMeta, outputRowData);
        if (((CloneRowMeta)this.meta).isNrCloneInField()) {
            Long nrCloneFieldValue = this.getInputRowMeta().getInteger(r, ((CloneRowData)this.data).indexOfNrCloneField);
            if (nrCloneFieldValue == null) {
                throw new HopException(BaseMessages.getString(PKG, (String)"CloneRow.Log.NrClonesIsNull", (String[])new String[0]));
            }
            ((CloneRowData)this.data).nrclones = nrCloneFieldValue;
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"CloneRow.Log.NrClones", (String[])new String[]{"" + ((CloneRowData)this.data).nrclones}));
            }
        }
        int i = 0;
        while ((long)i < ((CloneRowData)this.data).nrclones && !this.isStopped()) {
            outputRowData = (Object[])r.clone();
            if (((CloneRowData)this.data).addInfosToRow) {
                outputRowData = RowDataUtil.createResizedCopy((Object[])r, (int)((CloneRowData)this.data).outputRowMeta.size());
                int rowIndex = ((CloneRowData)this.data).nrPrevFields;
                if (((CloneRowMeta)this.meta).isAddCloneFlag()) {
                    outputRowData[rowIndex] = true;
                    ++rowIndex;
                }
                if (((CloneRowMeta)this.meta).isAddCloneNum()) {
                    Long clonenum = (long)i + 1L;
                    outputRowData[rowIndex] = clonenum;
                }
            }
            this.putRow(((CloneRowData)this.data).outputRowMeta, outputRowData);
            ++i;
        }
        if (this.log.isDetailed() && this.checkFeedback(this.getLinesRead())) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"CloneRow.Log.LineNumber", (String[])new String[]{"" + this.getLinesRead()}));
        }
        return true;
    }
}

