/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class AS400XChgRandSeedReplyDS
extends ClientAccessDataStream {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";

    AS400XChgRandSeedReplyDS() {
    }

    @Override
    public Object getNewDataStream() {
        return new AS400XChgRandSeedReplyDS();
    }

    int getRC() {
        return this.get32bit(20);
    }

    byte[] getServerSeed() {
        byte[] seed = new byte[8];
        System.arraycopy(this.data_, 24, seed, 0, 8);
        return seed;
    }

    void read(InputStream in) throws IOException {
        byte[] header;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving exchange random seeds reply...");
        }
        if (this.readFromStream(in, header = new byte[20], 0, 20) < 20) {
            if (Trace.traceOn_) {
                Trace.log(2, "Failed to read all of the exchange random seeds reply header.");
            }
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToInt(header, 0)];
        System.arraycopy(header, 0, this.data_, 0, 20);
        this.readAfterHeader(in);
    }

    @Override
    public int hashCode() {
        return 61441;
    }

    public byte getServerAttributes() {
        return this.get8bit(5);
    }
}

