/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import java.io.InputStream;

class ConvTableInputStream
extends InputStream {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    private byte[] buffer_ = null;
    private int offset_ = 0;
    private int end_ = 0;

    ConvTableInputStream() {
    }

    void setContents(byte[] buffer, int offset, int length) {
        this.buffer_ = buffer;
        this.offset_ = offset;
        this.end_ = offset + length;
    }

    @Override
    public int read() {
        if (this.buffer_ == null) {
            return -1;
        }
        int ret = this.buffer_[this.offset_++] & 0xFF;
        if (this.offset_ == this.end_) {
            this.buffer_ = null;
        }
        return ret;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) {
        if (this.buffer_ == null) {
            return -1;
        }
        int bytesAvail = this.end_ - this.offset_;
        if (length < bytesAvail) {
            System.arraycopy(this.buffer_, this.offset_, buffer, offset, length);
            this.offset_ += length;
            return length;
        }
        System.arraycopy(this.buffer_, this.offset_, buffer, offset, bytesAvail);
        this.buffer_ = null;
        return bytesAvail;
    }

    @Override
    public int available() {
        if (this.buffer_ == null) {
            return 0;
        }
        return this.end_ - this.offset_;
    }
}

