/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;

public class SystemProperties {
    private static final String ACCESS_PREFIX = "com.ibm.as400.access.";
    private static final String DATA_PREFIX = "com.ibm.as400.data.";
    private static final String PROPERTIES_CLASS_NAME = "com.ibm.as400.access.Properties";
    private static final String PROPERTIES_FILE_NAME = "com.ibm.as400.access.jt400.properties";
    private static final String PROPERTIES_FILE_NAME_WITH_SLASHES = "com/ibm/as400/access/jt400.properties";
    public static final String AS400_GUI_AVAILABLE = "com.ibm.as400.access.AS400.guiAvailable";
    public static final String AS400_PROXY_SERVER = "com.ibm.as400.access.AS400.proxyServer";
    public static final String AS400_SIGNON_HANDLER = "com.ibm.as400.access.AS400.signonHandler";
    public static final String AS400_MUST_ADD_LANGUAGE_LIBRARY = "com.ibm.as400.access.AS400.mustAddLanguageLibrary";
    public static final String AS400_MUST_USE_SOCKETS = "com.ibm.as400.access.AS400.mustUseSockets";
    public static final String AS400_MUST_USE_NET_SOCKETS = "com.ibm.as400.access.AS400.mustUseNetSockets";
    public static final String AS400_MUST_USE_SUPPLIED_PROFILE = "com.ibm.as400.access.AS400.mustUseSuppliedProfile";
    public static final String AS400_THREAD_USED = "com.ibm.as400.access.AS400.threadUsed";
    static final String SECUREAS400_PROXY_ENCRYPTION_MODE = "com.ibm.as400.access.SecureAS400.proxyEncryptionMode";
    public static final String TRACE_CATEGORY = "com.ibm.as400.access.Trace.category";
    static final String TRACE_CATEGORIES = "com.ibm.as400.access.Trace.categories";
    public static final String TRACE_SHOW_CHARS = "com.ibm.as400.access.Trace.showChars";
    public static final String TRACE_FILE = "com.ibm.as400.access.Trace.file";
    public static final String TRACE_JDBC_SERVER = "com.ibm.as400.access.ServerTrace.JDBC";
    static final String TRACE_ENABLED = "com.ibm.as400.access.Trace.enabled";
    public static final String COMMANDCALL_THREADSAFE = "com.ibm.as400.access.CommandCall.threadSafe";
    public static final String PROGRAMCALL_THREADSAFE = "com.ibm.as400.access.ProgramCall.threadSafe";
    public static final String TUNNELPROXYSERVER_CLIENTCLEANUPINTERVAL = "com.ibm.as400.access.TunnelProxyServer.clientCleanupInterval";
    public static final String TUNNELPROXYSERVER_CLIENTLIFETIME = "com.ibm.as400.access.TunnelProxyServer.clientLifetime";
    public static final String FTP_REUSE_SOCKET = "com.ibm.as400.access.FTP.reuseSocket";
    static final String JDBC_STATEMENT_LISTENERS = "com.ibm.as400.access.JDBC.statementListeners";
    static final String JDBC_SECURE_CURRENT_USER = "com.ibm.as400.access.JDBC.secureCurrentUser";
    static final String JDBC_JVM16_SYNCHRONIZE = "com.ibm.as400.access.JDBC.jvm16Synchronize";
    static final String TRACE_MONITOR = "com.ibm.as400.access.Trace.monitor";
    static final String TRACE_MONITOR_PORT = "com.ibm.as400.access.Trace.monitorPort";
    public static final String FALLBACK_CCSID = "com.ibm.as400.access.AS400.fallbackCCSID";
    public static final String CONNECTIONPOOL_PRETEST = "com.ibm.as400.access.ConnectionPool.pretest";
    public static final String THROW_SAX_EXCEPTION_IF_PARSE_ERROR = "com.ibm.as400.data.ProgramCallDocument.throwSAXExceptionIfParseError";
    public static final String LIST_WAIT_TIMEOUT = "com.ibm.as400.access.ListUtilities.listWaitTimeout";
    private static Vector ignored_ = new Vector();
    private static Properties propertiesFromClass_ = null;
    private static Properties propertiesFromFile_ = null;
    private static boolean propertiesClassLoadFailed_ = false;
    private static boolean propertiesFileLoadFailed_ = false;
    private static boolean systemPropertiesLoadFailed_ = false;

    private SystemProperties() {
    }

    public static String getProperty(String propertyName) {
        String propertyValue;
        block16: {
            if (Trace.isTraceOn()) {
                Trace.log(1, "Getting system property: '" + propertyName + "'");
            }
            propertyValue = null;
            if (ignored_.contains(propertyName)) {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "System property on ignore list, value remains null.");
                }
                return null;
            }
            if (!systemPropertiesLoadFailed_) {
                try {
                    propertyValue = System.getProperty(propertyName);
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "Value found in system properties:  '" + propertyValue + "'");
                    }
                }
                catch (SecurityException e) {
                    systemPropertiesLoadFailed_ = true;
                    if (!Trace.isTraceErrorOn()) break block16;
                    Trace.log(2, "Browser security exception:", (Throwable)e);
                }
            }
        }
        if (propertyValue == null) {
            if (propertiesFromClass_ == null && !propertiesClassLoadFailed_) {
                SystemProperties.loadPropertiesFromClass();
            }
            if (propertiesFromClass_ != null) {
                propertyValue = propertiesFromClass_.getProperty(propertyName);
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Value found in Properties class: '" + propertyValue + "'");
                }
            }
        }
        if (propertyValue == null) {
            if (propertiesFromFile_ == null && !propertiesFileLoadFailed_) {
                SystemProperties.loadPropertiesFromFile();
            }
            if (propertiesFromFile_ != null) {
                propertyValue = propertiesFromFile_.getProperty(propertyName);
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Value found in jt400.properties file: '" + propertyValue + "'");
                }
            }
        }
        if (Trace.isTraceOn() && propertyValue == null) {
            Trace.log(1, "Value not found.");
        }
        return propertyValue;
    }

    static void ignoreProperty(String propertyName) {
        if (Trace.isTraceOn()) {
            Trace.log(4, "Adding system property to ignore list: '" + propertyName + "'");
        }
        ignored_.addElement(propertyName);
    }

    private static void loadPropertiesFromClass() {
        block5: {
            if (Trace.isTraceOn()) {
                Trace.log(1, "Loading Properties class: 'com.ibm.as400.access.Properties'");
            }
            try {
                propertiesFromClass_ = (Properties)Class.forName(PROPERTIES_CLASS_NAME).newInstance();
            }
            catch (ClassNotFoundException e) {
                propertiesClassLoadFailed_ = true;
                if (Trace.isTraceDiagnosticOn()) {
                    Trace.log(1, "Class not found: com.ibm.as400.access.Properties");
                }
            }
            catch (Throwable e) {
                propertiesClassLoadFailed_ = true;
                if (!Trace.isTraceDiagnosticOn()) break block5;
                Trace.log(1, "Unable to load class: com.ibm.as400.access.Properties", e);
            }
        }
    }

    private static void loadPropertiesFromFile() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Loading jt400.properties file: 'com.ibm.as400.access.jt400.properties'");
        }
        propertiesFromFile_ = new Properties();
        InputStream input = null;
        BufferedInputStream bis = null;
        try {
            input = SystemProperties.class.getResourceAsStream(PROPERTIES_FILE_NAME);
            if (Trace.isTraceOn()) {
                Trace.log(1, "Trying with Class.getResourceAsStream(): " + (input != null));
            }
            if (input == null) {
                input = ClassLoader.getSystemResourceAsStream(PROPERTIES_FILE_NAME_WITH_SLASHES);
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Trying with ClassLoader.getSystemResourceAsStream(): " + (input != null));
                }
            }
            if (input == null) {
                propertiesFileLoadFailed_ = true;
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Load of jt400.properties failed.");
                }
                return;
            }
            bis = new BufferedInputStream(input);
            propertiesFromFile_.load(bis);
            bis.close();
            bis = null;
            input = null;
        }
        catch (Exception e) {
            propertiesFileLoadFailed_ = true;
            if (Trace.isTraceWarningOn()) {
                Trace.log(4, "Unable to load jt400.properties file: com.ibm.as400.access.jt400.properties", (Throwable)e);
            }
        }
        finally {
            block33: {
                block32: {
                    if (bis != null) {
                        try {
                            bis.close();
                            input = null;
                        }
                        catch (Throwable t) {
                            if (!Trace.traceOn_) break block32;
                            Trace.log(2, t);
                        }
                    }
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable t) {
                        if (!Trace.traceOn_) break block33;
                        Trace.log(2, t);
                    }
                }
            }
        }
    }
}

