/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public abstract class HTMLListItem
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -7139184882249518511L;
    private HTMLTagElement listData_;
    private String lang_;
    private String dir_;
    boolean useFO_ = false;
    private String type_;

    abstract String getTypeAttribute();

    abstract String getTypeAttributeFO(String var1, int var2);

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            StringBuffer buffer = new StringBuffer(" dir=\"");
            buffer.append(this.dir_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    public HTMLTagElement getItemData() {
        return this.listData_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            StringBuffer buffer = new StringBuffer(" lang=\"");
            buffer.append(this.lang_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    @Override
    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        StringBuffer s = new StringBuffer("<li");
        s.append(this.getTypeAttribute());
        s.append(this.getLanguageAttributeTag());
        s.append(this.getDirectionAttributeTag());
        s.append(this.getAttributeString());
        s.append(">");
        s.append(this.listData_.getTag());
        s.append("</li>\n");
        return s.toString();
    }

    @Override
    public String getFOTag() {
        boolean useFO = this.useFO_;
        this.setUseFO(true);
        StringBuffer s = new StringBuffer("");
        s.append("<fo:block-container");
        s.append(this.getDirectionAttributeTag());
        s.append(">");
        s.append(this.listData_.getFOTag());
        s.append("</fo:block-container>\n");
        this.setUseFO(useFO);
        return s.toString();
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    public void setDirection(String dir) {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setItemData(HTMLTagElement data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        HTMLTagElement old = this.listData_;
        this.listData_ = data;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("data", old, data);
        }
    }

    public void setLanguage(String lang) {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setUseFO(boolean useFO) {
        boolean old = this.useFO_;
        this.useFO_ = useFO;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", old, useFO);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

