/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.servlet.RowData;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowDataListener;
import com.ibm.as400.util.servlet.RowDataSupport;
import com.ibm.as400.util.servlet.RowMetaData;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class ListRowData
extends RowData
implements Serializable {
    static final long serialVersionUID = 1232409461443729991L;
    private RowMetaData metadata_;
    private transient RowDataSupport rowdataSupport_;

    public ListRowData() {
    }

    public ListRowData(RowMetaData metadata) throws RowDataException {
        this();
        try {
            this.setMetaData(metadata);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addRow(Object[] row) throws RowDataException {
        if (this.metadata_ == null) {
            Trace.log(2, "Attempting to add a row before setting the metadata.");
            throw new ExtendedIllegalStateException("metadata", 4);
        }
        this.addRow(row, new Vector[this.metadata_.getColumnCount()]);
    }

    public void addRow(Object[] row, Vector[] properties) throws RowDataException {
        this.validateRow(row);
        this.validateProperties(properties);
        this.rows_.addElement(row);
        this.rowProperties_.addElement(properties);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireAdded();
        }
    }

    public void addRow(Object[] row, int rowIndex) throws RowDataException {
        if (this.metadata_ == null) {
            Trace.log(2, "Attempting to add a row before setting the metadata.");
            throw new ExtendedIllegalStateException("metadata", 4);
        }
        this.addRow(row, new Vector[this.metadata_.getColumnCount()], rowIndex);
    }

    public void addRow(Object[] row, Vector[] properties, int rowIndex) throws RowDataException {
        this.validateRow(row);
        this.validateProperties(properties);
        if (rowIndex < 0 || rowIndex > this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        this.rows_.insertElementAt(row, rowIndex);
        this.rowProperties_.insertElementAt(properties, rowIndex);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireAdded();
        }
    }

    public void addRowDataListener(RowDataListener listener) {
        if (this.rowdataSupport_ == null) {
            this.rowdataSupport_ = new RowDataSupport(this);
        }
        this.rowdataSupport_.addRowDataListener(listener);
    }

    @Override
    public RowMetaData getMetaData() {
        return this.metadata_;
    }

    public Object[] getRow() {
        this.validateRowList("Attempting to get the row object");
        this.validateListPosition("Attempting to get the row object");
        return (Object[])this.rows_.elementAt(this.position_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, RowDataException {
        in.defaultReadObject();
    }

    public void removeRow(int rowIndex) {
        this.validateRowList("Attempting to remove a row");
        if (rowIndex < 0 || rowIndex >= this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        this.rows_.removeElementAt(rowIndex);
        this.rowProperties_.removeElementAt(rowIndex);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireRemoved();
        }
    }

    public void removeRowDataListener(RowDataListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.removeRowDataListener(listener);
        }
    }

    public void setMetaData(RowMetaData metadata) throws RowDataException, PropertyVetoException {
        if (metadata == null) {
            throw new NullPointerException("metaData");
        }
        if (metadata.getColumnCount() == 0) {
            Trace.log(2, "The metadata parameter 'columns' is invalid.");
            throw new ExtendedIllegalStateException("metadata columns", 4);
        }
        RowMetaData old = this.metadata_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("metadata", old, metadata);
        }
        this.metadata_ = metadata;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("metadata", old, metadata);
        }
    }

    public void setRow(Object[] row, int rowIndex) throws RowDataException {
        if (this.metadata_ == null) {
            Trace.log(2, "Attempting to add a row before setting the metadata.");
            throw new ExtendedIllegalStateException("metadata", 4);
        }
        this.setRow(row, new Vector[this.metadata_.getColumnCount()], rowIndex);
    }

    public void setRow(Object[] row, Vector[] properties, int rowIndex) throws RowDataException {
        this.validateRowList("Attempting to change a row");
        this.validateRow(row);
        if (rowIndex < 0 || rowIndex >= this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        this.validateProperties(properties);
        this.rows_.setElementAt(row, rowIndex);
        this.rowProperties_.setElementAt(properties, rowIndex);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireChanged();
        }
    }

    private void validateProperties(Vector[] properties) throws RowDataException {
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        if (properties.length != this.metadata_.getColumnCount()) {
            throw new ExtendedIllegalArgumentException("properties", 1);
        }
    }

    private void validateRow(Object[] row) throws RowDataException {
        if (row == null) {
            throw new NullPointerException("row");
        }
        if (this.metadata_ == null) {
            Trace.log(2, "Attempting to process a row before setting the metadata.");
            throw new ExtendedIllegalStateException("metadata", 4);
        }
        if (row.length != this.metadata_.getColumnCount()) {
            throw new ExtendedIllegalArgumentException("row", 1);
        }
    }
}

