/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;

public class DuckDBTimestamp {
    static final LocalDateTime RefLocalDateTime = LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC);
    protected long timeMicros;

    public DuckDBTimestamp(long l) {
        this.timeMicros = l;
    }

    public DuckDBTimestamp(LocalDateTime localDateTime) {
        this.timeMicros = DuckDBTimestamp.localDateTime2Micros(localDateTime);
    }

    public DuckDBTimestamp(OffsetDateTime offsetDateTime) {
        this.timeMicros = RefLocalDateTime.until(offsetDateTime.withOffsetSameInstant(ZoneOffset.UTC), ChronoUnit.MICROS);
    }

    public DuckDBTimestamp(Timestamp timestamp) {
        this.timeMicros = RefLocalDateTime.until(timestamp.toLocalDateTime(), ChronoUnit.MICROS);
    }

    public static Timestamp toSqlTimestamp(long l) {
        return Timestamp.valueOf(LocalDateTime.ofEpochSecond(DuckDBTimestamp.micros2seconds(l), DuckDBTimestamp.nanosPartMicros(l), ZoneOffset.UTC));
    }

    public static Timestamp toSqlTimestampNanos(long l) {
        return Timestamp.valueOf(LocalDateTime.ofEpochSecond(DuckDBTimestamp.nanos2seconds(l), DuckDBTimestamp.nanosPartNanos(l), ZoneOffset.UTC));
    }

    public static LocalDateTime toLocalDateTime(long l) {
        return LocalDateTime.ofEpochSecond(DuckDBTimestamp.micros2seconds(l), DuckDBTimestamp.nanosPartMicros(l), ZoneOffset.UTC);
    }

    public static OffsetTime toOffsetTime(long l) {
        long l2 = l >> 24;
        long l3 = l & 0xFFFFFFL;
        int n = (l3 -= 5612400L) < 0L ? -1 : 1;
        l3 = Math.abs(l3);
        int n2 = (int)l3 % 60;
        int n3 = (int)(l3 /= 60L) % 60;
        int n4 = (int)l3 / 60;
        if (n4 > 18) {
            return OffsetTime.of(DuckDBTimestamp.toLocalTime(l2), ZoneOffset.UTC);
        }
        return OffsetTime.of(DuckDBTimestamp.toLocalTime(l2), ZoneOffset.ofHoursMinutesSeconds(n * n4, n * n3, n * n2));
    }

    private static LocalTime toLocalTime(long l) {
        return LocalTime.ofNanoOfDay(l * 1000L);
    }

    public static OffsetDateTime toOffsetDateTime(long l) {
        return OffsetDateTime.of(DuckDBTimestamp.toLocalDateTime(l), ZoneOffset.UTC);
    }

    public static Timestamp fromSecondInstant(long l) {
        return DuckDBTimestamp.fromMilliInstant(l * 1000L);
    }

    public static Timestamp fromMilliInstant(long l) {
        return new Timestamp(l);
    }

    public static Timestamp fromMicroInstant(long l) {
        return Timestamp.from(Instant.ofEpochSecond(l / 1000000L, DuckDBTimestamp.nanosPartMicros(l)));
    }

    public static Timestamp fromNanoInstant(long l) {
        return Timestamp.from(Instant.ofEpochSecond(l / 1000000000L, DuckDBTimestamp.nanosPartNanos(l)));
    }

    public static long localDateTime2Micros(LocalDateTime localDateTime) {
        return RefLocalDateTime.until(localDateTime, ChronoUnit.MICROS);
    }

    public Timestamp toSqlTimestamp() {
        return Timestamp.valueOf(this.toLocalDateTime());
    }

    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.ofEpochSecond(DuckDBTimestamp.micros2seconds(this.timeMicros), DuckDBTimestamp.nanosPartMicros(this.timeMicros), ZoneOffset.UTC);
    }

    public OffsetDateTime toOffsetDateTime() {
        return OffsetDateTime.of(DuckDBTimestamp.toLocalDateTime(this.timeMicros), ZoneOffset.UTC);
    }

    public static long getMicroseconds(Timestamp timestamp) {
        return RefLocalDateTime.until(timestamp.toLocalDateTime(), ChronoUnit.MICROS);
    }

    public long getMicrosEpoch() {
        return this.timeMicros;
    }

    public String toString() {
        return this.toLocalDateTime().toString();
    }

    private static long micros2seconds(long l) {
        if (l % 1000000L >= 0L) {
            return l / 1000000L;
        }
        return l / 1000000L - 1L;
    }

    private static int nanosPartMicros(long l) {
        if (l % 1000000L >= 0L) {
            return (int)(l % 1000000L * 1000L);
        }
        return (int)((1000000L + l % 1000000L) * 1000L);
    }

    private static long nanos2seconds(long l) {
        if (l % 1000000000L >= 0L) {
            return l / 1000000000L;
        }
        return l / 1000000000L - 1L;
    }

    private static int nanosPartNanos(long l) {
        if (l % 1000000000L >= 0L) {
            return (int)(l % 1000000000L);
        }
        return (int)(1000000000L + l % 1000000000L);
    }
}

