/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams;

import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.spanner.Options;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class MetadataSpannerConfigFactory {
    public static @UnknownKeyFor @NonNull @Initialized SpannerConfig create(@UnknownKeyFor @NonNull @Initialized SpannerConfig primaryConfig, @UnknownKeyFor @NonNull @Initialized String metadataInstanceId, @UnknownKeyFor @NonNull @Initialized String metadataDatabaseId) {
        ValueProvider<Options.RpcPriority> rpcPriority;
        ImmutableSet<StatusCode.Code> retryableCodes;
        RetrySettings commitRetrySettings;
        RetrySettings executeStreamingSqlRetrySettings;
        ValueProvider<Duration> maxCumulativeBackoff;
        ValueProvider<Duration> commitDeadline;
        ValueProvider<Boolean> isLocalChannelProvider;
        ValueProvider<String> emulatorHost;
        ValueProvider<String> host;
        Preconditions.checkNotNull((Object)metadataInstanceId, (Object)"MetadataSpannerConfigFactory.create requires non-null metadata instance id");
        Preconditions.checkNotNull((Object)metadataDatabaseId, (Object)"MetadataSpannerConfigFactory.create requires non-null metadata database id");
        SpannerConfig config = SpannerConfig.create().withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)metadataInstanceId)).withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)metadataDatabaseId));
        ValueProvider<String> projectId = primaryConfig.getProjectId();
        if (projectId != null) {
            config = config.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)((String)projectId.get())));
        }
        if ((host = primaryConfig.getHost()) != null) {
            config = config.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)((String)host.get())));
        }
        if ((emulatorHost = primaryConfig.getEmulatorHost()) != null) {
            config = config.withEmulatorHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)((String)emulatorHost.get())));
        }
        if ((isLocalChannelProvider = primaryConfig.getIsLocalChannelProvider()) != null) {
            config = config.withIsLocalChannelProvider((ValueProvider<Boolean>)ValueProvider.StaticValueProvider.of((Object)((Boolean)isLocalChannelProvider.get())));
        }
        if ((commitDeadline = primaryConfig.getCommitDeadline()) != null) {
            config = config.withCommitDeadline((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)Duration.standardSeconds((long)60L)));
        }
        if ((maxCumulativeBackoff = primaryConfig.getMaxCumulativeBackoff()) != null) {
            config = config.withMaxCumulativeBackoff((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)((Duration)maxCumulativeBackoff.get())));
        }
        if ((executeStreamingSqlRetrySettings = primaryConfig.getExecuteStreamingSqlRetrySettings()) != null) {
            config = config.withExecuteStreamingSqlRetrySettings(executeStreamingSqlRetrySettings);
        }
        if ((commitRetrySettings = primaryConfig.getCommitRetrySettings()) != null) {
            config = config.withCommitRetrySettings(commitRetrySettings);
        }
        if ((retryableCodes = primaryConfig.getRetryableCodes()) != null) {
            config = config.withRetryableCodes(retryableCodes);
        }
        if ((rpcPriority = primaryConfig.getRpcPriority()) != null) {
            config = config.withRpcPriority((ValueProvider<Options.RpcPriority>)ValueProvider.StaticValueProvider.of((Object)((Options.RpcPriority)rpcPriority.get())));
        }
        return config;
    }
}

