/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.storage;

import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class GcsResourceId
implements ResourceId {
    private final @UnknownKeyFor @NonNull @Initialized GcsPath gcsPath;

    static @UnknownKeyFor @NonNull @Initialized GcsResourceId fromGcsPath(@UnknownKeyFor @NonNull @Initialized GcsPath gcsPath) {
        Preconditions.checkNotNull((Object)gcsPath, (Object)"gcsPath");
        return new GcsResourceId(gcsPath);
    }

    private GcsResourceId(@UnknownKeyFor @NonNull @Initialized GcsPath gcsPath) {
        this.gcsPath = gcsPath;
    }

    public @UnknownKeyFor @NonNull @Initialized GcsResourceId resolve(@UnknownKeyFor @NonNull @Initialized String other, @UnknownKeyFor @NonNull @Initialized ResolveOptions resolveOptions) {
        Preconditions.checkState((boolean)this.isDirectory(), (Object)String.format("Expected the gcsPath is a directory, but had [%s].", this.gcsPath));
        Preconditions.checkArgument((resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_FILE) || resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY) ? 1 : 0) != 0, (Object)String.format("ResolveOptions: [%s] is not supported.", resolveOptions));
        if (resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_FILE)) {
            Preconditions.checkArgument((!other.endsWith("/") ? 1 : 0) != 0, (String)"The resolved file: [%s] should not end with '/'.", (Object)other);
            return GcsResourceId.fromGcsPath(this.gcsPath.resolve(other));
        }
        if (other.endsWith("/")) {
            return GcsResourceId.fromGcsPath(this.gcsPath.resolve(other));
        }
        return GcsResourceId.fromGcsPath(this.gcsPath.resolve(other + "/"));
    }

    public @UnknownKeyFor @NonNull @Initialized GcsResourceId getCurrentDirectory() {
        if (this.isDirectory()) {
            return this;
        }
        GcsPath parent = this.gcsPath.getParent();
        Preconditions.checkState((parent != null ? 1 : 0) != 0, (Object)String.format("Failed to get the current directory for path: [%s].", this.gcsPath));
        return GcsResourceId.fromGcsPath(parent);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDirectory() {
        return this.gcsPath.endsWith("/");
    }

    public @UnknownKeyFor @NonNull @Initialized String getScheme() {
        return "gs";
    }

    public @Nullable @UnknownKeyFor @Initialized String getFilename() {
        if (this.gcsPath.getNameCount() <= 1) {
            return null;
        }
        GcsPath gcsFilename = this.gcsPath.getFileName();
        return gcsFilename == null ? null : gcsFilename.toString();
    }

    @UnknownKeyFor @NonNull @Initialized GcsPath getGcsPath() {
        return this.gcsPath;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.gcsPath.toString();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (!(obj instanceof GcsResourceId)) {
            return false;
        }
        GcsResourceId other = (GcsResourceId)obj;
        return this.gcsPath.equals(other.gcsPath);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.gcsPath.hashCode();
    }
}

