/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fake;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.fake.Fake;
import org.apache.hop.pipeline.transforms.fake.FakeData;
import org.apache.hop.pipeline.transforms.fake.FakeField;

@Transform(id="Fake", image="fake.svg", name="i18n::Fake.Name", description="i18n::Fake.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::FakeMeta.keyword"}, documentationUrl="/pipeline/transforms/fake.html")
public class FakeMeta
extends BaseTransformMeta<Fake, FakeData> {
    @HopMetadataProperty(injectionKeyDescription="Fake.Injection.Locale")
    private String locale;
    @HopMetadataProperty(key="field", groupKey="fields", injectionGroupDescription="Fake.Injection.Fields")
    private List<FakeField> fields = new ArrayList<FakeField>();

    public FakeMeta clone() {
        FakeMeta copy = (FakeMeta)((Object)super.clone());
        copy.locale = this.locale;
        copy.fields = new ArrayList<FakeField>();
        for (FakeField field : this.fields) {
            copy.fields.add(new FakeField(field));
        }
        return copy;
    }

    public void setDefault() {
        this.locale = "en";
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (FakeField field : this.fields) {
            if (!field.isValid()) continue;
            Object v = null;
            v = field.getType().equals("DateAndTime") ? new ValueMetaDate(field.getName()) : new ValueMetaString(field.getName());
            v.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)v);
        }
    }

    public static final String[] getFakerLocales() {
        return new String[]{"ar", "bg", "by", "ca", "ca-CAT", "da-DK", "de", "de-AT", "de-CH", "ee", "en", "en-AU", "en-au-ocker", "en-BORK", "en-CA", "en-GB", "en-IND", "en-MS", "en-NEP", "en-NG", "en-NZ", "en-PAK", "en-SG", "en-UG", "en-US", "en-ZA", "es", "es-MX", "fa", "fi-FI", "fr", "fr-CA", "fr-CH", "he", "hu", "hy", "id", "in-ID", "it", "ja", "ko", "lv", "nb-NO", "nl", "no-NO", "pl", "pt", "pt-BR", "ru", "sk", "sv", "sv-SE", "th", "tr", "uk", "vi", "zh-CN", "zh-TW"};
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public List<FakeField> getFields() {
        return this.fields;
    }

    public void setFields(List<FakeField> fields) {
        this.fields = fields;
    }
}

