/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.BasePainter;
import org.apache.hop.core.gui.DPoint;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.Rectangle;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.partition.PartitionSchema;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePainterExtension;
import org.apache.hop.pipeline.engine.EngineComponent;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformPartitioningMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;

public class PipelinePainter
extends BasePainter<PipelineHopMeta, TransformMeta> {
    private static final Class<?> PKG = PipelinePainter.class;
    public static final String STRING_PARTITIONING_CURRENT_TRANSFORM = "PartitioningCurrentTransform";
    public static final String STRING_TRANSFORM_ERROR_LOG = "TransformErrorLog";
    public static final String STRING_HOP_TYPE_COPY = "HopTypeCopy";
    public static final String STRING_ROW_DISTRIBUTION = "RowDistribution";
    private PipelineMeta pipelineMeta;
    private Map<String, String> transformLogMap;
    private TransformMeta startHopTransform;
    private Point endHopLocation;
    private TransformMeta endHopTransform;
    private TransformMeta noInputTransform;
    private IStream.StreamType candidateHopType;
    private boolean startErrorHopTransform;
    private IPipelineEngine<PipelineMeta> pipeline;
    private boolean slowTransformIndicatorEnabled;
    private Map<String, RowBuffer> outputRowsMap;
    private Map<String, Object> stateMap;
    public static final String[] magnificationDescriptions = new String[]{"1000%", "800%", "600%", "400%", "200%", "150%", "100%", "75%", "50%", "25%"};

    public PipelinePainter(IGc gc, IVariables variables, PipelineMeta pipelineMeta, Point area, DPoint offset, PipelineHopMeta candidate, Rectangle selectRectangle, List<AreaOwner> areaOwners, int iconSize, int lineWidth, int gridSize, String noteFontName, int noteFontHeight, IPipelineEngine<PipelineMeta> pipeline, boolean slowTransformIndicatorEnabled, double zoomFactor, Map<String, RowBuffer> outputRowsMap, boolean drawingBorderAroundName, String mouseOverName, Map<String, Object> stateMap) {
        super(gc, variables, pipelineMeta, area, offset, selectRectangle, areaOwners, iconSize, lineWidth, gridSize, noteFontName, noteFontHeight, zoomFactor, drawingBorderAroundName, mouseOverName);
        this.pipelineMeta = pipelineMeta;
        this.candidate = candidate;
        this.pipeline = pipeline;
        this.slowTransformIndicatorEnabled = slowTransformIndicatorEnabled;
        this.outputRowsMap = outputRowsMap;
        this.transformLogMap = null;
        this.stateMap = stateMap;
    }

    public PipelinePainter(IGc gc, IVariables variables, PipelineMeta pipelineMeta, Point area, DPoint offset, PipelineHopMeta candidate, Rectangle selectionRectangle, List<AreaOwner> areaOwners, int iconSize, int lineWidth, int gridSize, String noteFontName, int noteFontHeight, double zoomFactor, boolean drawingEditIcons, String mouseOverName, Map<String, Object> stateMap) {
        this(gc, variables, pipelineMeta, area, offset, candidate, selectionRectangle, areaOwners, iconSize, lineWidth, gridSize, noteFontName, noteFontHeight, null, false, zoomFactor, new HashMap<String, RowBuffer>(), drawingEditIcons, mouseOverName, stateMap);
    }

    private static String[] getPeekTitles() {
        String[] titles = new String[]{BaseMessages.getString(PKG, (String)"PeekMetric.Column.Copynr", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Read", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Written", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Input", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Output", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Updated", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Rejected", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Errors", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Active", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Time", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Speed", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.PriorityBufferSizes", (String[])new String[0])};
        return titles;
    }

    public void drawPipelineImage() throws HopException {
        this.gc.setTransform(0.0f, 0.0f, 1.0f);
        this.gc.setBackground(IGc.EColor.BACKGROUND);
        this.gc.fillRectangle(0, 0, this.area.x, this.area.y);
        this.gc.setTransform((float)this.offset.x, (float)this.offset.y, this.magnification);
        this.gc.setAlpha(255);
        this.drawPipeline();
        this.gc.setTransform(0.0f, 0.0f, 1.0f);
        this.drawNavigationView();
        this.gc.dispose();
    }

    private void drawPipeline() throws HopException {
        TransformMeta transformMeta;
        int i;
        Point end;
        Point start;
        Point to;
        Point fr;
        int i2;
        if (this.gridSize > 1) {
            this.drawGrid();
        }
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)this.variables, (String)HopExtensionPoint.PipelinePainterStart.id, (Object)this);
        }
        catch (HopException e) {
            LogChannel.GENERAL.logError("Error in PipelinePainterStart extension point", (Throwable)e);
        }
        this.gc.setFont(IGc.EFont.NOTE);
        for (i2 = 0; i2 < this.pipelineMeta.nrNotes(); ++i2) {
            NotePadMeta ni = this.pipelineMeta.getNote(i2);
            this.drawNote(ni);
        }
        this.gc.setFont(IGc.EFont.GRAPH);
        this.gc.setBackground(IGc.EColor.BACKGROUND);
        for (i2 = 0; i2 < this.pipelineMeta.nrPipelineHops(); ++i2) {
            PipelineHopMeta hi = this.pipelineMeta.getPipelineHop(i2);
            this.drawHop(hi);
        }
        if (this.candidate != null) {
            this.drawHop((PipelineHopMeta)this.candidate, true);
        } else if (this.startHopTransform != null && this.endHopLocation != null) {
            IGc.EImage arrow;
            fr = this.startHopTransform.getLocation();
            to = this.endHopLocation;
            if (this.endHopTransform == null) {
                this.gc.setForeground(IGc.EColor.GRAY);
                arrow = IGc.EImage.ARROW_DISABLED;
            } else {
                this.gc.setForeground(IGc.EColor.BLUE);
                arrow = IGc.EImage.ARROW_DEFAULT;
            }
            start = this.real2screen(fr.x + this.iconSize / 2, fr.y + this.iconSize / 2);
            end = this.real2screen(to.x, to.y);
            this.drawArrow(arrow, start.x, start.y, end.x, end.y, this.theta, this.calcArrowLength(), 1.2, (PipelineHopMeta)null, (Object)this.startHopTransform, this.endHopTransform == null ? this.endHopLocation : this.endHopTransform);
        } else if (this.endHopTransform != null && this.endHopLocation != null) {
            IGc.EImage arrow;
            fr = this.endHopLocation;
            to = this.endHopTransform.getLocation();
            if (this.startHopTransform == null) {
                this.gc.setForeground(IGc.EColor.GRAY);
                arrow = IGc.EImage.ARROW_DISABLED;
            } else {
                this.gc.setForeground(IGc.EColor.BLUE);
                arrow = IGc.EImage.ARROW_DEFAULT;
            }
            start = this.real2screen(fr.x, fr.y);
            end = this.real2screen(to.x + this.iconSize / 2, to.y + this.iconSize / 2);
            this.drawArrow(arrow, start.x, start.y, end.x, end.y, this.theta, this.calcArrowLength(), 1.2, (PipelineHopMeta)null, this.startHopTransform == null ? this.endHopLocation : this.startHopTransform, (Object)this.endHopTransform);
        }
        for (i = 0; i < this.pipelineMeta.nrTransforms(); ++i) {
            transformMeta = this.pipelineMeta.getTransform(i);
            this.drawTransform(transformMeta);
        }
        if (this.slowTransformIndicatorEnabled) {
            for (i = 0; i < this.pipelineMeta.nrTransforms(); ++i) {
                transformMeta = this.pipelineMeta.getTransform(i);
                this.checkDrawSlowTransformIndicator(transformMeta);
            }
        }
        for (i = 0; i < this.pipelineMeta.nrTransforms(); ++i) {
            transformMeta = this.pipelineMeta.getTransform(i);
            this.drawTransformInformationIndicator(transformMeta);
            this.drawTransformStatusIndicator(transformMeta);
        }
        if (this.outputRowsMap != null && !this.outputRowsMap.isEmpty()) {
            for (i = 0; i < this.pipelineMeta.nrTransforms(); ++i) {
                transformMeta = this.pipelineMeta.getTransform(i);
                this.drawTransformOutputIndicator(transformMeta);
            }
        }
        for (i = 0; i < this.pipelineMeta.nrTransforms(); ++i) {
            transformMeta = this.pipelineMeta.getTransform(i);
            this.drawTransformPerformanceTable(transformMeta);
        }
        if (this.noInputTransform != null) {
            this.gc.setLineWidth(2);
            this.gc.setForeground(IGc.EColor.RED);
            Point n = this.noInputTransform.getLocation();
            this.gc.drawLine(n.x - 5, n.y - 5, n.x + this.iconSize + 10, n.y + this.iconSize + 10);
            this.gc.drawLine(n.x - 5, n.y + this.iconSize + 5, n.x + this.iconSize + 5, n.y - 5);
        }
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)this.variables, (String)HopExtensionPoint.PipelinePainterEnd.id, (Object)this);
        }
        catch (HopException e) {
            LogChannel.GENERAL.logError("Error in PipelinePainterEnd extension point", (Throwable)e);
        }
        this.drawRect(this.selectionRectangle);
    }

    private void checkDrawSlowTransformIndicator(TransformMeta transformMeta) {
        if (transformMeta == null) {
            return;
        }
        if (this.pipeline != null) {
            Point pt = transformMeta.getLocation();
            if (pt == null) {
                pt = new Point(50, 50);
            }
            Point screen = this.real2screen(pt.x, pt.y);
            int x = screen.x;
            int y = screen.y;
            List<IEngineComponent> components = this.pipeline.getComponents();
            for (IEngineComponent component : components) {
                if (!component.getName().equals(transformMeta.getName())) continue;
                if (component.isRunning()) {
                    Long inputRowsValue = component.getInputBufferSize();
                    Long outputRowsValue = component.getOutputBufferSize();
                    if (inputRowsValue != null && outputRowsValue != null) {
                        long outputRows;
                        boolean isSlow;
                        long inputRows = inputRowsValue;
                        boolean bl = isSlow = (double)inputRows * 0.85 > (double)(outputRows = outputRowsValue.longValue());
                        if (isSlow) {
                            if (transformMeta.isSelected()) {
                                this.gc.setLineWidth(this.lineWidth + 2);
                            } else {
                                this.gc.setLineWidth(this.lineWidth);
                            }
                            if (System.currentTimeMillis() % 2000L > 1000L) {
                                this.gc.setForeground(IGc.EColor.BACKGROUND);
                                this.gc.setLineStyle(IGc.ELineStyle.SOLID);
                                this.gc.drawRoundRectangle(x - 1, y - 1, this.iconSize + 1, this.iconSize + 1, 8, 8);
                                this.gc.setForeground(IGc.EColor.DARKGRAY);
                                this.gc.setLineStyle(IGc.ELineStyle.DOT);
                                this.gc.drawRoundRectangle(x - 1, y - 1, this.iconSize + 1, this.iconSize + 1, 8, 8);
                            } else {
                                this.gc.setForeground(IGc.EColor.DARKGRAY);
                                this.gc.setLineStyle(IGc.ELineStyle.SOLID);
                                this.gc.drawRoundRectangle(x - 1, y - 1, this.iconSize + 1, this.iconSize + 1, 8, 8);
                                this.gc.setForeground(IGc.EColor.BACKGROUND);
                                this.gc.setLineStyle(IGc.ELineStyle.DOT);
                                this.gc.drawRoundRectangle(x - 1, y - 1, this.iconSize + 1, this.iconSize + 1, 8, 8);
                            }
                        }
                    }
                }
                this.gc.setLineStyle(IGc.ELineStyle.SOLID);
            }
        }
    }

    private void drawTransformPerformanceTable(TransformMeta transformMeta) {
        if (transformMeta == null) {
            return;
        }
        if (this.pipeline != null) {
            Point pt = transformMeta.getLocation();
            if (pt == null) {
                pt = new Point(50, 50);
            }
            Point screen = this.real2screen(pt.x, pt.y);
            int x = screen.x;
            int y = screen.y;
            List<IEngineComponent> transforms = this.pipeline.getComponentCopies(transformMeta.getName());
            if (this.pipeline.isRunning() && transformMeta.isSelected()) {
                String[] titles;
                int popupX = x;
                int popupY = y;
                int popupWidth = 0;
                int popupHeight = 1;
                this.gc.setFont(IGc.EFont.SMALL);
                Point p = this.gc.textExtent("0000000000");
                int colWidth = p.x + 5;
                int rowHeight = p.y + 5;
                int titleWidth = 0;
                for (String title : titles = PipelinePainter.getPeekTitles()) {
                    Point titleExtent = this.gc.textExtent(title);
                    titleWidth = Math.max(titleExtent.x + 5, titleWidth);
                    popupHeight += titleExtent.y + 5;
                }
                popupWidth = titleWidth + 10;
                popupY = popupY - popupHeight - 5;
                this.gc.setForeground(IGc.EColor.DARKGRAY);
                this.gc.setBackground(IGc.EColor.LIGHTGRAY);
                this.gc.setLineWidth(1);
                this.gc.fillRoundRectangle(popupX += (this.iconSize - (popupWidth += transforms.size() * colWidth)) / 2, popupY, popupWidth, popupHeight, 7, 7);
                this.gc.setBackground(IGc.EColor.LIGHTGRAY);
                this.gc.drawRoundRectangle(popupX, popupY, popupWidth, popupHeight, 7, 7);
                int barY = popupY;
                for (int i = 0; i < titles.length; ++i) {
                    if (i % 2 == 1) {
                        this.gc.setBackground(IGc.EColor.BACKGROUND);
                    } else {
                        this.gc.setBackground(IGc.EColor.LIGHTGRAY);
                    }
                    this.gc.fillRoundRectangle(popupX + 1, barY + 1, popupWidth - 2, rowHeight, 7, 7);
                    barY += rowHeight;
                }
                int rowY = popupY + 5;
                int rowX = popupX + 5;
                this.gc.setForeground(IGc.EColor.BLACK);
                this.gc.setBackground(IGc.EColor.BACKGROUND);
                for (int i = 0; i < titles.length; ++i) {
                    if (i % 2 == 1) {
                        this.gc.setBackground(IGc.EColor.BACKGROUND);
                    } else {
                        this.gc.setBackground(IGc.EColor.LIGHTGRAY);
                    }
                    this.gc.drawText(titles[i], rowX, rowY);
                    rowY += rowHeight;
                }
                this.gc.setBackground(IGc.EColor.LIGHTGRAY);
                rowX += titleWidth;
                for (IEngineComponent transform : transforms) {
                    rowX += colWidth;
                    rowY = popupY + 5;
                    String[] fields = this.getPeekFields(transform);
                    for (int i = 0; i < fields.length; ++i) {
                        if (i % 2 == 1) {
                            this.gc.setBackground(IGc.EColor.BACKGROUND);
                        } else {
                            this.gc.setBackground(IGc.EColor.LIGHTGRAY);
                        }
                        this.drawTextRightAligned(fields[i], rowX, rowY);
                        rowY += rowHeight;
                    }
                }
            }
        }
    }

    public String[] getPeekFields(IEngineComponent component) {
        String speed;
        String duration;
        long durationMs;
        Date firstRowReadDate = component.getFirstRowReadDate();
        if (firstRowReadDate != null) {
            durationMs = System.currentTimeMillis() - firstRowReadDate.getTime();
            duration = Utils.getDurationHMS((double)((double)durationMs / 1000.0));
        } else {
            durationMs = 0L;
            duration = "";
        }
        if (durationMs > 0L) {
            long maxReadWritten = Math.max(component.getLinesRead(), component.getLinesWritten());
            long maxInputOutput = Math.max(component.getLinesInput(), component.getLinesOutput());
            long processed = Math.max(maxReadWritten, maxInputOutput);
            double durationSec = (double)durationMs / 1000.0;
            double rowsPerSec = (double)processed / durationSec;
            speed = new DecimalFormat("##,###,##0").format(rowsPerSec);
        } else {
            speed = "-";
        }
        boolean active = firstRowReadDate != null && component.getLastRowWrittenDate() == null;
        String[] fields = new String[]{Integer.toString(component.getCopyNr()), Long.toString(component.getLinesRead()), Long.toString(component.getLinesWritten()), Long.toString(component.getLinesInput()), Long.toString(component.getLinesOutput()), Long.toString(component.getLinesUpdated()), Long.toString(component.getLinesRejected()), Long.toString(component.getErrors()), active ? "Yes" : "No", duration, speed, component.getInputBufferSize() + "/" + component.getOutputBufferSize()};
        return fields;
    }

    private void drawTransformInformationIndicator(TransformMeta transformMeta) throws HopException {
        if (!Utils.isEmpty((CharSequence)transformMeta.getDescription())) {
            Point pt = transformMeta.getLocation();
            if (pt == null) {
                pt = new Point(50, 50);
            }
            Point screen = this.real2screen(pt.x, pt.y);
            int x = screen.x;
            int y = screen.y;
            int xInfo = x - this.miniIconSize / 2 - 1;
            int yInfo = y - this.miniIconSize / 2 - 1;
            this.gc.drawImage(IGc.EImage.INFO_DISABLED, xInfo, yInfo, this.magnification);
            this.areaOwners.add(new AreaOwner<PipelineMeta, TransformMeta>(AreaOwner.AreaType.TRANSFORM_INFO_ICON, xInfo, yInfo, this.miniIconSize, this.miniIconSize, this.offset, this.pipelineMeta, transformMeta));
        }
    }

    private void drawTransformStatusIndicator(TransformMeta transformMeta) throws HopException {
        if (transformMeta == null) {
            return;
        }
        if (this.pipeline != null) {
            Point pt = transformMeta.getLocation();
            if (pt == null) {
                pt = new Point(50, 50);
            }
            Point screen = this.real2screen(pt.x, pt.y);
            int x = screen.x;
            int y = screen.y;
            if (this.pipeline != null) {
                List<IEngineComponent> transforms = this.pipeline.getComponentCopies(transformMeta.getName());
                for (IEngineComponent transform : transforms) {
                    String transformStatus = transform.getStatusDescription();
                    if (transformStatus == null || !transformStatus.equalsIgnoreCase(EngineComponent.ComponentExecutionStatus.STATUS_FINISHED.getDescription())) continue;
                    this.gc.drawImage(IGc.EImage.SUCCESS, x + this.iconSize - this.miniIconSize / 2 + 1, y - this.miniIconSize / 2 - 1, this.magnification);
                }
            }
        }
    }

    private void drawTransformOutputIndicator(TransformMeta transformMeta) throws HopException {
        if (transformMeta == null) {
            return;
        }
        if (this.pipeline != null) {
            Point pt = transformMeta.getLocation();
            if (pt == null) {
                pt = new Point(50, 50);
            }
            Point screen = this.real2screen(pt.x, pt.y);
            int x = screen.x;
            int y = screen.y;
            RowBuffer rowBuffer = this.outputRowsMap.get(transformMeta.getName());
            if (rowBuffer != null && !rowBuffer.isEmpty()) {
                int iconWidth = this.miniIconSize;
                int iconX = x + this.iconSize - this.miniIconSize / 2 + 1;
                int iconY = y + this.iconSize - this.miniIconSize / 2 + 1;
                this.gc.drawImage(IGc.EImage.DATA, iconX, iconY, this.magnification);
                this.areaOwners.add(new AreaOwner<TransformMeta, RowBuffer>(AreaOwner.AreaType.TRANSFORM_OUTPUT_DATA, iconX, iconY, iconWidth, iconWidth, this.offset, transformMeta, rowBuffer));
            }
        }
    }

    private void drawTextRightAligned(String txt, int x, int y) {
        int off = this.gc.textExtent((String)txt).x;
        this.gc.drawText(txt, x -= off, y);
    }

    private void drawHop(PipelineHopMeta hi) throws HopException {
        this.drawHop(hi, false);
    }

    private void drawHop(PipelineHopMeta hi, boolean isCandidate) throws HopException {
        TransformMeta fs = hi.getFromTransform();
        TransformMeta ts = hi.getToTransform();
        if (fs != null && ts != null) {
            this.drawLine(fs, ts, hi, isCandidate);
        }
    }

    private void drawTransform(TransformMeta transformMeta) throws HopException {
        String log;
        if (transformMeta == null) {
            return;
        }
        boolean isDeprecated = transformMeta.isDeprecated();
        int alpha = this.gc.getAlpha();
        Point pt = transformMeta.getLocation();
        if (pt == null) {
            pt = new Point(50, 50);
        }
        Point screen = this.real2screen(pt.x, pt.y);
        int x = screen.x;
        int y = screen.y;
        boolean transformError = false;
        if (this.transformLogMap != null && !this.transformLogMap.isEmpty() && !Utils.isEmpty((CharSequence)(log = this.transformLogMap.get(transformMeta.getName())))) {
            transformError = true;
        }
        if (transformMeta.isPartitioned()) {
            this.gc.setLineWidth(1);
            this.gc.setForeground(IGc.EColor.MAGENTA);
            this.gc.setBackground(IGc.EColor.BACKGROUND);
            this.gc.setFont(IGc.EFont.GRAPH);
            PartitionSchema partitionSchema = transformMeta.getTransformPartitioningMeta().getPartitionSchema();
            if (partitionSchema != null) {
                Object nrInput = "Px";
                nrInput = partitionSchema.isDynamicallyDefined() ? (String)nrInput + Const.NVL((String)partitionSchema.getNumberOfPartitions(), (String)"?") : (String)nrInput + partitionSchema.getPartitionIDs().size();
                Point textExtent = this.gc.textExtent((String)nrInput);
                textExtent.x += 2;
                textExtent.y += 2;
                Point point = new Point(x - this.iconSize - this.iconSize / 2, y - this.iconSize - this.iconSize);
                this.gc.drawRectangle(point.x, point.y, textExtent.x, textExtent.y);
                this.gc.drawText((String)nrInput, point.x + 1, point.y + 1);
                this.gc.drawLine(point.x + textExtent.x / 2, point.y + textExtent.y, x + this.iconSize / 2, y + this.iconSize / 2);
                this.gc.setForeground(IGc.EColor.PURPULE);
                this.gc.drawText(Const.NVL((String)partitionSchema.getName(), (String)"<no partition name>"), point.x, point.y + textExtent.y + 3, true);
                this.areaOwners.add(new AreaOwner<TransformMeta, String>(AreaOwner.AreaType.TRANSFORM_PARTITIONING, point.x, point.y, textExtent.x, textExtent.y, this.offset, transformMeta, STRING_PARTITIONING_CURRENT_TRANSFORM));
            }
        }
        String name = transformMeta.getName();
        if (transformMeta.isSelected()) {
            this.gc.setLineWidth(this.lineWidth + 2);
        } else {
            this.gc.setLineWidth(this.lineWidth);
        }
        this.areaOwners.add(new AreaOwner<PipelineMeta, TransformMeta>(AreaOwner.AreaType.TRANSFORM_ICON, x, y, this.iconSize, this.iconSize, this.offset, this.pipelineMeta, transformMeta));
        this.gc.setBackground(IGc.EColor.BACKGROUND);
        this.gc.fillRoundRectangle(x - 1, y - 1, this.iconSize + 1, this.iconSize + 1, 8, 8);
        this.gc.drawTransformIcon(x, y, transformMeta, this.magnification);
        if (transformError || transformMeta.isMissing()) {
            this.gc.setForeground(IGc.EColor.RED);
        } else if (isDeprecated) {
            this.gc.setForeground(IGc.EColor.DEPRECATED);
        } else {
            this.gc.setForeground(IGc.EColor.CRYSTAL);
        }
        this.gc.drawRoundRectangle(x - 1, y - 1, this.iconSize + 1, this.iconSize + 1, 8, 8);
        Point namePosition = this.getNamePosition(name, screen, this.iconSize);
        Point nameExtent = this.gc.textExtent(name);
        if (this.isDrawingBorderAroundName()) {
            int tmpAlpha = this.gc.getAlpha();
            this.gc.setAlpha(230);
            this.gc.setBackground(IGc.EColor.LIGHTGRAY);
            this.gc.fillRoundRectangle(namePosition.x - 8, namePosition.y - 2, nameExtent.x + 15, nameExtent.y + 8, 25, 25);
            this.gc.setAlpha(tmpAlpha);
        }
        this.areaOwners.add(new AreaOwner<TransformMeta, String>(AreaOwner.AreaType.TRANSFORM_NAME, namePosition.x - 8, namePosition.y - 2, nameExtent.x + 15, nameExtent.y + 8, this.offset, transformMeta, name));
        this.gc.setForeground(IGc.EColor.BLACK);
        this.gc.setFont(IGc.EFont.GRAPH);
        this.gc.drawText(name, namePosition.x, namePosition.y + 2, true);
        boolean partitioned = false;
        if (name.equals(this.mouseOverName)) {
            this.gc.setLineWidth(this.lineWidth);
            this.gc.drawLine(namePosition.x, namePosition.y + nameExtent.y, namePosition.x + nameExtent.x, namePosition.y + nameExtent.y);
        }
        TransformPartitioningMeta meta = transformMeta.getTransformPartitioningMeta();
        if (transformMeta.isPartitioned() && meta != null) {
            partitioned = true;
        }
        if (!transformMeta.getCopiesString().equals("1") && !partitioned) {
            this.gc.setBackground(IGc.EColor.BACKGROUND);
            this.gc.setForeground(IGc.EColor.BLACK);
            String copies = "x" + transformMeta.getCopiesString();
            Point textExtent = this.gc.textExtent(copies);
            this.gc.drawText(copies, x - textExtent.x + 1, y - textExtent.y - 4, false);
            this.areaOwners.add(new AreaOwner<PipelineMeta, TransformMeta>(AreaOwner.AreaType.TRANSFORM_COPIES_TEXT, x - textExtent.x + 1, y - textExtent.y - 4, textExtent.x, textExtent.y, this.offset, this.pipelineMeta, transformMeta));
        }
        if (transformError) {
            String log2 = this.transformLogMap.get(transformMeta.getName());
            int xError = x + this.iconSize - this.miniIconSize / 2 + 1;
            int yError = y - this.miniIconSize / 2 - 1;
            this.gc.drawImage(IGc.EImage.FAILURE, xError, yError, this.magnification);
            this.areaOwners.add(new AreaOwner<String, String>(AreaOwner.AreaType.TRANSFORM_FAILURE_ICON, xError, yError, 16, 16, this.offset, log2, STRING_TRANSFORM_ERROR_LOG));
        }
        PipelinePainterExtension extension = new PipelinePainterExtension(this.gc, this.areaOwners, this.pipelineMeta, transformMeta, null, x, y, 0, 0, 0, 0, this.offset, this.iconSize, this.stateMap);
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)this.variables, (String)HopExtensionPoint.PipelinePainterTransform.id, (Object)extension);
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error calling extension point(s) for the pipeline painter transform", (Throwable)e);
        }
        this.gc.setAlpha(alpha);
    }

    public Point getNamePosition(String string, Point screen, int iconsize) {
        Point textsize = this.gc.textExtent(string);
        int xpos = screen.x + iconsize / 2 - textsize.x / 2;
        int ypos = screen.y + iconsize + 5;
        return new Point(xpos, ypos);
    }

    private void drawLine(TransformMeta from, TransformMeta to, PipelineHopMeta hop, boolean isCandidate) throws HopException {
        List<IStream> infoStreams;
        ITransformIOMeta ioMeta;
        IGc.EImage arrow;
        IGc.EColor color;
        int[] line = this.getLine(from, to);
        IGc.ELineStyle linestyle = IGc.ELineStyle.SOLID;
        int activeLinewidth = this.lineWidth;
        if (isCandidate) {
            color = IGc.EColor.BLUE;
            arrow = IGc.EImage.ARROW_CANDIDATE;
        } else if (hop.isEnabled()) {
            if (from.isSendingErrorRowsToTransform(to)) {
                color = IGc.EColor.RED;
                linestyle = IGc.ELineStyle.DASH;
                arrow = IGc.EImage.ARROW_ERROR;
            } else {
                color = IGc.EColor.HOP_DEFAULT;
                arrow = IGc.EImage.ARROW_DEFAULT;
            }
            ioMeta = from.getTransform().getTransformIOMeta();
            IStream targetStream = ioMeta.findTargetStream(to);
            if (targetStream != null) {
                if (targetStream.getStreamIcon() == StreamIcon.TRUE) {
                    color = IGc.EColor.HOP_TRUE;
                    arrow = IGc.EImage.ARROW_TRUE;
                } else if (targetStream.getStreamIcon() == StreamIcon.FALSE) {
                    color = IGc.EColor.HOP_FALSE;
                    arrow = IGc.EImage.ARROW_FALSE;
                }
            }
        } else {
            color = IGc.EColor.GRAY;
            arrow = IGc.EImage.ARROW_DISABLED;
        }
        if (hop.isSplit()) {
            activeLinewidth = this.lineWidth + 2;
        }
        if (!(infoStreams = (ioMeta = to.getTransform().getTransformIOMeta()).getInfoStreams()).isEmpty()) {
            for (IStream stream : infoStreams) {
                if (!from.getName().equalsIgnoreCase(stream.getTransformName()) || from.isPartitioned() && to.isPartitioned() || from.getCopies(this.variables) <= 1) continue;
                color = IGc.EColor.RED;
                arrow = IGc.EImage.ARROW_ERROR;
            }
        }
        this.gc.setForeground(color);
        this.gc.setLineStyle(linestyle);
        this.gc.setLineWidth(activeLinewidth);
        this.drawArrow(arrow, line, hop, from, to);
        if (hop.isSplit()) {
            this.gc.setLineWidth(this.lineWidth);
        }
        this.gc.setForeground(IGc.EColor.BLACK);
        this.gc.setBackground(IGc.EColor.BACKGROUND);
        this.gc.setLineStyle(IGc.ELineStyle.SOLID);
    }

    @Override
    protected void drawArrow(IGc.EImage arrow, int x1, int y1, int x2, int y2, double theta, int size, double factor, PipelineHopMeta pipelineHop, Object startObject, Object endObject) throws HopException {
        boolean q4;
        this.gc.drawLine(x1, y1, x2, y2);
        int a = Math.abs(x2 - x1);
        int b = Math.abs(y2 - y1);
        int dist = (int)Math.sqrt(a * a + b * b);
        if (factor < 0.0) {
            factor = dist >= 2 * this.iconSize ? 1.3 : 1.2;
        }
        int mx = (int)((double)x1 + factor * (double)(x2 - x1) / 2.0);
        int my = (int)((double)y1 + factor * (double)(y2 - y1) / 2.0);
        double angle = Math.atan2(y2 - y1, x2 - x1) + 1.5707963267948966;
        boolean q1 = Math.toDegrees(angle) >= 0.0 && Math.toDegrees(angle) < 90.0;
        boolean q2 = Math.toDegrees(angle) >= 90.0 && Math.toDegrees(angle) < 180.0;
        boolean q3 = Math.toDegrees(angle) >= 180.0 && Math.toDegrees(angle) < 270.0;
        boolean bl = q4 = Math.toDegrees(angle) >= 270.0 || Math.toDegrees(angle) < 0.0;
        if (q1 || q3) {
            this.gc.drawImage(arrow, mx, my + 1, this.magnification, angle);
        } else if (q2 || q4) {
            this.gc.drawImage(arrow, mx, my, this.magnification, angle);
        }
        if (startObject instanceof TransformMeta && endObject instanceof TransformMeta) {
            IGc.EImage image;
            IGc.EImage image2;
            ITransformIOMeta ioMeta;
            boolean targetHop;
            factor = 0.8;
            TransformMeta fs = (TransformMeta)startObject;
            TransformMeta ts = (TransformMeta)endObject;
            mx = (int)((double)x1 + factor * (double)(x2 - x1) / 2.0) - this.miniIconSize / 2;
            my = (int)((double)y1 + factor * (double)(y2 - y1) / 2.0) - this.miniIconSize / 2;
            boolean errorHop = fs.isSendingErrorRowsToTransform(ts) || this.startErrorHopTransform && fs.equals(this.startHopTransform);
            boolean bl2 = targetHop = Const.indexOfString((String)ts.getName(), (String[])fs.getTransform().getTransformIOMeta().getTargetTransformNames()) >= 0;
            if (targetHop) {
                ioMeta = fs.getTransform().getTransformIOMeta();
                IStream targetStream = ioMeta.findTargetStream(ts);
                if (targetStream != null) {
                    image2 = BasePainter.getStreamIconImage(targetStream.getStreamIcon(), pipelineHop.isEnabled());
                    this.gc.drawImage(image2, mx, my, this.magnification);
                    this.areaOwners.add(new AreaOwner<TransformMeta, IStream>(AreaOwner.AreaType.TRANSFORM_TARGET_HOP_ICON, mx, my, 16, 16, this.offset, fs, targetStream));
                }
            } else if (fs.isDistributes() && fs.getRowDistribution() != null && !ts.getTransformPartitioningMeta().isMethodMirror() && !errorHop) {
                SvgFile svgFile = fs.getRowDistribution().getDistributionImage();
                if (svgFile != null) {
                    this.gc.drawImage(svgFile, mx, my, 16, 16, this.magnification, 0.0);
                    this.areaOwners.add(new AreaOwner<TransformMeta, String>(AreaOwner.AreaType.ROW_DISTRIBUTION_ICON, mx, my, 16, 16, this.offset, fs, STRING_ROW_DISTRIBUTION));
                    mx += 16;
                }
            } else if (!(fs.isDistributes() || ts.getTransformPartitioningMeta().isMethodMirror() || errorHop)) {
                image = pipelineHop.isEnabled() ? IGc.EImage.COPY_ROWS : IGc.EImage.COPY_ROWS_DISABLED;
                this.gc.drawImage(image, mx, my, this.magnification);
                this.areaOwners.add(new AreaOwner<TransformMeta, String>(AreaOwner.AreaType.HOP_COPY_ICON, mx, my, 16, 16, this.offset, fs, STRING_HOP_TYPE_COPY));
                mx += 16;
            }
            if (errorHop) {
                image = pipelineHop.isEnabled() ? IGc.EImage.ERROR : IGc.EImage.ERROR_DISABLED;
                this.gc.drawImage(image, mx, my, this.magnification);
                this.areaOwners.add(new AreaOwner<TransformMeta, TransformMeta>(AreaOwner.AreaType.HOP_ERROR_ICON, mx, my, 16, 16, this.offset, fs, ts));
                mx += 16;
            }
            ioMeta = ts.getTransform().getTransformIOMeta();
            CharSequence[] infoTransformNames = ioMeta.getInfoTransformNames();
            if (this.candidateHopType == IStream.StreamType.INFO && ts.equals(this.endHopTransform) && fs.equals(this.startHopTransform) || Const.indexOfString((String)fs.getName(), (String[])infoTransformNames) >= 0) {
                image2 = pipelineHop.isEnabled() ? IGc.EImage.INFO : IGc.EImage.INFO_DISABLED;
                this.gc.drawImage(image2, mx, my, this.magnification);
                this.areaOwners.add(new AreaOwner<TransformMeta, TransformMeta>(AreaOwner.AreaType.HOP_INFO_ICON, mx, my, 16, 16, this.offset, fs, ts));
                mx += 16;
            }
            if (!Utils.isEmpty((CharSequence[])infoTransformNames)) {
                for (CharSequence infoTransform : infoTransformNames) {
                    if (!fs.getName().equalsIgnoreCase((String)infoTransform)) continue;
                    if (fs.isPartitioned() && ts.isPartitioned()) {
                        this.gc.drawImage(IGc.EImage.PARALLEL, mx, my, this.magnification);
                        this.areaOwners.add(new AreaOwner<TransformMeta, TransformMeta>(AreaOwner.AreaType.HOP_INFO_TRANSFORMS_PARTITIONED, mx, my, this.miniIconSize, this.miniIconSize, this.offset, fs, ts));
                        mx += 16;
                        continue;
                    }
                    if (fs.getCopies(this.variables) <= 1) continue;
                    this.gc.drawImage(IGc.EImage.ERROR, mx, my, this.magnification);
                    this.areaOwners.add(new AreaOwner<TransformMeta, TransformMeta>(AreaOwner.AreaType.HOP_INFO_TRANSFORM_COPIES_ERROR, mx, my, this.miniIconSize, this.miniIconSize, this.offset, fs, ts));
                    mx += 16;
                }
            }
        }
        PipelinePainterExtension extension = new PipelinePainterExtension(this.gc, this.areaOwners, this.pipelineMeta, null, pipelineHop, x1, y1, x2, y2, mx, my, this.offset, this.iconSize, this.stateMap);
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)this.variables, (String)HopExtensionPoint.PipelinePainterArrow.id, (Object)extension);
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error calling extension point(s) for the pipeline painter arrow", (Throwable)e);
        }
    }

    public Map<String, String> getTransformLogMap() {
        return this.transformLogMap;
    }

    public void setTransformLogMap(Map<String, String> transformLogMap) {
        this.transformLogMap = transformLogMap;
    }

    public void setStartHopTransform(TransformMeta startHopTransform) {
        this.startHopTransform = startHopTransform;
    }

    public void setEndHopLocation(Point endHopLocation) {
        this.endHopLocation = endHopLocation;
    }

    public void setNoInputTransform(TransformMeta noInputTransform) {
        this.noInputTransform = noInputTransform;
    }

    public void setEndHopTransform(TransformMeta endHopTransform) {
        this.endHopTransform = endHopTransform;
    }

    public void setCandidateHopType(IStream.StreamType candidateHopType) {
        this.candidateHopType = candidateHopType;
    }

    public void setStartErrorHopTransform(boolean startErrorHopTransform) {
        this.startErrorHopTransform = startErrorHopTransform;
    }

    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }

    public void setPipelineMeta(PipelineMeta pipelineMeta) {
        this.pipelineMeta = pipelineMeta;
    }

    public IPipelineEngine<PipelineMeta> getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(IPipelineEngine<PipelineMeta> pipeline) {
        this.pipeline = pipeline;
    }

    public boolean isSlowTransformIndicatorEnabled() {
        return this.slowTransformIndicatorEnabled;
    }

    public void setSlowTransformIndicatorEnabled(boolean slowTransformIndicatorEnabled) {
        this.slowTransformIndicatorEnabled = slowTransformIndicatorEnabled;
    }

    public TransformMeta getStartHopTransform() {
        return this.startHopTransform;
    }

    public Point getEndHopLocation() {
        return this.endHopLocation;
    }

    public TransformMeta getEndHopTransform() {
        return this.endHopTransform;
    }

    public TransformMeta getNoInputTransform() {
        return this.noInputTransform;
    }

    public IStream.StreamType getCandidateHopType() {
        return this.candidateHopType;
    }

    public boolean isStartErrorHopTransform() {
        return this.startErrorHopTransform;
    }

    public Map<String, RowBuffer> getOutputRowsMap() {
        return this.outputRowsMap;
    }

    public void setOutputRowsMap(Map<String, RowBuffer> outputRowsMap) {
        this.outputRowsMap = outputRowsMap;
    }

    public Map<String, Object> getStateMap() {
        return this.stateMap;
    }

    public void setStateMap(Map<String, Object> stateMap) {
        this.stateMap = stateMap;
    }
}

