/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.io.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.FlinkSourceSplit;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.compat.SplitEnumeratorCompat;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.SplitsAssignment;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkSourceSplitEnumerator<@UnknownKeyFor T>
implements SplitEnumeratorCompat<FlinkSourceSplit<T>, Map<Integer, List<FlinkSourceSplit<T>>>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkSourceSplitEnumerator.class);
    private final @UnknownKeyFor @NonNull @Initialized SplitEnumeratorContext<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> context;
    private final @UnknownKeyFor @NonNull @Initialized Source<T> beamSource;
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;
    private final @UnknownKeyFor @NonNull @Initialized int numSplits;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>>> pendingSplits;
    private @UnknownKeyFor @NonNull @Initialized boolean splitsInitialized;

    public FlinkSourceSplitEnumerator(@UnknownKeyFor @NonNull @Initialized SplitEnumeratorContext<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> context, @UnknownKeyFor @NonNull @Initialized Source<T> beamSource, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized int numSplits) {
        this.context = context;
        this.beamSource = beamSource;
        this.pipelineOptions = pipelineOptions;
        this.numSplits = numSplits;
        this.pendingSplits = new HashMap<Integer, List<FlinkSourceSplit<T>>>(numSplits);
        this.splitsInitialized = false;
    }

    public void start() {
        this.context.callAsync(() -> {
            try {
                LOG.info("Starting source {}", this.beamSource);
                List<Source<T>> beamSplitSourceList = this.splitBeamSource();
                HashMap<Integer, List> flinkSourceSplitsList = new HashMap<Integer, List>();
                int i = 0;
                for (Source<T> beamSplitSource : beamSplitSourceList) {
                    int targetSubtask = i % this.context.currentParallelism();
                    List splitsForTask = flinkSourceSplitsList.computeIfAbsent(targetSubtask, ignored -> new ArrayList());
                    splitsForTask.add(new FlinkSourceSplit<T>(i, beamSplitSource));
                    ++i;
                }
                return flinkSourceSplitsList;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (sourceSplits, error) -> {
            if (error != null) {
                throw new RuntimeException("Failed to start source enumerator.", (Throwable)error);
            }
            this.pendingSplits.putAll((Map<Integer, List<FlinkSourceSplit<T>>>)sourceSplits);
            this.splitsInitialized = true;
            this.sendPendingSplitsToSourceReaders();
        });
    }

    public void handleSplitRequest(@UnknownKeyFor @NonNull @Initialized int subtaskId, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String requesterHostname) {
    }

    public void addSplitsBack(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> splits, @UnknownKeyFor @NonNull @Initialized int subtaskId) {
        LOG.info("Adding splits {} back from subtask {}", splits, (Object)subtaskId);
        List splitsForSubtask = this.pendingSplits.computeIfAbsent(subtaskId, ignored -> new ArrayList());
        splitsForSubtask.addAll(splits);
    }

    public void addReader(@UnknownKeyFor @NonNull @Initialized int subtaskId) {
        List<FlinkSourceSplit<T>> splitsForSubtask = this.pendingSplits.remove(subtaskId);
        if (splitsForSubtask != null) {
            this.assignSplitsAndLog(splitsForSubtask, subtaskId);
        } else if (this.splitsInitialized) {
            LOG.info("There is no split for subtask {}. Signaling no more splits.", (Object)subtaskId);
            this.context.signalNoMoreSplits(subtaskId);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>>> snapshotState(@UnknownKeyFor @NonNull @Initialized long checkpointId) throws @UnknownKeyFor @NonNull @Initialized Exception {
        LOG.info("Taking snapshot for checkpoint {}", (Object)checkpointId);
        return this.snapshotState();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>>> snapshotState() throws @UnknownKeyFor @NonNull @Initialized Exception {
        return this.pendingSplits;
    }

    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    private @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Source<T>> splitBeamSource() throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.beamSource instanceof BoundedSource) {
            BoundedSource boundedSource = (BoundedSource)this.beamSource;
            long desiredSizeBytes = boundedSource.getEstimatedSizeBytes(this.pipelineOptions) / (long)this.numSplits;
            return boundedSource.split(desiredSizeBytes, this.pipelineOptions);
        }
        if (this.beamSource instanceof UnboundedSource) {
            List splits = ((UnboundedSource)this.beamSource).split(this.numSplits, this.pipelineOptions);
            LOG.info("Split source {} to {} splits", this.beamSource, (Object)splits);
            return splits;
        }
        throw new IllegalStateException("Unknown source type " + this.beamSource.getClass());
    }

    private void sendPendingSplitsToSourceReaders() {
        Iterator<Map.Entry<Integer, List<FlinkSourceSplit<T>>>> splitIter = this.pendingSplits.entrySet().iterator();
        while (splitIter.hasNext()) {
            Map.Entry<Integer, List<FlinkSourceSplit<T>>> entry = splitIter.next();
            int readerIndex = entry.getKey();
            int targetSubtask = readerIndex % this.context.currentParallelism();
            if (!this.context.registeredReaders().containsKey(targetSubtask)) continue;
            this.assignSplitsAndLog(entry.getValue(), targetSubtask);
            splitIter.remove();
        }
    }

    private void assignSplitsAndLog(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> splits, @UnknownKeyFor @NonNull @Initialized int subtaskId) {
        this.context.assignSplits(new SplitsAssignment(Collections.singletonMap(subtaskId, splits)));
        this.context.signalNoMoreSplits(subtaskId);
        LOG.info("Assigned splits {} to subtask {}", splits, (Object)subtaskId);
    }
}

