/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.unbounded;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.FlinkSourceReaderBase;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.FlinkSourceSplit;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.ValueWithRecordId;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.api.common.eventtime.Watermark;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.core.io.InputStatus;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkUnboundedSourceReader<@UnknownKeyFor T>
extends FlinkSourceReaderBase<T, WindowedValue<ValueWithRecordId<T>>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkUnboundedSourceReader.class);
    @VisibleForTesting
    protected static final @UnknownKeyFor @NonNull @Initialized String PENDING_BYTES_METRIC_NAME = "pendingBytes";
    private static final @UnknownKeyFor @NonNull @Initialized long SLEEP_ON_IDLE_MS = 50L;
    private static final @UnknownKeyFor @NonNull @Initialized long MIN_WATERMARK_EMIT_INTERVAL_MS = 10L;
    private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@Nullable @UnknownKeyFor @Initialized CompletableFuture<@UnknownKeyFor @Nullable @Initialized Void>> dataAvailableFutureRef = new AtomicReference();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized FlinkSourceReaderBase. @UnknownKeyFor @NonNull @Initialized ReaderAndOutput> readers = new ArrayList<FlinkSourceReaderBase.ReaderAndOutput>();
    private @UnknownKeyFor @NonNull @Initialized int currentReaderIndex = 0;
    private volatile @UnknownKeyFor @NonNull @Initialized boolean shouldEmitWatermark;
    private final @UnknownKeyFor @NonNull @Initialized LinkedHashMap<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>>> pendingCheckpoints = new LinkedHashMap();

    public FlinkUnboundedSourceReader(@UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized SourceReaderContext context, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @Nullable @UnknownKeyFor @Initialized Function<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<T>>, @UnknownKeyFor @NonNull @Initialized Long> timestampExtractor) {
        super(stepName, context, pipelineOptions, timestampExtractor);
    }

    @VisibleForTesting
    protected FlinkUnboundedSourceReader(@UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized SourceReaderContext context, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized ScheduledExecutorService executor, @Nullable @UnknownKeyFor @Initialized Function<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<T>>, @UnknownKeyFor @NonNull @Initialized Long> timestampExtractor) {
        super(stepName, executor, context, pipelineOptions, timestampExtractor);
    }

    @Override
    protected void addSplitsToUnfinishedForCheckpoint(@UnknownKeyFor @NonNull @Initialized long checkpointId, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> flinkSourceSplits) {
        this.pendingCheckpoints.put(checkpointId, flinkSourceSplits);
    }

    public void notifyCheckpointComplete(@UnknownKeyFor @NonNull @Initialized long checkpointId) throws @UnknownKeyFor @NonNull @Initialized Exception {
        super.notifyCheckpointComplete(checkpointId);
        ArrayList<Long> finalized = new ArrayList<Long>();
        for (Map.Entry<Long, List<FlinkSourceSplit<T>>> e : this.pendingCheckpoints.entrySet()) {
            if (e.getKey() > checkpointId) continue;
            for (FlinkSourceSplit<T> s : e.getValue()) {
                this.finalizeSourceSplit(s.getCheckpointMark());
            }
            finalized.add(e.getKey());
        }
        finalized.forEach(this.pendingCheckpoints::remove);
    }

    @Override
    public void start() {
        this.createPendingBytesGauge(this.context);
        Long watermarkInterval = ((FlinkPipelineOptions)this.pipelineOptions.as(FlinkPipelineOptions.class)).getAutoWatermarkInterval();
        if (watermarkInterval == null) {
            watermarkInterval = ((FlinkPipelineOptions)this.pipelineOptions.as(FlinkPipelineOptions.class)).getMaxBundleTimeMills() / 5L;
            watermarkInterval = watermarkInterval > 10L ? watermarkInterval : 10L;
            LOG.warn("AutoWatermarkInterval is not set, watermarks will be emitted at a default interval of {} ms", (Object)watermarkInterval);
        }
        this.scheduleTaskAtFixedRate(() -> {
            this.shouldEmitWatermark = true;
            CompletableFuture<Void> f = this.dataAvailableFutureRef.get();
            if (f != null) {
                f.complete(null);
            }
        }, watermarkInterval, watermarkInterval);
    }

    public @UnknownKeyFor @NonNull @Initialized InputStatus pollNext(@UnknownKeyFor @NonNull @Initialized ReaderOutput<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<T>>> output) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.checkExceptionAndMaybeThrow();
        this.maybeEmitWatermark();
        this.maybeCreateReaderForNewSplits();
        FlinkSourceReaderBase.ReaderAndOutput reader = this.nextReaderWithData();
        if (reader != null) {
            this.emitRecord(reader, output);
            return InputStatus.MORE_AVAILABLE;
        }
        if (this.noMoreSplits() && this.isEndOfAllReaders()) {
            LOG.info("No more splits and no reader available. Terminating consumption.");
            return InputStatus.END_OF_INPUT;
        }
        LOG.trace("No data available for now.");
        return InputStatus.NOTHING_AVAILABLE;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isEndOfAllReaders() {
        return this.allReaders().values().stream().allMatch(r -> FlinkUnboundedSourceReader.asUnbounded(r.reader).getWatermark().getMillis() >= BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis());
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @Nullable @Initialized Void> isAvailableForAliveReaders() {
        CompletableFuture<Void> future = this.dataAvailableFutureRef.get();
        if (future == null) {
            CompletableFuture<Void> newFuture = new CompletableFuture<Void>();
            this.dataAvailableFutureRef.set(newFuture);
            if (this.shouldEmitWatermark || this.hasException()) {
                this.dataAvailableFutureRef.set(null);
                newFuture.complete(null);
            } else {
                LOG.debug("There is no data available, scheduling the idle reader checker.");
                this.scheduleTask(() -> {
                    CompletableFuture<Void> f = this.dataAvailableFutureRef.get();
                    if (f != null) {
                        f.complete(null);
                    }
                }, 50L);
            }
            return newFuture;
        }
        if (future.isDone()) {
            this.dataAvailableFutureRef.compareAndSet(future, null);
            return future;
        }
        return future;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T> getReaderCheckpoint(@UnknownKeyFor @NonNull @Initialized int splitId, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized FlinkSourceReaderBase. @UnknownKeyFor @NonNull @Initialized ReaderAndOutput readerAndOutput) {
        UnboundedSource.UnboundedReader reader = (UnboundedSource.UnboundedReader)readerAndOutput.reader;
        UnboundedSource.CheckpointMark checkpointMark = reader.getCheckpointMark();
        Coder coder = reader.getCurrentSource().getCheckpointMarkCoder();
        byte[] checkpointState = this.encodeCheckpointMark(coder, checkpointMark);
        return new FlinkSourceSplit(splitId, readerAndOutput.reader.getCurrentSource(), checkpointState, checkpointMark);
    }

    @Override
    protected // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Source.Reader<T> createReader(@Nonnull @UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T> sourceSplit) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Source<T> beamSource = sourceSplit.getBeamSplitSource();
        return this.createUnboundedSourceReader(beamSource, sourceSplit.getSplitState());
    }

    private void emitRecord(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized FlinkSourceReaderBase. @UnknownKeyFor @NonNull @Initialized ReaderAndOutput readerAndOutput, @UnknownKeyFor @NonNull @Initialized ReaderOutput<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<T>>> output) {
        UnboundedSource.UnboundedReader reader = FlinkUnboundedSourceReader.asUnbounded(readerAndOutput.reader);
        Object item = reader.getCurrent();
        byte[] recordId = reader.getCurrentRecordId();
        Instant timestamp = reader.getCurrentTimestamp();
        WindowedValue windowedValue = WindowedValue.of((Object)new ValueWithRecordId(item, recordId), (Instant)timestamp, (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING);
        LOG.trace("Emitting record: {}", (Object)windowedValue);
        if (this.timestampExtractor == null) {
            readerAndOutput.getAndMaybeCreateSplitOutput(output).collect((Object)windowedValue);
        } else {
            readerAndOutput.getAndMaybeCreateSplitOutput(output).collect((Object)windowedValue, ((Long)this.timestampExtractor.apply(windowedValue)).longValue());
        }
        this.numRecordsInCounter.inc();
    }

    private void maybeEmitWatermark() {
        if (this.shouldEmitWatermark) {
            this.allReaders().values().forEach(readerAndOutput -> {
                SourceOutput sourceOutput = readerAndOutput.sourceOutput();
                if (sourceOutput != null) {
                    long watermark = FlinkUnboundedSourceReader.asUnbounded(readerAndOutput.reader).getWatermark().getMillis();
                    sourceOutput.emitWatermark(new Watermark(watermark));
                }
            });
            this.shouldEmitWatermark = false;
        }
    }

    private void maybeCreateReaderForNewSplits() throws @UnknownKeyFor @NonNull @Initialized Exception {
        while (!this.sourceSplits().isEmpty()) {
            Optional<FlinkSourceReaderBase.ReaderAndOutput> readerAndOutputOpt = this.createAndTrackNextReader();
            if (readerAndOutputOpt.isPresent()) {
                this.readers.add(readerAndOutputOpt.get());
                continue;
            }
            this.checkExceptionAndMaybeThrow();
        }
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized FlinkSourceReaderBase. @Nullable @UnknownKeyFor @Initialized ReaderAndOutput nextReaderWithData() throws @UnknownKeyFor @NonNull @Initialized IOException {
        int numReaders = this.readers.size();
        for (int i = 0; i < numReaders; ++i) {
            FlinkSourceReaderBase.ReaderAndOutput readerAndOutput = this.readers.get(this.currentReaderIndex);
            this.currentReaderIndex = (this.currentReaderIndex + 1) % numReaders;
            if (!readerAndOutput.startOrAdvance()) continue;
            return readerAndOutput;
        }
        return null;
    }

    private static <T> // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<T> asUnbounded(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Source.Reader<T> reader) {
        return (UnboundedSource.UnboundedReader)reader;
    }

    private void createPendingBytesGauge(@UnknownKeyFor @NonNull @Initialized SourceReaderContext context) {
        context.metricGroup().gauge(PENDING_BYTES_METRIC_NAME, () -> {
            long pendingBytes = -1L;
            for (FlinkSourceReaderBase.ReaderAndOutput readerAndOutput : this.allReaders().values()) {
                long pendingBytesForReader = FlinkUnboundedSourceReader.asUnbounded(readerAndOutput.reader).getSplitBacklogBytes();
                if (pendingBytesForReader == -1L) continue;
                pendingBytes = pendingBytes == -1L ? pendingBytesForReader : pendingBytes + pendingBytesForReader;
            }
            return pendingBytes;
        });
    }

    private <CheckpointMarkT extends UnboundedSource.CheckpointMark> @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodeCheckpointMark(@UnknownKeyFor @NonNull @Initialized Coder<CheckpointMarkT> coder, CheckpointMarkT checkpointMark) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            coder.encode(checkpointMark, (OutputStream)baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    FlinkUnboundedSourceReader.$closeResource(throwable, baos);
                    throw throwable3;
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to encode checkpoint mark.", ioe);
            }
        }
        FlinkUnboundedSourceReader.$closeResource(throwable, baos);
        return byArray;
    }

    private <CheckpointMarkT extends UnboundedSource.CheckpointMark> // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Source.Reader<T> createUnboundedSourceReader(@UnknownKeyFor @NonNull @Initialized Source<T> beamSource, @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] splitState) throws @UnknownKeyFor @NonNull @Initialized IOException {
        UnboundedSource unboundedSource = (UnboundedSource)beamSource;
        Coder coder = unboundedSource.getCheckpointMarkCoder();
        if (splitState == null) {
            return unboundedSource.createReader(this.pipelineOptions, null);
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(splitState);){
            UnboundedSource.UnboundedReader unboundedReader = unboundedSource.createReader(this.pipelineOptions, (UnboundedSource.CheckpointMark)coder.decode((InputStream)bais));
            return unboundedReader;
        }
    }

    private void finalizeSourceSplit(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable @UnknownKeyFor @Initialized UnboundedSource.CheckpointMark mark) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (mark != null) {
            mark.finalizeCheckpoint();
        }
    }
}

