/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.joda.time.Instant;

class WindowAssignTranslatorBatch<T>
extends TransformTranslator<PCollection<T>, PCollection<T>, Window.Assign<T>> {
    WindowAssignTranslatorBatch() {
        super(0.05f);
    }

    @Override
    public void translate(Window.Assign<T> transform, TransformTranslator.Context cxt) {
        WindowFn windowFn = transform.getWindowFn();
        PCollection input = (PCollection)cxt.getInput();
        Dataset inputDataset = cxt.getDataset(input);
        if (windowFn == null || this.skipAssignWindows(windowFn, input)) {
            cxt.putDataset((PCollection)cxt.getOutput(), inputDataset);
        } else {
            Dataset outputDataset = inputDataset.map(WindowAssignTranslatorBatch.assignWindows(windowFn), cxt.windowedEncoder(input.getCoder(), windowFn.windowCoder()));
            cxt.putDataset((PCollection)cxt.getOutput(), outputDataset);
        }
    }

    private boolean skipAssignWindows(WindowFn<T, ?> newFn, PCollection<T> input) {
        WindowFn currentFn = input.getWindowingStrategy().getWindowFn();
        return currentFn instanceof GlobalWindows && newFn instanceof GlobalWindows;
    }

    private static <T, W extends BoundedWindow> MapFunction<WindowedValue<T>, WindowedValue<T>> assignWindows(WindowFn<T, W> windowFn) {
        return (MapFunction & Serializable)value -> {
            final BoundedWindow window = WindowAssignTranslatorBatch.getOnlyWindow(value);
            final Object element = value.getValue();
            final Instant timestamp = value.getTimestamp();
            WindowFn windowFn2 = windowFn;
            Objects.requireNonNull(windowFn2);
            Collection windows = windowFn.assignWindows(new WindowFn.AssignContext(windowFn2){

                public T element() {
                    return element;
                }

                public @NonNull Instant timestamp() {
                    return timestamp;
                }

                public @NonNull BoundedWindow window() {
                    return window;
                }
            });
            return WindowedValue.of((Object)element, (Instant)timestamp, (Collection)windows, (PaneInfo)value.getPane());
        };
    }

    private static <T> BoundedWindow getOnlyWindow(WindowedValue<T> wv) {
        return (BoundedWindow)Iterables.getOnlyElement((Iterable)wv.getWindows());
    }
}

