/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.runners.core.metrics.DistributionData;
import org.apache.beam.runners.core.metrics.GaugeData;
import org.apache.beam.runners.core.metrics.MetricUpdates;
import org.apache.beam.runners.core.metrics.MetricsMap;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricFiltering;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class DirectMetrics
extends MetricResults {
    private static final @UnknownKeyFor @NonNull @Initialized MetricAggregation<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long> COUNTER = new MetricAggregation<Long, Long>(){

        @Override
        public @UnknownKeyFor @NonNull @Initialized Long zero() {
            return 0L;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Long combine(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Long> updates) {
            long value = 0L;
            for (long update : updates) {
                value += update;
            }
            return value;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Long extract(@UnknownKeyFor @NonNull @Initialized Long data) {
            return data;
        }
    };
    private static final @UnknownKeyFor @NonNull @Initialized MetricAggregation<@UnknownKeyFor @NonNull @Initialized DistributionData, @UnknownKeyFor @NonNull @Initialized DistributionResult> DISTRIBUTION = new MetricAggregation<DistributionData, DistributionResult>(){

        @Override
        public @UnknownKeyFor @NonNull @Initialized DistributionData zero() {
            return DistributionData.EMPTY;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DistributionData combine(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized DistributionData> updates) {
            DistributionData result = DistributionData.EMPTY;
            for (DistributionData update : updates) {
                result = result.combine(update);
            }
            return result;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DistributionResult extract(@UnknownKeyFor @NonNull @Initialized DistributionData data) {
            return data.extractResult();
        }
    };
    private static final @UnknownKeyFor @NonNull @Initialized MetricAggregation<@UnknownKeyFor @NonNull @Initialized GaugeData, @UnknownKeyFor @NonNull @Initialized GaugeResult> GAUGE = new MetricAggregation<GaugeData, GaugeResult>(){

        @Override
        public @UnknownKeyFor @NonNull @Initialized GaugeData zero() {
            return GaugeData.empty();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized GaugeData combine(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized GaugeData> updates) {
            GaugeData result = GaugeData.empty();
            for (GaugeData update : updates) {
                result = result.combine(update);
            }
            return result;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized GaugeResult extract(@UnknownKeyFor @NonNull @Initialized GaugeData data) {
            return data.extractResult();
        }
    };
    private final @UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized MetricKey, @UnknownKeyFor @NonNull @Initialized DirectMetric<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long>> counters = new MetricsMap<MetricKey, DirectMetric>(unusedKey -> new DirectMetric<Long, Long>(COUNTER, executorService));
    private final @UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized MetricKey, @UnknownKeyFor @NonNull @Initialized DirectMetric<@UnknownKeyFor @NonNull @Initialized DistributionData, @UnknownKeyFor @NonNull @Initialized DistributionResult>> distributions = new MetricsMap<MetricKey, DirectMetric>(unusedKey -> new DirectMetric<DistributionData, DistributionResult>(DISTRIBUTION, executorService));
    private final @UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized MetricKey, @UnknownKeyFor @NonNull @Initialized DirectMetric<@UnknownKeyFor @NonNull @Initialized GaugeData, @UnknownKeyFor @NonNull @Initialized GaugeResult>> gauges = new MetricsMap<MetricKey, DirectMetric>(unusedKey -> new DirectMetric<GaugeData, GaugeResult>(GAUGE, executorService));

    DirectMetrics(@UnknownKeyFor @NonNull @Initialized ExecutorService executorService) {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MetricQueryResults queryMetrics(@Nullable @UnknownKeyFor @Initialized MetricsFilter filter) {
        ImmutableList.Builder counterResults = ImmutableList.builder();
        for (Map.Entry<MetricKey, DirectMetric<Long, Long>> entry : this.counters.entries()) {
            this.maybeExtractResult(filter, counterResults, entry);
        }
        ImmutableList.Builder distributionResults = ImmutableList.builder();
        for (Map.Entry<MetricKey, DirectMetric<DistributionData, DistributionResult>> entry : this.distributions.entries()) {
            this.maybeExtractResult(filter, distributionResults, entry);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<MetricKey, DirectMetric<GaugeData, GaugeResult>> gauge : this.gauges.entries()) {
            this.maybeExtractResult(filter, builder, gauge);
        }
        return MetricQueryResults.create(counterResults.build(), distributionResults.build(), builder.build());
    }

    private <ResultT> void maybeExtractResult(@UnknownKeyFor @NonNull @Initialized MetricsFilter filter, @UnknownKeyFor @NonNull @Initialized ImmutableList.Builder<@UnknownKeyFor @NonNull @Initialized MetricResult<ResultT>> resultsBuilder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized MetricKey, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DirectMetric<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, ResultT>> entry) {
        if (MetricFiltering.matches(filter, entry.getKey())) {
            resultsBuilder.add((Object)MetricResult.create(entry.getKey(), entry.getValue().extractCommitted(), entry.getValue().extractLatestAttempted()));
        }
    }

    public void updatePhysical(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> bundle, @UnknownKeyFor @NonNull @Initialized MetricUpdates updates) {
        for (MetricUpdates.MetricUpdate<Long> metricUpdate : updates.counterUpdates()) {
            this.counters.get(metricUpdate.getKey()).updatePhysical(bundle, metricUpdate.getUpdate());
        }
        for (MetricUpdates.MetricUpdate<Serializable> metricUpdate : updates.distributionUpdates()) {
            this.distributions.get(metricUpdate.getKey()).updatePhysical(bundle, (DistributionData)metricUpdate.getUpdate());
        }
        for (MetricUpdates.MetricUpdate<Serializable> metricUpdate : updates.gaugeUpdates()) {
            this.gauges.get(metricUpdate.getKey()).updatePhysical(bundle, (GaugeData)metricUpdate.getUpdate());
        }
    }

    public void commitPhysical(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> bundle, @UnknownKeyFor @NonNull @Initialized MetricUpdates updates) {
        for (MetricUpdates.MetricUpdate<Long> metricUpdate : updates.counterUpdates()) {
            this.counters.get(metricUpdate.getKey()).commitPhysical(bundle, metricUpdate.getUpdate());
        }
        for (MetricUpdates.MetricUpdate<Serializable> metricUpdate : updates.distributionUpdates()) {
            this.distributions.get(metricUpdate.getKey()).commitPhysical(bundle, (DistributionData)metricUpdate.getUpdate());
        }
        for (MetricUpdates.MetricUpdate<Serializable> metricUpdate : updates.gaugeUpdates()) {
            this.gauges.get(metricUpdate.getKey()).commitPhysical(bundle, (GaugeData)metricUpdate.getUpdate());
        }
    }

    public void commitLogical(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> bundle, @UnknownKeyFor @NonNull @Initialized MetricUpdates updates) {
        for (MetricUpdates.MetricUpdate<Long> metricUpdate : updates.counterUpdates()) {
            this.counters.get(metricUpdate.getKey()).commitLogical(bundle, metricUpdate.getUpdate());
        }
        for (MetricUpdates.MetricUpdate<Serializable> metricUpdate : updates.distributionUpdates()) {
            this.distributions.get(metricUpdate.getKey()).commitLogical(bundle, (DistributionData)metricUpdate.getUpdate());
        }
        for (MetricUpdates.MetricUpdate<Serializable> metricUpdate : updates.gaugeUpdates()) {
            this.gauges.get(metricUpdate.getKey()).commitLogical(bundle, (GaugeData)metricUpdate.getUpdate());
        }
    }

    private static class DirectMetric<@UnknownKeyFor UpdateT, @UnknownKeyFor ResultT> {
        private final @UnknownKeyFor @NonNull @Initialized MetricAggregation<UpdateT, ResultT> aggregation;
        private final @UnknownKeyFor @NonNull @Initialized Executor executor;
        private final @UnknownKeyFor @NonNull @Initialized AtomicReference<UpdateT> finishedCommitted;
        private final @UnknownKeyFor @NonNull @Initialized Object attemptedLock = new Object();
        @GuardedBy(value="attemptedLock")
        private volatile UpdateT finishedAttempted;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ConcurrentMap<@UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, UpdateT> inflightAttempted = new ConcurrentHashMap();

        public DirectMetric(@UnknownKeyFor @NonNull @Initialized MetricAggregation<UpdateT, ResultT> aggregation, @UnknownKeyFor @NonNull @Initialized Executor executor) {
            this.aggregation = aggregation;
            this.executor = executor;
            this.finishedCommitted = new AtomicReference<UpdateT>(aggregation.zero());
            this.finishedAttempted = aggregation.zero();
        }

        public void updatePhysical(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> bundle, UpdateT tentativeCumulative) {
            this.inflightAttempted.put(bundle, tentativeCumulative);
        }

        public void commitPhysical(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> bundle, UpdateT finalCumulative) {
            this.inflightAttempted.put(bundle, finalCumulative);
            this.executor.execute(() -> {
                Object object = this.attemptedLock;
                synchronized (object) {
                    this.finishedAttempted = this.aggregation.combine(Arrays.asList(this.finishedAttempted, finalCumulative));
                    this.inflightAttempted.remove(bundle);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResultT extractLatestAttempted() {
            ArrayList<Object> updates = new ArrayList<Object>(this.inflightAttempted.size() + 1);
            Object object = this.attemptedLock;
            synchronized (object) {
                updates.add(this.finishedAttempted);
                updates.addAll(this.inflightAttempted.values());
            }
            return this.aggregation.extract(this.aggregation.combine(updates));
        }

        public void commitLogical(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> bundle, UpdateT finalCumulative) {
            UpdateT current;
            do {
                current = this.finishedCommitted.get();
            } while (!this.finishedCommitted.compareAndSet(current, this.aggregation.combine(Arrays.asList(current, finalCumulative))));
        }

        public ResultT extractCommitted() {
            return this.aggregation.extract(this.finishedCommitted.get());
        }
    }

    private static interface MetricAggregation<@UnknownKeyFor UpdateT, @UnknownKeyFor ResultT> {
        public UpdateT zero();

        public UpdateT combine(@UnknownKeyFor @NonNull @Initialized Iterable<UpdateT> var1);

        public ResultT extract(UpdateT var1);
    }
}

