/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BigIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BigDecimalCoder
extends AtomicCoder<BigDecimal> {
    private static final @UnknownKeyFor @NonNull @Initialized BigDecimalCoder INSTANCE = new BigDecimalCoder();
    private static final @UnknownKeyFor @NonNull @Initialized VarIntCoder VAR_INT_CODER = VarIntCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized BigIntegerCoder BIG_INT_CODER = BigIntegerCoder.of();

    public static @UnknownKeyFor @NonNull @Initialized BigDecimalCoder of() {
        return INSTANCE;
    }

    private BigDecimalCoder() {
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized BigDecimal value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized BigDecimal value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        Preconditions.checkNotNull(value, String.format("cannot encode a null %s", BigDecimal.class.getSimpleName()));
        VAR_INT_CODER.encode(value.scale(), outStream);
        BIG_INT_CODER.encode(value.unscaledValue(), outStream, context);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BigDecimal decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BigDecimal decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        int scale = VAR_INT_CODER.decode(inStream);
        BigInteger bigInteger = BIG_INT_CODER.decode(inStream, context);
        return new BigDecimal(bigInteger, scale);
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        VAR_INT_CODER.verifyDeterministic();
        BIG_INT_CODER.verifyDeterministic();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized BigDecimal value) {
        return true;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized BigDecimal value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Preconditions.checkNotNull(value, String.format("cannot encode a null %s", BigDecimal.class.getSimpleName()));
        return VAR_INT_CODER.getEncodedElementByteSize(value.scale()) + BIG_INT_CODER.getEncodedElementByteSize(value.unscaledValue());
    }
}

