/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TimestampPrefixingWindowCoder<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
extends StructuredCoder<T> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> windowCoder;

    public static <T extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TimestampPrefixingWindowCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> windowCoder) {
        return new TimestampPrefixingWindowCoder<T>(windowCoder);
    }

    TimestampPrefixingWindowCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> windowCoder) {
        this.windowCoder = windowCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getWindowCoder() {
        return this.windowCoder;
    }

    @Override
    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        if (value == null) {
            throw new CoderException("Cannot encode null window");
        }
        InstantCoder.of().encode(((BoundedWindow)value).maxTimestamp(), outStream);
        this.windowCoder.encode(value, outStream);
    }

    @Override
    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        InstantCoder.of().decode(inStream);
        return (T)((BoundedWindow)this.windowCoder.decode(inStream));
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return Lists.newArrayList(this.windowCoder);
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        this.windowCoder.verifyDeterministic();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return this.windowCoder.consistentWithEquals();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(T value) {
        return this.windowCoder.isRegisterByteSizeObserverCheap(value);
    }

    @Override
    public void registerByteSizeObserver(T value, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
        InstantCoder.of().registerByteSizeObserver(((BoundedWindow)value).maxTimestamp(), observer);
        this.windowCoder.registerByteSizeObserver(value, observer);
    }
}

