/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.GetterBasedSchemaProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.annotations.SchemaIgnore;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.POJOUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class JavaFieldSchema
extends GetterBasedSchemaProvider {
    private static void validateFieldNumbers(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> types) {
        for (int i = 0; i < types.size(); ++i) {
            FieldValueTypeInformation type = types.get(i);
            Integer number = type.getNumber();
            if (number == null) {
                throw new RuntimeException("Unexpected null number for " + type.getName());
            }
            Preconditions.checkState(number == i, "Expected field number " + i + " for field + " + type.getName() + " instead got " + number);
        }
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized Schema schemaFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        return POJOUtils.schemaFromPojoClass(typeDescriptor.getRawType(), JavaFieldTypeSupplier.INSTANCE);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter> fieldValueGetters(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetClass, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return POJOUtils.getGetters(targetClass, schema, JavaFieldTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> fieldValueTypeInformations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetClass, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return POJOUtils.getFieldTypes(targetClass, schema, JavaFieldTypeSupplier.INSTANCE);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator schemaTypeCreator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetClass, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        Method annotated = ReflectUtils.getAnnotatedCreateMethod(targetClass);
        if (annotated != null) {
            return POJOUtils.getStaticCreator(targetClass, annotated, schema, JavaFieldTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
        }
        Constructor constructor = ReflectUtils.getAnnotatedConstructor(targetClass);
        if (constructor != null) {
            return POJOUtils.getConstructorCreator(targetClass, constructor, schema, JavaFieldTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
        }
        return POJOUtils.getSetFieldCreator(targetClass, schema, JavaFieldTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
    }

    @VisibleForTesting
    public static class JavaFieldTypeSupplier
    implements FieldValueTypeSupplier {
        public static final @UnknownKeyFor @NonNull @Initialized JavaFieldTypeSupplier INSTANCE = new JavaFieldTypeSupplier();

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> get(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
            Optional<Field> finalField;
            List fields = ReflectUtils.getFields(clazz).stream().filter(m -> !m.isAnnotationPresent(SchemaIgnore.class)).collect(Collectors.toList());
            ArrayList<FieldValueTypeInformation> types = Lists.newArrayListWithCapacity(fields.size());
            for (int i = 0; i < fields.size(); ++i) {
                types.add(FieldValueTypeInformation.forField((Field)fields.get(i), i));
            }
            types.sort(Comparator.comparing(FieldValueTypeInformation::getNumber));
            JavaFieldSchema.validateFieldNumbers(types);
            if (ReflectUtils.getAnnotatedCreateMethod(clazz) == null && ReflectUtils.getAnnotatedConstructor(clazz) == null && (finalField = types.stream().map(FieldValueTypeInformation::getField).filter(f -> Modifier.isFinal(f.getModifiers())).findAny()).isPresent()) {
                throw new IllegalArgumentException("Class " + clazz + " has final fields and no registered creator. Cannot use as schema, as we don't know how to create this object automatically");
            }
            return types;
        }
    }
}

