/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.testing.GatherAllPanes;
import org.apache.beam.sdk.testing.PaneExtractors;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.sdk.testing.SerializableMatchers;
import org.apache.beam.sdk.testing.StaticWindows;
import org.apache.beam.sdk.testing.SuccessOrFailure;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reify;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Never;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class PAssert {
    public static final @UnknownKeyFor @NonNull @Initialized String SUCCESS_COUNTER = "PAssertSuccess";
    public static final @UnknownKeyFor @NonNull @Initialized String FAILURE_COUNTER = "PAssertFailure";
    private static final @UnknownKeyFor @NonNull @Initialized Counter successCounter = Metrics.counter(PAssert.class, "PAssertSuccess");
    private static final @UnknownKeyFor @NonNull @Initialized Counter failureCounter = Metrics.counter(PAssert.class, "PAssertFailure");
    private static @UnknownKeyFor @NonNull @Initialized int assertCount = 0;

    private static @UnknownKeyFor @NonNull @Initialized String nextAssertionName() {
        return "PAssert$" + assertCount++;
    }

    private PAssert() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized IterableAssert<T> that(@UnknownKeyFor @NonNull @Initialized PCollection<T> actual) {
        return PAssert.that(actual.getName(), actual);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized IterableAssert<T> that(@UnknownKeyFor @NonNull @Initialized String reason, @UnknownKeyFor @NonNull @Initialized PCollection<T> actual) {
        return new PCollectionContentsAssert<T>(actual, PAssertionSite.capture(reason));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized IterableAssert<T> thatSingletonIterable(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<T>> actual) {
        return PAssert.thatSingletonIterable(actual.getName(), actual);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized IterableAssert<T> thatSingletonIterable(@UnknownKeyFor @NonNull @Initialized String reason, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<T>> actual) {
        PCollection actualIterables = actual;
        return new PCollectionSingletonIterableAssert(actualIterables, PAssertionSite.capture(reason));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SingletonAssert<T> thatSingleton(@UnknownKeyFor @NonNull @Initialized PCollection<T> actual) {
        return PAssert.thatSingleton(actual.getName(), actual);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SingletonAssert<T> thatSingleton(@UnknownKeyFor @NonNull @Initialized String reason, @UnknownKeyFor @NonNull @Initialized PCollection<T> actual) {
        return new PCollectionSingletonAssert<T>(actual, PAssertionSite.capture(reason));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized SingletonAssert<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> thatMultimap(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> actual) {
        return PAssert.thatMultimap(actual.getName(), actual);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized SingletonAssert<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> thatMultimap(@UnknownKeyFor @NonNull @Initialized String reason, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> actual) {
        KvCoder kvCoder = (KvCoder)actual.getCoder();
        return new PCollectionViewAssert(actual, View.asMultimap(), MapCoder.of(kvCoder.getKeyCoder(), IterableCoder.of(kvCoder.getValueCoder())), PAssertionSite.capture(reason));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized SingletonAssert<@UnknownKeyFor @NonNull @Initialized Map<K, V>> thatMap(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> actual) {
        return PAssert.thatMap(actual.getName(), actual);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized SingletonAssert<@UnknownKeyFor @NonNull @Initialized Map<K, V>> thatMap(@UnknownKeyFor @NonNull @Initialized String reason, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> actual) {
        KvCoder kvCoder = (KvCoder)actual.getCoder();
        return new PCollectionViewAssert(actual, View.asMap(), MapCoder.of(kvCoder.getKeyCoder(), kvCoder.getValueCoder()), PAssertionSite.capture(reason));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PCollectionListContentsAssert<T> thatList(@UnknownKeyFor @NonNull @Initialized PCollectionList<T> actual) {
        return new PCollectionListContentsAssert<T>(actual);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized IterableAssert<T> thatFlattened(@UnknownKeyFor @NonNull @Initialized PCollectionList<T> actual) {
        PCollection flatten = (PCollection)actual.apply(Flatten.pCollections());
        return PAssert.that(flatten.getName(), flatten);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized IterableAssert<T> thatFlattened(@UnknownKeyFor @NonNull @Initialized String reason, @UnknownKeyFor @NonNull @Initialized PCollectionList<T> actual) {
        return new PCollectionContentsAssert((PCollection)actual.apply(Flatten.pCollections()), PAssertionSite.capture(reason));
    }

    protected static <ActualT> @UnknownKeyFor @NonNull @Initialized SuccessOrFailure doChecks(@UnknownKeyFor @NonNull @Initialized PAssertionSite site, ActualT actualContents, @UnknownKeyFor @NonNull @Initialized SerializableFunction<ActualT, @UnknownKeyFor @Nullable @Initialized Void> checkerFn) {
        try {
            checkerFn.apply(actualContents);
            return SuccessOrFailure.success();
        }
        catch (Throwable t) {
            return SuccessOrFailure.failure(site, t);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized int countAsserts(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        AssertionCountingVisitor visitor = new AssertionCountingVisitor();
        pipeline.traverseTopologically(visitor);
        return visitor.getPAssertCount();
    }

    protected static class MatcherCheckerFn<@UnknownKeyFor T>
    implements SerializableFunction<T, Void> {
        private @UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> matcher;

        public MatcherCheckerFn(@UnknownKeyFor @NonNull @Initialized SerializableMatcher<T> matcher) {
            this.matcher = matcher;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Void apply(T actual) {
            MatcherAssert.assertThat(actual, this.matcher);
            return null;
        }
    }

    private static class AssertionCountingVisitor
    extends Pipeline.PipelineVisitor.Defaults {
        private @UnknownKeyFor @NonNull @Initialized int assertCount = 0;
        private @UnknownKeyFor @NonNull @Initialized boolean pipelineVisited = false;

        private AssertionCountingVisitor() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform( @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            if (node.isRootNode()) {
                Preconditions.checkState(!this.pipelineVisited, "Tried to visit a pipeline with an already used %s", (Object)AssertionCountingVisitor.class.getSimpleName());
            }
            if (!node.isRootNode() && (node.getTransform() instanceof OneSideInputAssert || node.getTransform() instanceof GroupThenAssert || node.getTransform() instanceof GroupThenAssertForSingleton)) {
                ++this.assertCount;
            }
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        @Override
        public void leaveCompositeTransform( @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            if (node.isRootNode()) {
                this.pipelineVisited = true;
            }
        }

        @Override
        public void visitPrimitiveTransform( @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            if (node.getTransform() instanceof OneSideInputAssert || node.getTransform() instanceof GroupThenAssert || node.getTransform() instanceof GroupThenAssertForSingleton) {
                ++this.assertCount;
            }
        }

        @UnknownKeyFor @NonNull @Initialized int getPAssertCount() {
            Preconditions.checkState(this.pipelineVisited);
            return this.assertCount;
        }
    }

    private static final class FilterWindows<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final @UnknownKeyFor @NonNull @Initialized StaticWindows windows;

        public FilterWindows(@UnknownKeyFor @NonNull @Initialized StaticWindows windows) {
            this.windows = windows;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            return (PCollection)input.apply("FilterWindows", ParDo.of(new Fn()));
        }

        private class Fn
        extends DoFn<T, T> {
            private Fn() {
            }

            @DoFn.ProcessElement
            public void processElement(@UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) throws @UnknownKeyFor @NonNull @Initialized Exception {
                if (FilterWindows.this.windows.getWindows().contains(window)) {
                    c.output(c.element());
                }
            }
        }
    }

    private static class IntoStaticWindows
    implements AssertionWindows {
        private final @UnknownKeyFor @NonNull @Initialized StaticWindows windowFn;

        public static @UnknownKeyFor @NonNull @Initialized AssertionWindows of(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return new IntoStaticWindows(StaticWindows.of(windowCoder, window));
        }

        private IntoStaticWindows(@UnknownKeyFor @NonNull @Initialized StaticWindows windowFn) {
            this.windowFn = windowFn;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> windowDummy() {
            return Window.into(this.windowFn);
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> prepareActuals() {
            return new FilterWindows(this.windowFn);
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> windowActuals() {
            return Window.into(this.windowFn.intoOnlyExisting());
        }
    }

    private static class IntoGlobalWindow
    implements AssertionWindows,
    Serializable {
        private IntoGlobalWindow() {
        }

        public static @UnknownKeyFor @NonNull @Initialized AssertionWindows of() {
            return new IntoGlobalWindow();
        }

        private <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> window() {
            return Window.into(new GlobalWindows());
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> windowDummy() {
            return this.window();
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> prepareActuals() {
            return this.window();
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> windowActuals() {
            return this.window();
        }
    }

    private static interface AssertionWindows {
        public <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> windowDummy();

        public <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> prepareActuals();

        public <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> windowActuals();
    }

    private static class AssertContainsInAnyOrderRelation<@UnknownKeyFor T>
    implements AssertRelation<Iterable<T>, Iterable<T>> {
        private AssertContainsInAnyOrderRelation() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<T>, @UnknownKeyFor @Nullable @Initialized Void> assertFor(@UnknownKeyFor @NonNull @Initialized Iterable<T> expectedElements) {
            return new AssertContainsInAnyOrder<T>(expectedElements);
        }
    }

    private static class AssertNotEqualToRelation<@UnknownKeyFor T>
    implements AssertRelation<T, T> {
        private AssertNotEqualToRelation() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @Nullable @Initialized Void> assertFor(T expected) {
            return new AssertNotEqualTo<T>(expected);
        }
    }

    private static class AssertIsEqualToRelation<@UnknownKeyFor T>
    implements AssertRelation<T, T> {
        private AssertIsEqualToRelation() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @Nullable @Initialized Void> assertFor(T expected) {
            return new AssertIsEqualTo<T>(expected);
        }
    }

    private static interface AssertRelation<@UnknownKeyFor ActualT, @UnknownKeyFor ExpectedT>
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized SerializableFunction<ActualT, @UnknownKeyFor @Nullable @Initialized Void> assertFor(ExpectedT var1);
    }

    private static class AssertContainsInAnyOrder<@UnknownKeyFor T>
    implements SerializableFunction<Iterable<T>, Void> {
        private T @UnknownKeyFor @NonNull @Initialized [] expected;

        @SafeVarargs
        public AssertContainsInAnyOrder(T ... expected) {
            this.expected = expected;
        }

        public AssertContainsInAnyOrder(@UnknownKeyFor @NonNull @Initialized Collection<T> expected) {
            this(expected.toArray());
        }

        public AssertContainsInAnyOrder(@UnknownKeyFor @NonNull @Initialized Iterable<T> expected) {
            this((Collection<T>)Lists.newArrayList(expected));
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Void apply(@UnknownKeyFor @NonNull @Initialized Iterable<T> actual) {
            MatcherAssert.assertThat(actual, (Matcher)Matchers.containsInAnyOrder((Object[])this.expected));
            return null;
        }
    }

    private static class AssertNotEqualTo<@UnknownKeyFor T>
    implements SerializableFunction<T, Void> {
        private T expected;

        public AssertNotEqualTo(T expected) {
            this.expected = expected;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Void apply(T actual) {
            MatcherAssert.assertThat(actual, (Matcher)Matchers.not((Matcher)Matchers.equalTo(this.expected)));
            return null;
        }
    }

    private static class AssertIsEqualTo<@UnknownKeyFor T>
    implements SerializableFunction<T, Void> {
        private T expected;

        public AssertIsEqualTo(T expected) {
            this.expected = expected;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Void apply(T actual) {
            MatcherAssert.assertThat(actual, (Matcher)Matchers.equalTo(this.expected));
            return null;
        }
    }

    private static class SingletonCheckerDoFn<@UnknownKeyFor ActualT>
    extends DoFn<Iterable<ActualT>, SuccessOrFailure> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<ActualT, @UnknownKeyFor @Nullable @Initialized Void> checkerFn;
        private final @UnknownKeyFor @NonNull @Initialized PAssertionSite site;

        private SingletonCheckerDoFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<ActualT, @UnknownKeyFor @Nullable @Initialized Void> checkerFn, @UnknownKeyFor @NonNull @Initialized PAssertionSite site) {
            this.checkerFn = checkerFn;
            this.site = site;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            Object actualContents = Iterables.getOnlyElement((Iterable)c.element());
            c.output(PAssert.doChecks(this.site, actualContents, this.checkerFn));
        }
    }

    private static class GroupedValuesCheckerDoFn<@UnknownKeyFor ActualT>
    extends DoFn<ActualT, SuccessOrFailure> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<ActualT, @UnknownKeyFor @Nullable @Initialized Void> checkerFn;
        private final @UnknownKeyFor @NonNull @Initialized PAssertionSite site;

        private GroupedValuesCheckerDoFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<ActualT, @UnknownKeyFor @Nullable @Initialized Void> checkerFn, @UnknownKeyFor @NonNull @Initialized PAssertionSite site) {
            this.checkerFn = checkerFn;
            this.site = site;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            c.output(PAssert.doChecks(this.site, c.element(), this.checkerFn));
        }
    }

    private static class SideInputCheckerDoFn<@UnknownKeyFor ActualT>
    extends DoFn<Integer, SuccessOrFailure> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<ActualT, @UnknownKeyFor @Nullable @Initialized Void> checkerFn;
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<ActualT> actual;
        private final @UnknownKeyFor @NonNull @Initialized PAssertionSite site;

        private SideInputCheckerDoFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<ActualT, @UnknownKeyFor @Nullable @Initialized Void> checkerFn, @UnknownKeyFor @NonNull @Initialized PCollectionView<ActualT> actual, @UnknownKeyFor @NonNull @Initialized PAssertionSite site) {
            this.checkerFn = checkerFn;
            this.actual = actual;
            this.site = site;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            ActualT actualContents = c.sideInput(this.actual);
            c.output(PAssert.doChecks(this.site, actualContents, this.checkerFn));
        }
    }

    public static class OneSideInputAssert<@UnknownKeyFor ActualT>
    extends PTransform<PBegin, PDone>
    implements Serializable {
        private final transient @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollectionView<ActualT>> createActual;
        private final transient @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Integer>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Integer>> windowToken;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<ActualT, @UnknownKeyFor @Nullable @Initialized Void> checkerFn;
        private final @UnknownKeyFor @NonNull @Initialized PAssertionSite site;

        private OneSideInputAssert(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollectionView<ActualT>> createActual, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Integer>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Integer>> windowToken, @UnknownKeyFor @NonNull @Initialized SerializableFunction<ActualT, @UnknownKeyFor @Nullable @Initialized Void> checkerFn, @UnknownKeyFor @NonNull @Initialized PAssertionSite site) {
            this.createActual = createActual;
            this.windowToken = windowToken;
            this.checkerFn = checkerFn;
            this.site = site;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            PCollectionView<ActualT> actual = input.apply("CreateActual", this.createActual);
            ((PCollection)((Object)((PCollection)input.apply(Create.of(0, new Integer[0]).withCoder(VarIntCoder.of()))).apply("WindowToken", this.windowToken).apply("RunChecks", ParDo.of(new SideInputCheckerDoFn(this.checkerFn, actual, this.site)).withSideInputs(actual)))).apply("VerifyAssertions", new DefaultConcludeTransform());
            return PDone.in(input.getPipeline());
        }
    }

    public static class GroupThenAssertForSingleton<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PDone>
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @Nullable @Initialized Void> checkerFn;
        private final @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowingStrategy;
        private final @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> paneExtractor;
        private final @UnknownKeyFor @NonNull @Initialized PAssertionSite site;

        private GroupThenAssertForSingleton(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @Nullable @Initialized Void> checkerFn, @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowingStrategy, @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> paneExtractor, @UnknownKeyFor @NonNull @Initialized PAssertionSite site) {
            this.checkerFn = checkerFn;
            this.rewindowingStrategy = rewindowingStrategy;
            this.paneExtractor = paneExtractor;
            this.site = site;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            ((PCollection)((PCollection)((Object)((PCollection)input.apply("GroupGlobally", new GroupGlobally(this.rewindowingStrategy))).apply("GetPane", MapElements.via(this.paneExtractor)))).setCoder(IterableCoder.of(input.getCoder())).apply("RunChecks", ParDo.of(new SingletonCheckerDoFn(this.checkerFn, this.site)))).apply("VerifyAssertions", new DefaultConcludeTransform());
            return PDone.in(input.getPipeline());
        }
    }

    public static class GroupThenAssert<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PDone>
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<T>, @UnknownKeyFor @Nullable @Initialized Void> checkerFn;
        private final @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowingStrategy;
        private final @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> paneExtractor;
        private final @UnknownKeyFor @NonNull @Initialized PAssertionSite site;

        private GroupThenAssert(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<T>, @UnknownKeyFor @Nullable @Initialized Void> checkerFn, @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowingStrategy, @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> paneExtractor, @UnknownKeyFor @NonNull @Initialized PAssertionSite site) {
            this.checkerFn = checkerFn;
            this.rewindowingStrategy = rewindowingStrategy;
            this.paneExtractor = paneExtractor;
            this.site = site;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            ((PCollection)((PCollection)((Object)((PCollection)input.apply("GroupGlobally", new GroupGlobally(this.rewindowingStrategy))).apply("GetPane", MapElements.via(this.paneExtractor)))).setCoder(IterableCoder.of(input.getCoder())).apply("RunChecks", ParDo.of(new GroupedValuesCheckerDoFn(this.checkerFn, this.site)))).apply("VerifyAssertions", new DefaultConcludeTransform());
            return PDone.in(input.getPipeline());
        }
    }

    private static final class ConcatFn<@UnknownKeyFor T>
    extends DoFn<Iterable<Iterable<T>>, Iterable<T>> {
        private ConcatFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            c.output(Iterables.concat((Iterable)c.element()));
        }
    }

    private static final class ToSingletonIterables<@UnknownKeyFor T>
    extends DoFn<T, Iterable<T>> {
        private ToSingletonIterables() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            c.output(ImmutableList.of(c.element()));
        }
    }

    private static class GroupGlobally<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<Iterable<ValueInSingleWindow<T>>>>
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowingStrategy;

        public GroupGlobally(@UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowingStrategy) {
            this.rewindowingStrategy = rewindowingStrategy;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            int combinedKey = 42;
            if (input.getWindowingStrategy().equals(WindowingStrategy.globalDefault()) && this.rewindowingStrategy instanceof IntoGlobalWindow) {
                PCollection actual = (PCollection)input.apply(Reify.windows()).apply(ParDo.of(new ToSingletonIterables()));
                PCollection dummy = (PCollection)input.getPipeline().apply(Create.of(ImmutableList.of(ImmutableList.of())).withCoder(actual.getCoder()));
                return (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)PCollectionList.of(dummy).and(actual).apply(Flatten.pCollections())).apply(input.isBounded() == PCollection.IsBounded.UNBOUNDED ? Window.configure().triggering(Never.ever()).discardingFiredPanes() : Window.configure())).apply(WithKeys.of(42))).apply(GroupByKey.create())).apply(Values.create())).apply(ParDo.of(new ConcatFn()));
            }
            Window removeTriggering = Window.configure().triggering(Never.ever()).discardingFiredPanes().withAllowedLateness(input.getWindowingStrategy().getAllowedLateness());
            PCollection groupedContents = (PCollection)((PCollection)((PCollection)input.apply(this.rewindowingStrategy.prepareActuals()).apply("GatherAllOutputs", GatherAllPanes.globally())).apply("RewindowActuals", this.rewindowingStrategy.windowActuals()).apply("KeyForDummy", WithKeys.of(42))).apply("RemoveActualsTriggering", removeTriggering);
            PCollection keyedDummy = (PCollection)((PCollection)input.getPipeline().apply(Create.of(KV.of(42, Collections.emptyList()), new KV[0]).withCoder(groupedContents.getCoder()))).apply("WindowIntoDummy", this.rewindowingStrategy.windowDummy()).apply("RemoveDummyTriggering", removeTriggering);
            PCollection dummyAndContents = (PCollection)((PCollection)((PCollection)PCollectionList.of(groupedContents).and(keyedDummy).apply("FlattenDummyAndContents", Flatten.pCollections())).apply("NeverTrigger", Window.configure().triggering(Never.ever()).withAllowedLateness(input.getWindowingStrategy().getAllowedLateness()).discardingFiredPanes())).apply("GroupDummyAndContents", GroupByKey.create());
            return (PCollection)((PCollection)dummyAndContents.apply(Values.create())).apply(ParDo.of(new ConcatFn()));
        }
    }

    private static class CheckRelationAgainstExpected<@UnknownKeyFor T>
    implements SerializableFunction<T, Void> {
        private final @UnknownKeyFor @NonNull @Initialized AssertRelation<T, T> relation;
        private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodedExpected;
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

        public CheckRelationAgainstExpected(@UnknownKeyFor @NonNull @Initialized AssertRelation<T, T> relation, T expected, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            this.relation = relation;
            this.coder = coder;
            try {
                this.encodedExpected = CoderUtils.encodeToByteArray(coder, expected);
            }
            catch (IOException coderException) {
                throw new RuntimeException(coderException);
            }
        }

        @Override
        public @UnknownKeyFor @Nullable @Initialized Void apply(T actual) {
            try {
                T expected = CoderUtils.decodeFromByteArray(this.coder, this.encodedExpected);
                return this.relation.assertFor(expected).apply(actual);
            }
            catch (IOException coderException) {
                throw new RuntimeException(coderException);
            }
        }
    }

    private static class CreateActual<@UnknownKeyFor T, @UnknownKeyFor ActualT>
    extends PTransform<PBegin, PCollectionView<ActualT>> {
        private final transient @UnknownKeyFor @NonNull @Initialized PCollection<T> actual;
        private final transient @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowActuals;
        private final transient @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> extractPane;
        private final transient @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ActualT>> actualView;

        public static <T, ActualT> @UnknownKeyFor @NonNull @Initialized CreateActual<T, ActualT> from(@UnknownKeyFor @NonNull @Initialized PCollection<T> actual, @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowActuals, @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> extractPane, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ActualT>> actualView) {
            return new CreateActual<T, ActualT>(actual, rewindowActuals, extractPane, actualView);
        }

        private CreateActual(@UnknownKeyFor @NonNull @Initialized PCollection<T> actual, @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowActuals, @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> extractPane, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ActualT>> actualView) {
            this.actual = actual;
            this.rewindowActuals = rewindowActuals;
            this.extractPane = extractPane;
            this.actualView = actualView;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionView<ActualT> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            final Coder<T> coder = this.actual.getCoder();
            return ((PCollection)((PCollection)((PCollection)((Object)((PCollection)this.actual.apply("FilterActuals", this.rewindowActuals.prepareActuals()).apply("GatherPanes", GatherAllPanes.globally())).apply("ExtractPane", MapElements.via(this.extractPane)))).setCoder(IterableCoder.of(this.actual.getCoder())).apply(Flatten.iterables())).apply("RewindowActuals", this.rewindowActuals.windowActuals()).apply(ParDo.of(new DoFn<T, T>(){

                @DoFn.ProcessElement
                public void processElement(@UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized CoderException {
                    context.output(CoderUtils.clone(coder, context.element()));
                }
            }))).apply(this.actualView);
        }
    }

    private static class PCollectionViewAssert<@UnknownKeyFor ElemT, @UnknownKeyFor ViewT>
    implements SingletonAssert<ViewT> {
        private final @UnknownKeyFor @NonNull @Initialized PCollection<ElemT> actual;
        private final @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<ElemT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT>> view;
        private final @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowActuals;
        private final @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<ElemT>>, @UnknownKeyFor @NonNull @Initialized Iterable<ElemT>> paneExtractor;
        private final @UnknownKeyFor @NonNull @Initialized Coder<ViewT> coder;
        private final @UnknownKeyFor @NonNull @Initialized PAssertionSite site;

        protected PCollectionViewAssert(@UnknownKeyFor @NonNull @Initialized PCollection<ElemT> actual, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<ElemT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT>> view, @UnknownKeyFor @NonNull @Initialized Coder<ViewT> coder, @UnknownKeyFor @NonNull @Initialized PAssertionSite site) {
            this(actual, view, IntoGlobalWindow.of(), PaneExtractors.allPanes(), coder, site);
        }

        private PCollectionViewAssert(@UnknownKeyFor @NonNull @Initialized PCollection<ElemT> actual, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<ElemT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT>> view, @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowActuals, @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<ElemT>>, @UnknownKeyFor @NonNull @Initialized Iterable<ElemT>> paneExtractor, @UnknownKeyFor @NonNull @Initialized Coder<ViewT> coder, @UnknownKeyFor @NonNull @Initialized PAssertionSite site) {
            this.actual = actual;
            this.view = view;
            this.rewindowActuals = rewindowActuals;
            this.paneExtractor = paneExtractor;
            this.coder = coder;
            this.site = site;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionViewAssert<ElemT, ViewT> inWindow(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.inPane(window, PaneExtractors.allPanes());
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionViewAssert<ElemT, ViewT> inOnlyPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.inPane(window, PaneExtractors.onlyPane(this.site));
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionViewAssert<ElemT, ViewT> inFinalPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.inPane(window, PaneExtractors.finalPane());
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionViewAssert<ElemT, ViewT> inOnTimePane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.inPane(window, PaneExtractors.onTimePane());
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionViewAssert<ElemT, ViewT> inEarlyPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.inPane(window, PaneExtractors.earlyPanes());
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionViewAssert<ElemT, ViewT> inLatePane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.inPane(window, PaneExtractors.latePanes());
        }

        private @UnknownKeyFor @NonNull @Initialized PCollectionViewAssert<ElemT, ViewT> inPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<ElemT>>, @UnknownKeyFor @NonNull @Initialized Iterable<ElemT>> paneExtractor) {
            return new PCollectionViewAssert<ElemT, ViewT>(this.actual, this.view, IntoStaticWindows.of(this.actual.getWindowingStrategy().getWindowFn().windowCoder(), window), paneExtractor, this.coder, this.site);
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionViewAssert<ElemT, ViewT> isEqualTo(ViewT expectedValue) {
            return this.satisfies(new AssertIsEqualToRelation(), expectedValue);
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionViewAssert<ElemT, ViewT> notEqualTo(ViewT expectedValue) {
            return this.satisfies(new AssertNotEqualToRelation(), expectedValue);
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionViewAssert<ElemT, ViewT> satisfies(@UnknownKeyFor @NonNull @Initialized SerializableFunction<ViewT, @UnknownKeyFor @Nullable @Initialized Void> checkerFn) {
            this.actual.getPipeline().apply("PAssert$" + assertCount++, new OneSideInputAssert(CreateActual.from(this.actual, this.rewindowActuals, this.paneExtractor, this.view), this.rewindowActuals.windowDummy(), checkerFn, this.site));
            return this;
        }

        private @UnknownKeyFor @NonNull @Initialized PCollectionViewAssert<ElemT, ViewT> satisfies(@UnknownKeyFor @NonNull @Initialized AssertRelation<ViewT, ViewT> relation, ViewT expectedValue) {
            return this.satisfies((SerializableFunction)new CheckRelationAgainstExpected<ViewT>(relation, expectedValue, this.coder));
        }

        @Deprecated
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        @SuppressFBWarnings(value={"EQ_UNUSUAL"})
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            throw new UnsupportedOperationException(String.format("tests for Java equality of the %s object, not the PCollection in question. Call a test method, such as isEqualTo.", this.getClass().getSimpleName()));
        }

        @Deprecated
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            throw new UnsupportedOperationException(String.format("%s.hashCode() is not supported.", SingletonAssert.class.getSimpleName()));
        }
    }

    private static class PCollectionSingletonAssert<@UnknownKeyFor T>
    implements SingletonAssert<T> {
        private final @UnknownKeyFor @NonNull @Initialized PCollection<T> actual;
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
        private final @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowingStrategy;
        private final @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> paneExtractor;
        private final @UnknownKeyFor @NonNull @Initialized PAssertionSite site;

        PCollectionSingletonAssert(@UnknownKeyFor @NonNull @Initialized PCollection<T> actual, @UnknownKeyFor @NonNull @Initialized PAssertionSite site) {
            this(actual, IntoGlobalWindow.of(), PaneExtractors.allPanes(), site);
        }

        PCollectionSingletonAssert(@UnknownKeyFor @NonNull @Initialized PCollection<T> actual, @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowingStrategy, @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> paneExtractor, @UnknownKeyFor @NonNull @Initialized PAssertionSite site) {
            this.actual = actual;
            this.coder = actual.getCoder();
            this.rewindowingStrategy = rewindowingStrategy;
            this.paneExtractor = paneExtractor;
            this.site = site;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonAssert<T> inWindow(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.allPanes());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonAssert<T> inFinalPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.finalPane());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonAssert<T> inOnTimePane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.onTimePane());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonAssert<T> inEarlyPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.earlyPanes());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonAssert<T> inLatePane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.latePanes());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized SingletonAssert<T> isEqualTo(T expected) {
            return this.satisfies(new AssertIsEqualToRelation(), expected);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized SingletonAssert<T> notEqualTo(T notExpected) {
            return this.satisfies(new AssertNotEqualToRelation(), notExpected);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonAssert<T> inOnlyPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.onlyPane(this.site));
        }

        private @UnknownKeyFor @NonNull @Initialized PCollectionSingletonAssert<T> withPanes(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> paneExtractor) {
            Coder<BoundedWindow> windowCoder = this.actual.getWindowingStrategy().getWindowFn().windowCoder();
            return new PCollectionSingletonAssert<T>(this.actual, IntoStaticWindows.of(windowCoder, window), paneExtractor, this.site);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonAssert<T> satisfies(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @Nullable @Initialized Void> checkerFn) {
            this.actual.apply("PAssert$" + assertCount++, new GroupThenAssertForSingleton(checkerFn, this.rewindowingStrategy, this.paneExtractor, this.site));
            return this;
        }

        private @UnknownKeyFor @NonNull @Initialized PCollectionSingletonAssert<T> satisfies(@UnknownKeyFor @NonNull @Initialized AssertRelation<T, T> relation, T expected) {
            return this.satisfies((SerializableFunction)new CheckRelationAgainstExpected<T>(relation, expected, this.coder));
        }

        @Deprecated
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        @SuppressFBWarnings(value={"EQ_UNUSUAL"})
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            throw new UnsupportedOperationException(String.format("tests for Java equality of the %s object, not the PCollection in question. Call a test method, such as isEqualTo.", this.getClass().getSimpleName()));
        }

        @Deprecated
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            throw new UnsupportedOperationException(String.format("%s.hashCode() is not supported.", SingletonAssert.class.getSimpleName()));
        }
    }

    private static class PCollectionSingletonIterableAssert<@UnknownKeyFor T>
    implements IterableAssert<T> {
        private final @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Iterable<T>> actual;
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> elementCoder;
        private final @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowingStrategy;
        private final @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized Iterable<T>>>, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Iterable<T>>> paneExtractor;
        private final @UnknownKeyFor @NonNull @Initialized PAssertionSite site;

        public PCollectionSingletonIterableAssert(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Iterable<T>> actual, @UnknownKeyFor @NonNull @Initialized PAssertionSite site) {
            this(actual, IntoGlobalWindow.of(), PaneExtractors.allPanes(), site);
        }

        public PCollectionSingletonIterableAssert(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Iterable<T>> actual, @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowingStrategy, @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized Iterable<T>>>, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Iterable<T>>> paneExtractor, @UnknownKeyFor @NonNull @Initialized PAssertionSite site) {
            this.actual = actual;
            Coder<?> typedCoder = actual.getCoder().getCoderArguments().get(0);
            this.elementCoder = typedCoder;
            this.rewindowingStrategy = rewindowingStrategy;
            this.paneExtractor = paneExtractor;
            this.site = site;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonIterableAssert<T> inWindow(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.allPanes());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonIterableAssert<T> inOnlyPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.onlyPane(this.site));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonIterableAssert<T> inFinalPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.finalPane());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonIterableAssert<T> inOnTimePane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.onTimePane());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonIterableAssert<T> inEarlyPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.earlyPanes());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonIterableAssert<T> inLatePane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.latePanes());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonIterableAssert<T> inCombinedNonLatePanes(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.nonLatePanes());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> inEarlyGlobalWindowPanes() {
            return this.withPanes(GlobalWindow.INSTANCE, PaneExtractors.earlyPanes());
        }

        private @UnknownKeyFor @NonNull @Initialized PCollectionSingletonIterableAssert<T> withPanes(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized Iterable<T>>>, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Iterable<T>>> paneExtractor) {
            Coder<BoundedWindow> windowCoder = this.actual.getWindowingStrategy().getWindowFn().windowCoder();
            return new PCollectionSingletonIterableAssert<T>(this.actual, IntoStaticWindows.of(windowCoder, window), paneExtractor, this.site);
        }

        @Override
        @SafeVarargs
        public final @UnknownKeyFor @NonNull @Initialized PCollectionSingletonIterableAssert<T> containsInAnyOrder(T ... expectedElements) {
            return this.containsInAnyOrder(Arrays.asList(expectedElements));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonIterableAssert<T> empty() {
            return this.containsInAnyOrder((Iterable)Collections.emptyList());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonIterableAssert<T> containsInAnyOrder(@UnknownKeyFor @NonNull @Initialized Iterable<T> expectedElements) {
            return this.satisfies(new AssertContainsInAnyOrderRelation(), expectedElements);
        }

        @Override
        @SafeVarargs
        public final @UnknownKeyFor @NonNull @Initialized PCollectionSingletonIterableAssert<T> containsInAnyOrder(SerializableMatcher<? super T> ... elementMatchers) {
            MatcherCheckerFn<Iterable<? super T>> checkerFn = new MatcherCheckerFn<Iterable<? super T>>(SerializableMatchers.containsInAnyOrder(elementMatchers));
            return this.satisfies(checkerFn);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonIterableAssert<T> containsInAnyOrder() {
            return this.empty();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionSingletonIterableAssert<T> satisfies(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<T>, @UnknownKeyFor @Nullable @Initialized Void> checkerFn) {
            this.actual.apply("PAssert$" + assertCount++, new GroupThenAssertForSingleton(checkerFn, this.rewindowingStrategy, this.paneExtractor, this.site));
            return this;
        }

        private @UnknownKeyFor @NonNull @Initialized PCollectionSingletonIterableAssert<T> satisfies(@UnknownKeyFor @NonNull @Initialized AssertRelation<@UnknownKeyFor @NonNull @Initialized Iterable<T>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> relation, @UnknownKeyFor @NonNull @Initialized Iterable<T> expectedElements) {
            return this.satisfies(new CheckRelationAgainstExpected<Iterable<T>>(relation, expectedElements, IterableCoder.of(this.elementCoder)));
        }
    }

    protected static class PCollectionContentsAssert<@UnknownKeyFor T>
    implements IterableAssert<T> {
        private final @UnknownKeyFor @NonNull @Initialized PCollection<T> actual;
        private final @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowingStrategy;
        private final @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> paneExtractor;
        private final @UnknownKeyFor @NonNull @Initialized PAssertionSite site;

        public PCollectionContentsAssert(@UnknownKeyFor @NonNull @Initialized PCollection<T> actual, @UnknownKeyFor @NonNull @Initialized PAssertionSite site) {
            this(actual, IntoGlobalWindow.of(), PaneExtractors.allPanes(), site);
        }

        public PCollectionContentsAssert(@UnknownKeyFor @NonNull @Initialized PCollection<T> actual, @UnknownKeyFor @NonNull @Initialized AssertionWindows rewindowingStrategy, @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> paneExtractor, @UnknownKeyFor @NonNull @Initialized PAssertionSite site) {
            this.actual = actual;
            this.rewindowingStrategy = rewindowingStrategy;
            this.paneExtractor = paneExtractor;
            this.site = site;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> inWindow(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPane(window, PaneExtractors.allPanes());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> inOnlyPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPane(window, PaneExtractors.onlyPane(this.site));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> inFinalPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPane(window, PaneExtractors.finalPane());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> inOnTimePane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPane(window, PaneExtractors.onTimePane());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> inEarlyPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPane(window, PaneExtractors.earlyPanes());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> inLatePane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPane(window, PaneExtractors.latePanes());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> inCombinedNonLatePanes(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.withPane(window, PaneExtractors.nonLatePanes());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> inEarlyGlobalWindowPanes() {
            return this.withPane(GlobalWindow.INSTANCE, PaneExtractors.earlyPanes());
        }

        private @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> withPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> paneExtractor) {
            Coder<BoundedWindow> windowCoder = this.actual.getWindowingStrategy().getWindowFn().windowCoder();
            return new PCollectionContentsAssert<T>(this.actual, IntoStaticWindows.of(windowCoder, window), paneExtractor, this.site);
        }

        @Override
        @SafeVarargs
        public final @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> containsInAnyOrder(T ... expectedElements) {
            return this.containsInAnyOrder(Arrays.asList(expectedElements));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> containsInAnyOrder(@UnknownKeyFor @NonNull @Initialized Iterable<T> expectedElements) {
            return this.satisfies(new AssertContainsInAnyOrderRelation(), expectedElements);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> empty() {
            this.containsInAnyOrder((Iterable)Collections.emptyList());
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> satisfies(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<T>, @UnknownKeyFor @Nullable @Initialized Void> checkerFn) {
            this.actual.apply(PAssert.nextAssertionName(), new GroupThenAssert(checkerFn, this.rewindowingStrategy, this.paneExtractor, this.site));
            return this;
        }

        @Override
        @SafeVarargs
        public final @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> containsInAnyOrder(SerializableMatcher<? super T> ... elementMatchers) {
            return this.satisfies(SerializableMatchers.containsInAnyOrder(elementMatchers));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> containsInAnyOrder() {
            return this.empty();
        }

        private @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> satisfies(@UnknownKeyFor @NonNull @Initialized AssertRelation<@UnknownKeyFor @NonNull @Initialized Iterable<T>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> relation, @UnknownKeyFor @NonNull @Initialized Iterable<T> expectedElements) {
            return this.satisfies(new CheckRelationAgainstExpected<Iterable<T>>(relation, expectedElements, IterableCoder.of(this.actual.getCoder())));
        }

        @UnknownKeyFor @NonNull @Initialized PCollectionContentsAssert<T> satisfies(@UnknownKeyFor @NonNull @Initialized SerializableMatcher<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends T>> matcher) {
            MatcherCheckerFn<Iterable<? extends T>> checkerFn = new MatcherCheckerFn<Iterable<? extends T>>(matcher);
            this.actual.apply("PAssert$" + assertCount++, new GroupThenAssert(checkerFn, this.rewindowingStrategy, this.paneExtractor, this.site));
            return this;
        }

        @Deprecated
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        @SuppressFBWarnings(value={"EQ_UNUSUAL"})
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            throw new UnsupportedOperationException("If you meant to test object equality, use .containsInAnyOrder instead.");
        }

        @Deprecated
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            throw new UnsupportedOperationException(String.format("%s.hashCode() is not supported.", IterableAssert.class.getSimpleName()));
        }
    }

    protected static class PCollectionListContentsAssert<@UnknownKeyFor T> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionList<T> pCollectionList;

        public PCollectionListContentsAssert(@UnknownKeyFor @NonNull @Initialized PCollectionList<T> actual) {
            this.pCollectionList = actual;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionListContentsAssert<T> satisfies(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<T>, @UnknownKeyFor @Nullable @Initialized Void> checkerFn) {
            for (int i = 0; i < this.pCollectionList.size(); ++i) {
                PAssert.that(this.pCollectionList.get(i)).satisfies(checkerFn);
            }
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionListContentsAssert<T> satisfies(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<T>, @UnknownKeyFor @Nullable @Initialized Void>> checkerFnList) {
            if (checkerFnList == null) {
                throw new IllegalArgumentException("List of SerializableFunction must not be null");
            }
            if (checkerFnList.size() != this.pCollectionList.size()) {
                throw new IllegalArgumentException("List of SerializableFunction must be the same size as the PCollectionList");
            }
            for (int i = 0; i < this.pCollectionList.size(); ++i) {
                PAssert.that(this.pCollectionList.get(i)).satisfies(checkerFnList.get(i));
            }
            return this;
        }
    }

    public static interface SingletonAssert<@UnknownKeyFor T> {
        public @UnknownKeyFor @NonNull @Initialized SingletonAssert<T> inWindow(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1);

        public @UnknownKeyFor @NonNull @Initialized SingletonAssert<T> inOnlyPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1);

        public @UnknownKeyFor @NonNull @Initialized SingletonAssert<T> inFinalPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1);

        public @UnknownKeyFor @NonNull @Initialized SingletonAssert<T> inOnTimePane(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1);

        public @UnknownKeyFor @NonNull @Initialized SingletonAssert<T> inEarlyPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1);

        public @UnknownKeyFor @NonNull @Initialized SingletonAssert<T> inLatePane(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1);

        public @UnknownKeyFor @NonNull @Initialized SingletonAssert<T> isEqualTo(T var1);

        public @UnknownKeyFor @NonNull @Initialized SingletonAssert<T> notEqualTo(T var1);

        public @UnknownKeyFor @NonNull @Initialized SingletonAssert<T> satisfies(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @Nullable @Initialized Void> var1);
    }

    public static interface IterableAssert<@UnknownKeyFor T> {
        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> inWindow(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1);

        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> inOnlyPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1);

        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> inFinalPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1);

        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> inOnTimePane(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1);

        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> inEarlyPane(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1);

        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> inLatePane(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1);

        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> inCombinedNonLatePanes(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1);

        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> inEarlyGlobalWindowPanes();

        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> containsInAnyOrder(T ... var1);

        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> containsInAnyOrder(SerializableMatcher<? super T> ... var1);

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> containsInAnyOrder();

        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> containsInAnyOrder(@UnknownKeyFor @NonNull @Initialized Iterable<T> var1);

        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> empty();

        public @UnknownKeyFor @NonNull @Initialized IterableAssert<T> satisfies(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<T>, @UnknownKeyFor @Nullable @Initialized Void> var1);
    }

    public static class PAssertionSite
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized String message;
        private final @UnknownKeyFor @NonNull @Initialized StackTraceElement @UnknownKeyFor @NonNull @Initialized [] creationStackTrace;

        static @UnknownKeyFor @NonNull @Initialized PAssertionSite capture(@UnknownKeyFor @NonNull @Initialized String message) {
            return new PAssertionSite(message, new Throwable().getStackTrace());
        }

        PAssertionSite(@UnknownKeyFor @NonNull @Initialized String message, @UnknownKeyFor @NonNull @Initialized StackTraceElement @UnknownKeyFor @NonNull @Initialized [] creationStackTrace) {
            this.message = message;
            this.creationStackTrace = creationStackTrace;
        }

        public @UnknownKeyFor @NonNull @Initialized AssertionError wrap(@UnknownKeyFor @NonNull @Initialized Throwable t) {
            AssertionError res = new AssertionError(this.message.isEmpty() ? t.getMessage() : this.message + ": " + t.getMessage(), t);
            ((Throwable)((Object)res)).setStackTrace(this.creationStackTrace);
            return res;
        }

        public @UnknownKeyFor @NonNull @Initialized AssertionError wrap(@UnknownKeyFor @NonNull @Initialized String message) {
            String outputMessage = this.message == null || this.message.isEmpty() ? message : this.message + ": " + message;
            AssertionError res = new AssertionError((Object)outputMessage);
            ((Throwable)((Object)res)).setStackTrace(this.creationStackTrace);
            return res;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PAssertionSite that = (PAssertionSite)o;
            return Objects.equal(this.message, that.message) && Arrays.equals(this.creationStackTrace, that.creationStackTrace);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hashCode(this.message, Arrays.asList(this.creationStackTrace));
        }
    }

    public static class DefaultConcludeTransform
    extends PTransform<PCollection<SuccessOrFailure>, PCollection<Void>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @Nullable @Initialized Void> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SuccessOrFailure> input) {
            return (PCollection)((Object)input.apply(ParDo.of(new DefaultConcludeFn())));
        }
    }

    private static final class DefaultConcludeFn
    extends DoFn<SuccessOrFailure, Void> {
        private DefaultConcludeFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            SuccessOrFailure e = (SuccessOrFailure)c.element();
            if (!e.isSuccess()) {
                failureCounter.inc();
                throw e.assertionError();
            }
            successCounter.inc();
        }
    }
}

