/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.Materialization;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class Materializations {
    public static final @UnknownKeyFor @NonNull @Initialized String ITERABLE_MATERIALIZATION_URN = "beam:side_input:iterable:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String MULTIMAP_MATERIALIZATION_URN = "beam:side_input:multimap:v1";

    @Internal
    public static <K, V> @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized MultimapView<K, V>> multimap() {
        return new Materialization<MultimapView<K, V>>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized String getUrn() {
                return Materializations.MULTIMAP_MATERIALIZATION_URN;
            }
        };
    }

    @Internal
    public static <V> @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized IterableView<V>> iterable() {
        return new Materialization<IterableView<V>>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized String getUrn() {
                return Materializations.ITERABLE_MATERIALIZATION_URN;
            }
        };
    }

    static {
        Preconditions.checkState(ITERABLE_MATERIALIZATION_URN.equals(RunnerApi.StandardSideInputTypes.Enum.ITERABLE.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn)), "Expected %s to match proto constant but found %s.", (Object)ITERABLE_MATERIALIZATION_URN, RunnerApi.StandardSideInputTypes.Enum.ITERABLE.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn));
        Preconditions.checkState(MULTIMAP_MATERIALIZATION_URN.equals(RunnerApi.StandardSideInputTypes.Enum.MULTIMAP.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn)), "Expected %s to match proto constant but found %s.", (Object)MULTIMAP_MATERIALIZATION_URN, RunnerApi.StandardSideInputTypes.Enum.MULTIMAP.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn));
    }

    public static interface MultimapView<@UnknownKeyFor K, @UnknownKeyFor V> {
        public @UnknownKeyFor @NonNull @Initialized Iterable<K> get();

        public @UnknownKeyFor @NonNull @Initialized Iterable<V> get(@Nullable K var1);
    }

    public static interface IterableView<@UnknownKeyFor V> {
        public @UnknownKeyFor @NonNull @Initialized Iterable<V> get();
    }
}

