/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.IfExpression;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public class BooleanExpression
extends BinaryExpression {
    public BooleanExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.optimize(optimizer, staticContext, itemType);
        TypeHierarchy typeHierarchy = staticContext.getNamePool().getTypeHierarchy();
        if (expression == this && this.operator == 10 && this.operand1 instanceof UserFunctionCall && typeHierarchy.isSubType(this.operand1.getItemType(typeHierarchy), Type.BOOLEAN_TYPE) && !this.containedInLoop(staticContext)) {
            IfExpression ifExpression = new IfExpression(this.operand0, this.operand1, BooleanValue.FALSE);
            ifExpression.setParentExpression(this.getParentExpression());
            return ifExpression;
        }
        return this;
    }

    private boolean containedInLoop(StaticContext staticContext) {
        ComputedExpression computedExpression = this;
        while (true) {
            Container container;
            if ((container = computedExpression.getParentExpression()) instanceof Expression && ExpressionTool.isRepeatedSubexpression((Expression)((Object)container), computedExpression, staticContext)) {
                return true;
            }
            if (!(container instanceof ComputedExpression)) break;
            computedExpression = (ComputedExpression)container;
        }
        return false;
    }

    public Expression negate(StaticContext staticContext) {
        if (this.operator == 10) {
            BooleanFn booleanFn = (BooleanFn)SystemFunction.makeSystemFunction("not", 1, staticContext.getNamePool());
            Expression[] expressionArray = new Expression[]{this.operand0};
            booleanFn.setArguments(expressionArray);
            BooleanFn booleanFn2 = (BooleanFn)SystemFunction.makeSystemFunction("not", 1, staticContext.getNamePool());
            Expression[] expressionArray2 = new Expression[]{this.operand1};
            booleanFn2.setArguments(expressionArray2);
            return new BooleanExpression(booleanFn, 9, booleanFn2);
        }
        BooleanFn booleanFn = (BooleanFn)SystemFunction.makeSystemFunction("not", 1, staticContext.getNamePool());
        Expression[] expressionArray = new Expression[]{this.operand0};
        booleanFn.setArguments(expressionArray);
        BooleanFn booleanFn3 = (BooleanFn)SystemFunction.makeSystemFunction("not", 1, staticContext.getNamePool());
        Expression[] expressionArray3 = new Expression[]{this.operand1};
        booleanFn3.setArguments(expressionArray3);
        return new BooleanExpression(booleanFn, 10, booleanFn3);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        switch (this.operator) {
            case 10: {
                return this.operand0.effectiveBooleanValue(xPathContext) && this.operand1.effectiveBooleanValue(xPathContext);
            }
            case 9: {
                return this.operand0.effectiveBooleanValue(xPathContext) || this.operand1.effectiveBooleanValue(xPathContext);
            }
        }
        throw new UnsupportedOperationException("Unknown operator in boolean expression");
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.BOOLEAN_TYPE;
    }

    public static void listAndComponents(Expression expression, List list) {
        if (expression instanceof BooleanExpression && ((BooleanExpression)expression).getOperator() == 10) {
            Iterator iterator = expression.iterateSubExpressions();
            while (iterator.hasNext()) {
                BooleanExpression.listAndComponents((Expression)iterator.next(), list);
            }
        } else {
            list.add(expression);
        }
    }
}

