/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.IHopAttribute;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.xml.XmlMetadataUtil;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceReference;
import org.w3c.dom.Node;

public class BaseTransformMeta<Main extends ITransform, Data extends ITransformData>
implements ITransformMeta,
Cloneable {
    public static final ILoggingObject loggingObject = new SimpleLoggingObject("Transform metadata", LoggingObjectType.TRANSFORM_META, null);
    private boolean changed = false;
    protected Database[] databases;
    protected TransformMeta parentTransformMeta;
    private volatile ITransformIOMeta ioMetaVar;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected ILogChannel log;
    protected ArrayList<IHopAttribute> attributes;

    @Override
    public ITransform createTransform(TransformMeta transformMeta, ITransformData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        try {
            Type[] parameterizedTypes = this.getParameterizedTypes(this.getClass());
            Class mainClass = (Class)parameterizedTypes[0];
            Class dataClass = (Class)parameterizedTypes[1];
            if (mainClass.isInterface()) {
                return null;
            }
            Constructor constructor = mainClass.getConstructor(TransformMeta.class, this.getClass(), dataClass, Integer.TYPE, PipelineMeta.class, Pipeline.class);
            return (ITransform)constructor.newInstance(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new RuntimeException("Error create instance of transform: " + this.getClass().getCanonicalName(), e);
        }
    }

    @Override
    public ITransformData createTransformData() {
        try {
            Type[] parameterizedTypes = this.getParameterizedTypes(this.getClass());
            Class dataClass = (Class)parameterizedTypes[1];
            if (dataClass.isInterface()) {
                return null;
            }
            return (ITransformData)dataClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new RuntimeException("Error create instance of transform data: " + this.getClass().getCanonicalName(), e);
        }
    }

    protected Type[] getParameterizedTypes(Class<?> clazz) {
        Type[] types = this.getGenericType(clazz);
        if (types.length > 0 && types[0] instanceof ParameterizedType) {
            return ((ParameterizedType)types[0]).getActualTypeArguments();
        }
        return null;
    }

    protected Type[] getGenericType(Class<?> clazz) {
        do {
            Type type;
            if ((type = clazz.getGenericSuperclass()) == null || !(type instanceof ParameterizedType)) continue;
            return new Type[]{type};
        } while ((clazz = clazz.getSuperclass()) != null);
        return new Type[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() {
        try {
            BaseTransformMeta retval = (BaseTransformMeta)super.clone();
            this.lock.readLock().lock();
            try {
                if (this.ioMetaVar != null) {
                    TransformIOMeta transformIOMeta = new TransformIOMeta(this.ioMetaVar.isInputAcceptor(), this.ioMetaVar.isOutputProducer(), this.ioMetaVar.isInputOptional(), this.ioMetaVar.isSortedDataRequired(), this.ioMetaVar.isInputDynamic(), this.ioMetaVar.isOutputDynamic());
                    List<IStream> infoStreams = this.ioMetaVar.getInfoStreams();
                    for (IStream infoStream : infoStreams) {
                        transformIOMeta.addStream(new Stream(infoStream));
                    }
                    List<IStream> targetStreams = this.ioMetaVar.getTargetStreams();
                    for (IStream targetStream : targetStreams) {
                        transformIOMeta.addStream(new Stream(targetStream));
                    }
                    this.lock.readLock().unlock();
                    retval.setTransformIOMeta(transformIOMeta);
                    this.lock.readLock().lock();
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public void setDefault() {
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    @Override
    public void setChanged() {
        this.changed = true;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public IRowMeta getTableFields(IVariables variables) {
        return null;
    }

    @Override
    public String getXml() throws HopException {
        this.convertIOMetaToTransformNames();
        return XmlMetadataUtil.serializeObjectToXml((Object)this);
    }

    @Override
    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        XmlMetadataUtil.deSerializeFromXml((Node)transformNode, this.getClass(), (Object)this, (IHopMetadataProvider)metadataProvider);
    }

    @Override
    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    @Override
    public void getFields(PipelineMeta pipelineMeta, IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        this.getFields(inputRowMeta, name, info, nextTransform, variables, metadataProvider);
    }

    @Override
    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    @Override
    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) throws HopTransformException {
        return new SqlStatement(transformMeta.getName(), null, null);
    }

    @Override
    public void cancelQueries() throws HopDatabaseException {
        if (this.databases != null) {
            for (int i = 0; i < this.databases.length; ++i) {
                if (this.databases[i] == null) continue;
                this.databases[i].cancelQuery();
            }
        }
    }

    @Override
    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        return new RowMeta();
    }

    @Deprecated(since="2.0")
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[0];
    }

    @Override
    public boolean supportsErrorHandling() {
        return false;
    }

    @Override
    public boolean supportsMultiCopyExecution() {
        return true;
    }

    @Override
    public boolean excludeFromRowLayoutVerification() {
        return false;
    }

    @Override
    public boolean excludeFromCopyDistributeVerification() {
        return false;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(IVariables variables, TransformMeta transformMeta) {
        return Arrays.asList(new ResourceReference(transformMeta));
    }

    @Override
    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        return null;
    }

    @Override
    public String getDialogClassName() {
        Object className = this.getClass().getCanonicalName();
        if (((String)className).endsWith("Meta")) {
            className = ((String)className).substring(0, ((String)className).length() - 4);
        }
        className = (String)className + "Dialog";
        try {
            Class<?> clazz = Class.forName(((String)className).replaceFirst("\\.hop\\.", ".hop.ui."));
            className = clazz.getName();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return className;
    }

    @Override
    public TransformMeta getParentTransformMeta() {
        return this.parentTransformMeta;
    }

    @Override
    public void setParentTransformMeta(TransformMeta parentTransformMeta) {
        this.parentTransformMeta = parentTransformMeta;
    }

    public ILogChannel getLog() {
        if (this.log == null) {
            this.log = new LogChannel((Object)this);
        }
        return this.log;
    }

    public boolean isBasic() {
        return this.getLog().isBasic();
    }

    public boolean isDetailed() {
        return this.getLog().isDetailed();
    }

    public boolean isDebug() {
        return this.getLog().isDebug();
    }

    public boolean isRowLevel() {
        return this.getLog().isRowLevel();
    }

    public void logMinimal(String message) {
        this.getLog().logMinimal(message);
    }

    public void logMinimal(String message, Object ... arguments) {
        this.getLog().logMinimal(message, arguments);
    }

    public void logBasic(String message) {
        this.getLog().logBasic(message);
    }

    public void logBasic(String message, Object ... arguments) {
        this.getLog().logBasic(message, arguments);
    }

    public void logDetailed(String message) {
        this.getLog().logDetailed(message);
    }

    public void logDetailed(String message, Object ... arguments) {
        this.getLog().logDetailed(message, arguments);
    }

    public void logDebug(String message) {
        this.getLog().logDebug(message);
    }

    public void logDebug(String message, Object ... arguments) {
        this.getLog().logDebug(message, arguments);
    }

    public void logRowlevel(String message) {
        this.getLog().logRowlevel(message);
    }

    public void logRowlevel(String message, Object ... arguments) {
        this.getLog().logRowlevel(message, arguments);
    }

    public void logError(String message) {
        this.getLog().logError(message);
    }

    public void logError(String message, Throwable e) {
        this.getLog().logError(message, e);
    }

    public void logError(String message, Object ... arguments) {
        this.getLog().logError(message, arguments);
    }

    public String getLogChannelId() {
        return null;
    }

    public String getName() {
        return null;
    }

    public String getObjectCopy() {
        return null;
    }

    public LoggingObjectType getObjectType() {
        return null;
    }

    public ILoggingObject getParent() {
        return null;
    }

    @Override
    public ITransformIOMeta getTransformIOMeta() {
        return this.getTransformIOMeta(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITransformIOMeta getTransformIOMeta(boolean createIfAbsent) {
        ITransformIOMeta ioMeta = null;
        this.lock.readLock().lock();
        try {
            if (this.ioMetaVar == null && createIfAbsent) {
                ioMeta = new TransformIOMeta(true, true, true, false, false, false);
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    this.ioMetaVar = ioMeta;
                    this.lock.readLock().lock();
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            } else {
                ioMeta = this.ioMetaVar;
            }
            ITransformIOMeta iTransformIOMeta = ioMeta;
            return iTransformIOMeta;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setTransformIOMeta(ITransformIOMeta value) {
        this.lock.writeLock().lock();
        try {
            this.ioMetaVar = value;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public List<IStream> getOptionalStreams() {
        ArrayList<IStream> list = new ArrayList<IStream>();
        return list;
    }

    @Override
    public void handleStreamSelection(IStream stream) {
    }

    @Override
    public void resetTransformIoMeta() {
        this.lock.writeLock().lock();
        try {
            this.ioMetaVar = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
    }

    @Override
    public void convertIOMetaToTransformNames() {
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal, PipelineMeta.PipelineType.SingleThreaded};
    }

    @Override
    public String[] getReferencedObjectDescriptions() {
        return null;
    }

    @Override
    public boolean[] isReferencedObjectEnabled() {
        return null;
    }

    @Override
    public String getActiveReferencedObjectDescription() {
        return null;
    }

    @Override
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
    }

    @Override
    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return null;
    }
}

