/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.utils.TimeUUID;

public abstract class AbstractStrategyHolder {
    protected final ColumnFamilyStore cfs;
    final DestinationRouter router;
    private int numTokenPartitions = -1;

    AbstractStrategyHolder(ColumnFamilyStore cfs, DestinationRouter router) {
        this.cfs = cfs;
        this.router = router;
    }

    public abstract void startup();

    public abstract void shutdown();

    final void setStrategy(CompactionParams params, int numTokenPartitions) {
        Preconditions.checkArgument((numTokenPartitions > 0 ? 1 : 0) != 0, (Object)"at least one token partition required");
        this.shutdown();
        this.numTokenPartitions = numTokenPartitions;
        this.setStrategyInternal(params, numTokenPartitions);
    }

    protected abstract void setStrategyInternal(CompactionParams var1, int var2);

    public abstract boolean managesRepairedGroup(boolean var1, boolean var2, boolean var3);

    public boolean managesSSTable(SSTableReader sstable) {
        return this.managesRepairedGroup(sstable.isRepaired(), sstable.isPendingRepair(), sstable.isTransient());
    }

    public abstract AbstractCompactionStrategy getStrategyFor(SSTableReader var1);

    public abstract Iterable<AbstractCompactionStrategy> allStrategies();

    public abstract Collection<TaskSupplier> getBackgroundTaskSuppliers(int var1);

    public abstract Collection<AbstractCompactionTask> getMaximalTasks(int var1, boolean var2);

    public abstract Collection<AbstractCompactionTask> getUserDefinedTasks(GroupedSSTableContainer var1, int var2);

    public GroupedSSTableContainer createGroupedSSTableContainer() {
        return new GroupedSSTableContainer(this);
    }

    public abstract void addSSTables(GroupedSSTableContainer var1);

    public abstract void removeSSTables(GroupedSSTableContainer var1);

    public abstract void replaceSSTables(GroupedSSTableContainer var1, GroupedSSTableContainer var2);

    public abstract List<ISSTableScanner> getScanners(GroupedSSTableContainer var1, Collection<Range<Token>> var2);

    public abstract SSTableMultiWriter createSSTableMultiWriter(Descriptor var1, long var2, long var4, TimeUUID var6, boolean var7, MetadataCollector var8, SerializationHeader var9, Collection<Index> var10, LifecycleNewTracker var11);

    public abstract int getStrategyIndex(AbstractCompactionStrategy var1);

    public abstract boolean containsSSTable(SSTableReader var1);

    public static class GroupedSSTableContainer {
        private final AbstractStrategyHolder holder;
        private final Set<SSTableReader>[] groups;

        private GroupedSSTableContainer(AbstractStrategyHolder holder) {
            this.holder = holder;
            Preconditions.checkArgument((holder.numTokenPartitions > 0 ? 1 : 0) != 0, (Object)"numTokenPartitions not set");
            this.groups = new Set[holder.numTokenPartitions];
        }

        void add(SSTableReader sstable) {
            Preconditions.checkArgument((boolean)this.holder.managesSSTable(sstable), (String)"this strategy holder doesn't manage %s", (Object)sstable);
            int idx = this.holder.router.getIndexForSSTable(sstable);
            Preconditions.checkState((idx >= 0 && idx < this.holder.numTokenPartitions ? 1 : 0) != 0, (String)"Invalid sstable index (%s) for %s", (int)idx, (Object)sstable);
            if (this.groups[idx] == null) {
                this.groups[idx] = new HashSet<SSTableReader>();
            }
            this.groups[idx].add(sstable);
        }

        public int numGroups() {
            return this.groups.length;
        }

        public Set<SSTableReader> getGroup(int i) {
            Preconditions.checkArgument((i >= 0 && i < this.groups.length ? 1 : 0) != 0);
            Set<SSTableReader> group = this.groups[i];
            return group != null ? group : Collections.emptySet();
        }

        boolean isGroupEmpty(int i) {
            return this.getGroup(i).isEmpty();
        }

        boolean isEmpty() {
            for (int i = 0; i < this.groups.length; ++i) {
                if (this.isGroupEmpty(i)) continue;
                return false;
            }
            return true;
        }
    }

    public static interface DestinationRouter {
        public int getIndexForSSTable(SSTableReader var1);

        public int getIndexForSSTableDirectory(Descriptor var1);
    }

    public static class TaskSupplier
    implements Comparable<TaskSupplier> {
        private final int numRemaining;
        private final Supplier<AbstractCompactionTask> supplier;

        TaskSupplier(int numRemaining, Supplier<AbstractCompactionTask> supplier) {
            this.numRemaining = numRemaining;
            this.supplier = supplier;
        }

        public AbstractCompactionTask getTask() {
            return this.supplier.get();
        }

        @Override
        public int compareTo(TaskSupplier o) {
            return o.numRemaining - this.numRemaining;
        }
    }
}

