/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_RowMutation;
import org.apache.beam.sdk.io.gcp.bigquery.RowMutationInformation;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
public abstract class RowMutation {
    public abstract @UnknownKeyFor @NonNull @Initialized TableRow getTableRow();

    public abstract @UnknownKeyFor @NonNull @Initialized RowMutationInformation getMutationInformation();

    public static @UnknownKeyFor @NonNull @Initialized RowMutation of(@UnknownKeyFor @NonNull @Initialized TableRow tableRow, @UnknownKeyFor @NonNull @Initialized RowMutationInformation rowMutationInformation) {
        return new AutoValue_RowMutation(tableRow, rowMutationInformation);
    }

    public static class RowMutationCoder
    extends AtomicCoder<RowMutation> {
        private static final @UnknownKeyFor @NonNull @Initialized RowMutationCoder INSTANCE = new RowMutationCoder();

        public static @UnknownKeyFor @NonNull @Initialized RowMutationCoder of() {
            return INSTANCE;
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized RowMutation value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            TableRowJsonCoder.of().encode(value.getTableRow(), outStream);
            VarIntCoder.of().encode(Integer.valueOf(value.getMutationInformation().getMutationType().ordinal()), outStream);
            VarLongCoder.of().encode(Long.valueOf(value.getMutationInformation().getSequenceNumber()), outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized RowMutation decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return RowMutation.of(TableRowJsonCoder.of().decode(inStream), RowMutationInformation.of(RowMutationInformation.MutationType.values()[VarIntCoder.of().decode(inStream)], VarLongCoder.of().decode(inStream)));
        }
    }
}

