/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractLazyInitializer;
import com.google.cloud.spanner.AbstractResultSet;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.CharSource;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.Value;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Value
implements Serializable {
    public static final Timestamp COMMIT_TIMESTAMP = Timestamp.ofTimeMicroseconds((long)0L);
    static final com.google.protobuf.Value NULL_PROTO = com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
    public static final String NAN = "NaN";
    private static final int MAX_DEBUG_STRING_LENGTH = 36;
    private static final String ELLIPSIS = "...";
    private static final String NULL_STRING = "NULL";
    private static final char LIST_SEPARATOR = ',';
    private static final char LIST_OPEN = '[';
    private static final char LIST_CLOSE = ']';
    private static final long serialVersionUID = -5289864325087675338L;
    private static final PrimitiveArrayValueFactory<long[], Long> int64ArrayFactory = new PrimitiveArrayValueFactory<long[], Long>(){

        @Override
        long[] newArray(int size) {
            return new long[size];
        }

        @Override
        void set(long[] arr, int i, Long value) {
            arr[i] = value;
        }

        @Override
        Value newValue(boolean isNull, BitSet nulls, long[] values) {
            return new Int64ArrayImpl(isNull, nulls, values);
        }
    };
    private static final PrimitiveArrayValueFactory<float[], Float> float32ArrayFactory = new PrimitiveArrayValueFactory<float[], Float>(){

        @Override
        float[] newArray(int size) {
            return new float[size];
        }

        @Override
        void set(float[] arr, int i, Float value) {
            arr[i] = value.floatValue();
        }

        @Override
        Value newValue(boolean isNull, BitSet nulls, float[] values) {
            return new Float32ArrayImpl(isNull, nulls, values);
        }
    };
    private static final PrimitiveArrayValueFactory<double[], Double> float64ArrayFactory = new PrimitiveArrayValueFactory<double[], Double>(){

        @Override
        double[] newArray(int size) {
            return new double[size];
        }

        @Override
        void set(double[] arr, int i, Double value) {
            arr[i] = value;
        }

        @Override
        Value newValue(boolean isNull, BitSet nulls, double[] values) {
            return new Float64ArrayImpl(isNull, nulls, values);
        }
    };
    private static final PrimitiveArrayValueFactory<boolean[], Boolean> boolArrayFactory = new PrimitiveArrayValueFactory<boolean[], Boolean>(){

        @Override
        boolean[] newArray(int size) {
            return new boolean[size];
        }

        @Override
        void set(boolean[] arr, int i, Boolean value) {
            arr[i] = value;
        }

        @Override
        Value newValue(boolean isNull, BitSet nulls, boolean[] values) {
            return new BoolArrayImpl(isNull, nulls, values);
        }
    };

    public static Value untyped(com.google.protobuf.Value value) {
        return new ProtoBackedValueImpl((com.google.protobuf.Value)Preconditions.checkNotNull((Object)value), null);
    }

    static Value unrecognized(com.google.protobuf.Value value, Type type) {
        Preconditions.checkArgument((type.getCode() == Type.Code.UNRECOGNIZED || type.getCode() == Type.Code.ARRAY && type.getArrayElementType().getCode() == Type.Code.UNRECOGNIZED ? 1 : 0) != 0);
        return new ProtoBackedValueImpl((com.google.protobuf.Value)Preconditions.checkNotNull((Object)value), type);
    }

    public static Value bool(@Nullable Boolean v) {
        return new BoolImpl(v == null, v == null ? false : v);
    }

    public static Value bool(boolean v) {
        return new BoolImpl(false, v);
    }

    public static Value int64(@Nullable Long v) {
        return new Int64Impl(v == null, v == null ? 0L : v);
    }

    public static Value int64(long v) {
        return new Int64Impl(false, v);
    }

    public static Value float32(@Nullable Float v) {
        return new Float32Impl(v == null, v == null ? 0.0f : v.floatValue());
    }

    public static Value float32(float v) {
        return new Float32Impl(false, v);
    }

    public static Value float64(@Nullable Double v) {
        return new Float64Impl(v == null, v == null ? 0.0 : v);
    }

    public static Value float64(double v) {
        return new Float64Impl(false, v);
    }

    public static Value numeric(@Nullable BigDecimal v) {
        if (v != null) {
            BigDecimal test = v.stripTrailingZeros();
            if (test.scale() > 9) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.OUT_OF_RANGE, String.format("Max scale for a numeric is 9. The requested numeric has scale %d", test.scale()));
            }
            if (test.precision() - test.scale() > 29) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.OUT_OF_RANGE, String.format("Max precision for the whole component of a numeric is 29. The requested numeric has a whole component with precision %d", test.precision() - test.scale()));
            }
        }
        return new NumericImpl(v == null, v);
    }

    public static Value pgNumeric(@Nullable String v) {
        return new PgNumericImpl(v == null, v);
    }

    public static Value string(@Nullable String v) {
        return new StringImpl(v == null, v);
    }

    public static Value json(@Nullable String v) {
        return new JsonImpl(v == null, v);
    }

    public static Value pgJsonb(@Nullable String v) {
        return new PgJsonbImpl(v == null, v);
    }

    public static Value protoMessage(AbstractMessage v) {
        Preconditions.checkNotNull((Object)v, (Object)"Use protoMessage((ByteArray) null, MyProtoClass.getDescriptor()) for null values.");
        return Value.protoMessage(ByteArray.copyFrom((byte[])v.toByteArray()), v.getDescriptorForType().getFullName());
    }

    public static Value protoMessage(@Nullable ByteArray v, String protoTypeFqn) {
        return new ProtoMessageImpl(v == null, v, protoTypeFqn);
    }

    public static Value protoMessage(@Nullable ByteArray v, Descriptors.Descriptor descriptor) {
        Preconditions.checkNotNull((Object)descriptor, (Object)"descriptor can't be null.");
        return Value.protoMessage(v, descriptor.getFullName());
    }

    public static Value protoEnum(ProtocolMessageEnum v) {
        Preconditions.checkNotNull((Object)v, (Object)"Use protoEnum((Long) null, MyProtoEnum.getDescriptor()) for null values.");
        return Value.protoEnum(v.getNumber(), v.getDescriptorForType().getFullName());
    }

    public static Value protoEnum(@Nullable Long v, String protoTypeFqn) {
        return new ProtoEnumImpl(v == null, v, protoTypeFqn);
    }

    public static Value protoEnum(@Nullable Long v, Descriptors.EnumDescriptor enumDescriptor) {
        Preconditions.checkNotNull((Object)enumDescriptor, (Object)"descriptor can't be null.");
        return Value.protoEnum(v, enumDescriptor.getFullName());
    }

    public static Value protoEnum(long v, String protoTypeFqn) {
        return new ProtoEnumImpl(false, v, protoTypeFqn);
    }

    public static Value bytes(@Nullable ByteArray v) {
        return new LazyBytesImpl(v == null, v);
    }

    public static Value bytesFromBase64(@Nullable String base64String) {
        return new LazyBytesImpl(base64String == null, base64String == null ? null : new AbstractResultSet.LazyByteArray(base64String));
    }

    static Value internalBytes(@Nullable AbstractResultSet.LazyByteArray bytes) {
        return new LazyBytesImpl(bytes == null, bytes);
    }

    public static Value timestamp(@Nullable Timestamp v) {
        return new TimestampImpl(v == null, v == COMMIT_TIMESTAMP, v);
    }

    public static Value date(@Nullable Date v) {
        return new DateImpl(v == null, v);
    }

    public static Value struct(Struct v) {
        Preconditions.checkNotNull((Object)v, (Object)"Illegal call to create a NULL struct value.");
        return new StructImpl(v);
    }

    public static Value struct(Type type, @Nullable Struct v) {
        if (v == null) {
            Preconditions.checkArgument((type.getCode() == Type.Code.STRUCT ? 1 : 0) != 0, (Object)"Illegal call to create a NULL struct with a non-struct type.");
            return new StructImpl(type);
        }
        Preconditions.checkArgument((boolean)type.equals(v.getType()), (Object)"Mismatch between struct value and type.");
        return new StructImpl(v);
    }

    public static Value boolArray(@Nullable boolean[] v) {
        return Value.boolArray(v, 0, v == null ? 0 : v.length);
    }

    public static Value boolArray(@Nullable boolean[] v, int pos, int length) {
        return boolArrayFactory.create(v, pos, length);
    }

    public static Value boolArray(@Nullable Iterable<Boolean> v) {
        return boolArrayFactory.create(v);
    }

    public static Value int64Array(@Nullable long[] v) {
        return Value.int64Array(v, 0, v == null ? 0 : v.length);
    }

    public static Value int64Array(@Nullable long[] v, int pos, int length) {
        return int64ArrayFactory.create(v, pos, length);
    }

    public static Value int64Array(@Nullable Iterable<Long> v) {
        return int64ArrayFactory.create(v);
    }

    public static Value float32Array(@Nullable float[] v) {
        return Value.float32Array(v, 0, v == null ? 0 : v.length);
    }

    public static Value float32Array(@Nullable float[] v, int pos, int length) {
        return float32ArrayFactory.create(v, pos, length);
    }

    public static Value float32Array(@Nullable Iterable<Float> v) {
        return float32ArrayFactory.create(v);
    }

    public static Value float64Array(@Nullable double[] v) {
        return Value.float64Array(v, 0, v == null ? 0 : v.length);
    }

    public static Value float64Array(@Nullable double[] v, int pos, int length) {
        return float64ArrayFactory.create(v, pos, length);
    }

    public static Value float64Array(@Nullable Iterable<Double> v) {
        return float64ArrayFactory.create(v);
    }

    public static Value numericArray(@Nullable Iterable<BigDecimal> v) {
        return new NumericArrayImpl(v == null, v == null ? null : Value.immutableCopyOf(v));
    }

    public static Value pgNumericArray(@Nullable Iterable<String> v) {
        return new PgNumericArrayImpl(v == null, v == null ? null : Value.immutableCopyOf(v));
    }

    public static Value stringArray(@Nullable Iterable<String> v) {
        return new StringArrayImpl(v == null, v == null ? null : Value.immutableCopyOf(v));
    }

    public static Value jsonArray(@Nullable Iterable<String> v) {
        return new JsonArrayImpl(v == null, v == null ? null : Value.immutableCopyOf(v));
    }

    public static Value pgJsonbArray(@Nullable Iterable<String> v) {
        return new PgJsonbArrayImpl(v == null, v == null ? null : Value.immutableCopyOf(v));
    }

    public static Value protoMessageArray(@Nullable Iterable<AbstractMessage> v, Descriptors.Descriptor descriptor) {
        if (v == null) {
            return new ProtoMessageArrayImpl(true, null, descriptor.getFullName());
        }
        ArrayList serializedArray = new ArrayList();
        v.forEach(message -> {
            if (message != null) {
                serializedArray.add(ByteArray.copyFrom((byte[])message.toByteArray()));
            } else {
                serializedArray.add(null);
            }
        });
        return new ProtoMessageArrayImpl(false, serializedArray, descriptor.getFullName());
    }

    public static Value protoMessageArray(@Nullable Iterable<ByteArray> v, String protoTypeFqn) {
        return new ProtoMessageArrayImpl(v == null, v != null ? Value.immutableCopyOf(v) : null, protoTypeFqn);
    }

    public static Value protoEnumArray(@Nullable Iterable<ProtocolMessageEnum> v, Descriptors.EnumDescriptor descriptor) {
        if (v == null) {
            return new ProtoEnumArrayImpl(true, null, descriptor.getFullName());
        }
        ArrayList enumConstValues = new ArrayList();
        v.forEach(protoEnum -> {
            if (protoEnum != null) {
                enumConstValues.add(Long.valueOf(protoEnum.getNumber()));
            } else {
                enumConstValues.add(null);
            }
        });
        return new ProtoEnumArrayImpl(false, enumConstValues, descriptor.getFullName());
    }

    public static Value protoEnumArray(@Nullable Iterable<Long> v, String protoTypeFqn) {
        return new ProtoEnumArrayImpl(v == null, v != null ? Value.immutableCopyOf(v) : null, protoTypeFqn);
    }

    public static Value bytesArray(@Nullable Iterable<ByteArray> v) {
        return new LazyBytesArrayImpl(v == null, v == null ? null : Value.byteArraysToLazyByteArrayList(v));
    }

    private static List<AbstractResultSet.LazyByteArray> byteArraysToLazyByteArrayList(Iterable<ByteArray> byteArrays) {
        ArrayList<AbstractResultSet.LazyByteArray> list = new ArrayList<AbstractResultSet.LazyByteArray>();
        for (ByteArray byteArray : byteArrays) {
            list.add(byteArray == null ? null : new AbstractResultSet.LazyByteArray(byteArray));
        }
        return Collections.unmodifiableList(list);
    }

    public static Value bytesArrayFromBase64(@Nullable Iterable<String> base64Strings) {
        return new LazyBytesArrayImpl(base64Strings == null, base64Strings == null ? null : Value.base64StringsToLazyByteArrayList(base64Strings));
    }

    private static List<AbstractResultSet.LazyByteArray> base64StringsToLazyByteArrayList(Iterable<String> base64Strings) {
        ArrayList<AbstractResultSet.LazyByteArray> list = new ArrayList<AbstractResultSet.LazyByteArray>();
        for (String base64 : base64Strings) {
            list.add(base64 == null ? null : new AbstractResultSet.LazyByteArray(base64));
        }
        return Collections.unmodifiableList(list);
    }

    public static Value timestampArray(@Nullable Iterable<Timestamp> v) {
        return new TimestampArrayImpl(v == null, v == null ? null : Value.immutableCopyOf(v));
    }

    public static Value dateArray(@Nullable Iterable<Date> v) {
        return new DateArrayImpl(v == null, v == null ? null : Value.immutableCopyOf(v));
    }

    public static Value structArray(Type elementType, @Nullable Iterable<Struct> v) {
        if (v == null) {
            Preconditions.checkArgument((elementType.getCode() == Type.Code.STRUCT ? 1 : 0) != 0, (Object)"Illegal call to create a NULL array-of-struct with a non-struct element type.");
            return new StructArrayImpl(elementType, null);
        }
        List<Struct> values = Value.immutableCopyOf(v);
        for (Struct value : values) {
            if (value == null) continue;
            Preconditions.checkArgument((boolean)value.getType().equals(elementType), (String)"Members of v must have type %s (found %s)", (Object)elementType, (Object)value.getType());
        }
        return new StructArrayImpl(elementType, values);
    }

    private Value() {
    }

    public abstract Type getType();

    public abstract boolean isNull();

    public abstract boolean getBool();

    public abstract long getInt64();

    public abstract float getFloat32();

    public abstract double getFloat64();

    public abstract BigDecimal getNumeric();

    public abstract String getString();

    public String getJson() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getPgJsonb() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <T extends AbstractMessage> T getProtoMessage(T m) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <T extends ProtocolMessageEnum> T getProtoEnum(Function<Integer, ProtocolMessageEnum> method) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public abstract ByteArray getBytes();

    public abstract Timestamp getTimestamp();

    public abstract boolean isCommitTimestamp();

    public abstract Date getDate();

    public abstract Struct getStruct();

    public abstract List<Boolean> getBoolArray();

    public abstract List<Long> getInt64Array();

    public abstract List<Float> getFloat32Array();

    public abstract List<Double> getFloat64Array();

    public abstract List<BigDecimal> getNumericArray();

    public abstract List<String> getStringArray();

    public List<String> getJsonArray() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<String> getPgJsonbArray() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <T extends AbstractMessage> List<T> getProtoMessageArray(T m) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <T extends ProtocolMessageEnum> List<T> getProtoEnumArray(Function<Integer, ProtocolMessageEnum> method) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public abstract List<ByteArray> getBytesArray();

    public abstract List<Timestamp> getTimestampArray();

    public abstract List<Date> getDateArray();

    public abstract List<Struct> getStructArray();

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    @Nonnull
    public String getAsString() {
        return this.toString();
    }

    @Nonnull
    public ImmutableList<String> getAsStringList() {
        return ImmutableList.of((Object)this.toString());
    }

    static com.google.protobuf.Value toProto(Value value) {
        return value == null ? NULL_PROTO : value.toProto();
    }

    abstract void toString(StringBuilder var1);

    abstract com.google.protobuf.Value toProto();

    private static <T> List<T> immutableCopyOf(Iterable<T> v) {
        ArrayList copy = new ArrayList();
        Iterables.addAll(copy, v);
        return Collections.unmodifiableList(copy);
    }

    private static class ProtoBackedValueImpl
    extends AbstractValue {
        private final com.google.protobuf.Value value;

        private ProtoBackedValueImpl(com.google.protobuf.Value value, @Nullable Type type) {
            super(value.hasNullValue(), type);
            this.value = value;
        }

        @Override
        public boolean getBool() {
            this.checkNotNull();
            Preconditions.checkState((boolean)this.value.hasBoolValue(), (Object)"This value does not contain a bool value");
            return this.value.getBoolValue();
        }

        @Override
        public String getString() {
            this.checkNotNull();
            Preconditions.checkState((boolean)this.value.hasStringValue(), (Object)"This value does not contain a string value");
            return this.value.getStringValue();
        }

        @Override
        public double getFloat64() {
            this.checkNotNull();
            Preconditions.checkState((boolean)this.value.hasNumberValue(), (Object)"This value does not contain a number value");
            return this.value.getNumberValue();
        }

        @Override
        @Nonnull
        public String getAsString() {
            switch (this.value.getKindCase()) {
                case NULL_VALUE: {
                    return Value.NULL_STRING;
                }
                case NUMBER_VALUE: {
                    return Double.toString(this.value.getNumberValue());
                }
                case STRING_VALUE: {
                    return this.value.getStringValue();
                }
                case BOOL_VALUE: {
                    return Boolean.toString(this.value.getBoolValue());
                }
                case LIST_VALUE: {
                    return this.value.getListValue().getValuesList().stream().map(element -> Value.untyped(element).getAsString()).collect(Collectors.joining(",", "[", "]"));
                }
                case STRUCT_VALUE: {
                    throw new IllegalArgumentException("Struct value with unrecognized type is not supported");
                }
            }
            throw new IllegalArgumentException("Kind of value is not set or unknown");
        }

        @Override
        @Nonnull
        public ImmutableList<String> getAsStringList() {
            if (this.value.getKindCase() == Value.KindCase.LIST_VALUE) {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.value.getListValue().getValuesList().stream().map(v -> Value.untyped(v).getAsString()).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                return builder.build();
            }
            return ImmutableList.of((Object)this.getAsString());
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append(this.value);
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            return this.value;
        }

        @Override
        boolean valueEquals(Value v) {
            return ((ProtoBackedValueImpl)v).value.equals((Object)this.value);
        }

        @Override
        int valueHash() {
            return this.value.hashCode();
        }
    }

    private static class BoolImpl
    extends AbstractValue {
        private final boolean value;

        private BoolImpl(boolean isNull, boolean value) {
            super(isNull, Type.bool());
            this.value = value;
        }

        @Override
        public boolean getBool() {
            this.checkNotNull();
            return this.value;
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            return com.google.protobuf.Value.newBuilder().setBoolValue(this.value).build();
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append(this.value);
        }

        @Override
        boolean valueEquals(Value v) {
            return ((BoolImpl)v).value == this.value;
        }

        @Override
        int valueHash() {
            return Boolean.valueOf(this.value).hashCode();
        }
    }

    private static class Int64Impl
    extends AbstractValue {
        private final long value;

        private Int64Impl(boolean isNull, long value) {
            super(isNull, Type.int64());
            this.value = value;
        }

        @Override
        public long getInt64() {
            this.checkNotNull();
            return this.value;
        }

        @Override
        public <T extends ProtocolMessageEnum> T getProtoEnum(Function<Integer, ProtocolMessageEnum> method) {
            Preconditions.checkNotNull(method, (Object)"Method may not be null. Use 'MyProtoEnum::forNumber' as a parameter value.");
            this.checkNotNull();
            return (T)method.apply((int)this.value);
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            return com.google.protobuf.Value.newBuilder().setStringValue(Long.toString(this.value)).build();
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append(this.value);
        }

        @Override
        boolean valueEquals(Value v) {
            return ((Int64Impl)v).value == this.value;
        }

        @Override
        int valueHash() {
            return Long.valueOf(this.value).hashCode();
        }
    }

    private static class Float32Impl
    extends AbstractValue {
        private final float value;

        private Float32Impl(boolean isNull, float value) {
            super(isNull, Type.float32());
            this.value = value;
        }

        @Override
        public float getFloat32() {
            this.checkNotNull();
            return this.value;
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            return com.google.protobuf.Value.newBuilder().setNumberValue((double)this.value).build();
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append(this.value);
        }

        @Override
        boolean valueEquals(Value v) {
            if (Float.isNaN(this.value)) {
                return Float.isNaN(((Float32Impl)v).value);
            }
            return ((Float32Impl)v).value == this.value;
        }

        @Override
        int valueHash() {
            if (!this.isNull() && Float.isNaN(this.value)) {
                return Double.valueOf(Double.NaN).hashCode();
            }
            return Float.valueOf(this.value).hashCode();
        }
    }

    private static class Float64Impl
    extends AbstractValue {
        private final double value;

        private Float64Impl(boolean isNull, double value) {
            super(isNull, Type.float64());
            this.value = value;
        }

        @Override
        public double getFloat64() {
            this.checkNotNull();
            return this.value;
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            return com.google.protobuf.Value.newBuilder().setNumberValue(this.value).build();
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append(this.value);
        }

        @Override
        boolean valueEquals(Value v) {
            if (Double.isNaN(this.value)) {
                return Double.isNaN(((Float64Impl)v).value);
            }
            return ((Float64Impl)v).value == this.value;
        }

        @Override
        int valueHash() {
            return Double.valueOf(this.value).hashCode();
        }
    }

    private static class NumericImpl
    extends AbstractObjectValue<BigDecimal> {
        private NumericImpl(boolean isNull, BigDecimal value) {
            super(isNull, Type.numeric(), value);
        }

        @Override
        public BigDecimal getNumeric() {
            this.checkNotNull();
            return (BigDecimal)this.value;
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append(this.value);
        }
    }

    private static class PgNumericImpl
    extends AbstractObjectValue<String> {
        private BigDecimal valueAsBigDecimal;
        private NumberFormatException bigDecimalConversionError;
        private Double valueAsDouble;
        private NumberFormatException doubleConversionError;

        private PgNumericImpl(boolean isNull, String value) {
            super(isNull, Type.pgNumeric(), value);
        }

        @Override
        public String getString() {
            this.checkNotNull();
            return (String)this.value;
        }

        @Override
        public BigDecimal getNumeric() {
            this.checkNotNull();
            if (this.bigDecimalConversionError != null) {
                throw this.bigDecimalConversionError;
            }
            if (this.valueAsBigDecimal == null) {
                try {
                    this.valueAsBigDecimal = new BigDecimal((String)this.value);
                }
                catch (NumberFormatException e) {
                    this.bigDecimalConversionError = e;
                    throw e;
                }
            }
            return this.valueAsBigDecimal;
        }

        @Override
        public double getFloat64() {
            this.checkNotNull();
            if (this.doubleConversionError != null) {
                throw this.doubleConversionError;
            }
            if (this.valueAsDouble == null) {
                try {
                    this.valueAsDouble = Double.parseDouble((String)this.value);
                }
                catch (NumberFormatException e) {
                    this.doubleConversionError = e;
                    throw e;
                }
            }
            return this.valueAsDouble;
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append((String)this.value);
        }
    }

    private static class StringImpl
    extends AbstractObjectValue<String> {
        private StringImpl(boolean isNull, @Nullable String value) {
            super(isNull, Type.string(), value);
        }

        @Override
        public String getString() {
            this.checkNotNull();
            return (String)this.value;
        }

        @Override
        @Nonnull
        public String getAsString() {
            return this.isNull() ? Value.NULL_STRING : (String)this.value;
        }

        @Override
        void valueToString(StringBuilder b) {
            if (((String)this.value).length() > 36) {
                b.append((CharSequence)this.value, 0, 36 - Value.ELLIPSIS.length()).append(Value.ELLIPSIS);
            } else {
                b.append((String)this.value);
            }
        }
    }

    private static class JsonImpl
    extends AbstractObjectValue<String> {
        private JsonImpl(boolean isNull, @Nullable String value) {
            super(isNull, Type.json(), value);
        }

        @Override
        public String getJson() {
            this.checkNotNull();
            return (String)this.value;
        }

        @Override
        @Nonnull
        public String getAsString() {
            return this.isNull() ? Value.NULL_STRING : (String)this.value;
        }

        @Override
        public String getString() {
            return this.getJson();
        }

        @Override
        void valueToString(StringBuilder b) {
            if (((String)this.value).length() > 36) {
                b.append((CharSequence)this.value, 0, 36 - Value.ELLIPSIS.length()).append(Value.ELLIPSIS);
            } else {
                b.append((String)this.value);
            }
        }
    }

    private static class PgJsonbImpl
    extends AbstractObjectValue<String> {
        private PgJsonbImpl(boolean isNull, @Nullable String value) {
            super(isNull, Type.pgJsonb(), value);
        }

        @Override
        public String getPgJsonb() {
            this.checkNotNull();
            return (String)this.value;
        }

        @Override
        @Nonnull
        public String getAsString() {
            return this.isNull() ? Value.NULL_STRING : (String)this.value;
        }

        @Override
        public String getString() {
            return this.getPgJsonb();
        }

        @Override
        void valueToString(StringBuilder b) {
            if (((String)this.value).length() > 36) {
                b.append((CharSequence)this.value, 0, 36 - Value.ELLIPSIS.length()).append(Value.ELLIPSIS);
            } else {
                b.append((String)this.value);
            }
        }
    }

    private static class ProtoMessageImpl
    extends AbstractObjectValue<ByteArray> {
        private ProtoMessageImpl(boolean isNull, ByteArray serializedProtoArray, String protoTypeFqn) {
            super(isNull, Type.proto(protoTypeFqn), serializedProtoArray);
        }

        @Override
        public ByteArray getBytes() {
            this.checkNotNull();
            return (ByteArray)this.value;
        }

        @Override
        public <T extends AbstractMessage> T getProtoMessage(T m) {
            Preconditions.checkNotNull(m, (Object)"Proto message may not be null. Use MyProtoClass.getDefaultInstance() as a parameter value.");
            this.checkNotNull();
            try {
                return (T)((AbstractMessage)m.toBuilder().mergeFrom(((ByteArray)this.value).toByteArray()).build());
            }
            catch (InvalidProtocolBufferException e) {
                throw SpannerExceptionFactory.asSpannerException(e);
            }
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            String base64EncodedString = ((ByteArray)this.value).toBase64();
            return com.google.protobuf.Value.newBuilder().setStringValue(base64EncodedString).build();
        }

        @Override
        @Nonnull
        public String getAsString() {
            return this.value == null ? Value.NULL_STRING : ((ByteArray)this.value).toBase64();
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append(((ByteArray)this.value).toBase64());
        }
    }

    private static class ProtoEnumImpl
    extends AbstractObjectValue<Long> {
        private ProtoEnumImpl(boolean isNull, Long enumValue, String protoTypeFqn) {
            super(isNull, Type.protoEnum(protoTypeFqn), enumValue);
        }

        @Override
        public long getInt64() {
            this.checkNotNull();
            return (Long)this.value;
        }

        @Override
        public <T extends ProtocolMessageEnum> T getProtoEnum(Function<Integer, ProtocolMessageEnum> method) {
            Preconditions.checkNotNull(method, (Object)"Method may not be null. Use 'MyProtoEnum::forNumber' as a parameter value.");
            this.checkNotNull();
            return (T)method.apply(((Long)this.value).intValue());
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append(((Long)this.value).toString());
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            return com.google.protobuf.Value.newBuilder().setStringValue(Long.toString((Long)this.value)).build();
        }
    }

    private static class LazyBytesImpl
    extends AbstractObjectValue<AbstractResultSet.LazyByteArray> {
        private LazyBytesImpl(boolean isNull, AbstractResultSet.LazyByteArray value) {
            super(isNull, Type.bytes(), value);
        }

        private LazyBytesImpl(boolean isNull, ByteArray value) {
            super(isNull, Type.bytes(), value == null ? null : new AbstractResultSet.LazyByteArray(value));
        }

        @Override
        public ByteArray getBytes() {
            this.checkNotNull();
            return ((AbstractResultSet.LazyByteArray)this.value).getByteArray();
        }

        @Override
        public <T extends AbstractMessage> T getProtoMessage(T m) {
            Preconditions.checkNotNull(m, (Object)"Proto message may not be null. Use MyProtoClass.getDefaultInstance() as a parameter value.");
            this.checkNotNull();
            try {
                return (T)((AbstractMessage)m.toBuilder().mergeFrom(Base64.getDecoder().wrap(CharSource.wrap((CharSequence)((AbstractResultSet.LazyByteArray)this.value).getBase64String()).asByteSource(StandardCharsets.UTF_8).openStream())).build());
            }
            catch (IOException ioException) {
                throw SpannerExceptionFactory.asSpannerException(ioException);
            }
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            return com.google.protobuf.Value.newBuilder().setStringValue(((AbstractResultSet.LazyByteArray)this.value).getBase64String()).build();
        }

        @Override
        @Nonnull
        public String getAsString() {
            return this.value == null ? Value.NULL_STRING : ((AbstractResultSet.LazyByteArray)this.value).getBase64String();
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append(this.value == null ? null : ((AbstractResultSet.LazyByteArray)this.value).toString());
        }
    }

    private static class TimestampImpl
    extends AbstractObjectValue<Timestamp> {
        private static final String COMMIT_TIMESTAMP_STRING = "spanner.commit_timestamp()";
        private final boolean isCommitTimestamp;

        private TimestampImpl(boolean isNull, boolean isCommitTimestamp, Timestamp value) {
            super(isNull, Type.timestamp(), value);
            this.isCommitTimestamp = isCommitTimestamp;
        }

        @Override
        public Timestamp getTimestamp() {
            this.checkNotNull();
            Preconditions.checkState((!this.isCommitTimestamp ? 1 : 0) != 0, (Object)"Commit timestamp value");
            return (Timestamp)this.value;
        }

        @Override
        public boolean isCommitTimestamp() {
            return this.isCommitTimestamp;
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            if (this.isCommitTimestamp) {
                return com.google.protobuf.Value.newBuilder().setStringValue(COMMIT_TIMESTAMP_STRING).build();
            }
            return super.valueToProto();
        }

        @Override
        void valueToString(StringBuilder b) {
            if (this.isCommitTimestamp()) {
                b.append(COMMIT_TIMESTAMP_STRING);
            } else {
                b.append(this.value);
            }
        }

        @Override
        boolean valueEquals(Value v) {
            if (this.isCommitTimestamp) {
                return v.isCommitTimestamp();
            }
            if (v.isCommitTimestamp()) {
                return this.isCommitTimestamp;
            }
            return ((Timestamp)((TimestampImpl)v).value).equals(this.value);
        }

        @Override
        int valueHash() {
            if (this.isCommitTimestamp) {
                return Objects.hashCode(this.isCommitTimestamp);
            }
            return ((Timestamp)this.value).hashCode();
        }
    }

    private static class DateImpl
    extends AbstractObjectValue<Date> {
        private DateImpl(boolean isNull, Date value) {
            super(isNull, Type.date(), value);
        }

        @Override
        public Date getDate() {
            this.checkNotNull();
            return (Date)this.value;
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append(this.value);
        }
    }

    private static class StructImpl
    extends AbstractObjectValue<Struct> {
        private StructImpl(Struct value) {
            super(false, value.getType(), value);
        }

        private StructImpl(Type structType) {
            super(true, structType, null);
        }

        @Override
        public Struct getStruct() {
            this.checkNotNull();
            return (Struct)this.value;
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append(this.value);
        }

        @Override
        int valueHash() {
            return ((Struct)this.value).hashCode();
        }

        @Override
        boolean valueEquals(Value v) {
            return ((Struct)((StructImpl)v).value).equals(this.value);
        }

        private Value getValue(int fieldIndex) {
            Type fieldType = ((Struct)this.value).getColumnType(fieldIndex);
            switch (fieldType.getCode()) {
                case BOOL: {
                    return Value.bool(((Struct)this.value).getBoolean(fieldIndex));
                }
                case INT64: {
                    return Value.int64(((Struct)this.value).getLong(fieldIndex));
                }
                case STRING: {
                    return Value.string(((Struct)this.value).getString(fieldIndex));
                }
                case JSON: {
                    return Value.json(((Struct)this.value).getJson(fieldIndex));
                }
                case PG_JSONB: {
                    return Value.pgJsonb(((Struct)this.value).getPgJsonb(fieldIndex));
                }
                case BYTES: {
                    return Value.bytes(((Struct)this.value).getBytes(fieldIndex));
                }
                case FLOAT32: {
                    return Value.float32(((Struct)this.value).getFloat(fieldIndex));
                }
                case FLOAT64: {
                    return Value.float64(((Struct)this.value).getDouble(fieldIndex));
                }
                case NUMERIC: {
                    return Value.numeric(((Struct)this.value).getBigDecimal(fieldIndex));
                }
                case PG_NUMERIC: {
                    return Value.pgNumeric(((Struct)this.value).getString(fieldIndex));
                }
                case DATE: {
                    return Value.date(((Struct)this.value).getDate(fieldIndex));
                }
                case TIMESTAMP: {
                    return Value.timestamp(((Struct)this.value).getTimestamp(fieldIndex));
                }
                case PROTO: {
                    return Value.protoMessage(((Struct)this.value).getBytes(fieldIndex), fieldType.getProtoTypeFqn());
                }
                case ENUM: {
                    return Value.protoEnum(((Struct)this.value).getLong(fieldIndex), fieldType.getProtoTypeFqn());
                }
                case STRUCT: {
                    return Value.struct(((Struct)this.value).getStruct(fieldIndex));
                }
                case ARRAY: {
                    Type elementType = fieldType.getArrayElementType();
                    switch (elementType.getCode()) {
                        case BOOL: {
                            return Value.boolArray(((Struct)this.value).getBooleanList(fieldIndex));
                        }
                        case INT64: 
                        case ENUM: {
                            return Value.int64Array(((Struct)this.value).getLongList(fieldIndex));
                        }
                        case STRING: {
                            return Value.stringArray(((Struct)this.value).getStringList(fieldIndex));
                        }
                        case JSON: {
                            return Value.jsonArray(((Struct)this.value).getJsonList(fieldIndex));
                        }
                        case PG_JSONB: {
                            return Value.pgJsonbArray(((Struct)this.value).getPgJsonbList(fieldIndex));
                        }
                        case BYTES: 
                        case PROTO: {
                            return Value.bytesArray(((Struct)this.value).getBytesList(fieldIndex));
                        }
                        case FLOAT32: {
                            return Value.float32Array(((Struct)this.value).getFloatList(fieldIndex));
                        }
                        case FLOAT64: {
                            return Value.float64Array(((Struct)this.value).getDoubleList(fieldIndex));
                        }
                        case NUMERIC: {
                            return Value.numericArray(((Struct)this.value).getBigDecimalList(fieldIndex));
                        }
                        case PG_NUMERIC: {
                            return Value.pgNumericArray(((Struct)this.value).getStringList(fieldIndex));
                        }
                        case DATE: {
                            return Value.dateArray(((Struct)this.value).getDateList(fieldIndex));
                        }
                        case TIMESTAMP: {
                            return Value.timestampArray(((Struct)this.value).getTimestampList(fieldIndex));
                        }
                        case STRUCT: {
                            return Value.structArray(elementType, ((Struct)this.value).getStructList(fieldIndex));
                        }
                        case ARRAY: {
                            throw new UnsupportedOperationException("ARRAY<ARRAY...> field types are not supported inside STRUCT-typed values.");
                        }
                    }
                    throw new IllegalArgumentException("Unrecognized array element type : " + fieldType);
                }
            }
            throw new IllegalArgumentException("Unrecognized field type : " + fieldType);
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            this.checkNotNull();
            ListValue.Builder struct = ListValue.newBuilder();
            for (int fieldIndex = 0; fieldIndex < ((Struct)this.value).getColumnCount(); ++fieldIndex) {
                if (((Struct)this.value).isNull(fieldIndex)) {
                    struct.addValues(NULL_PROTO);
                    continue;
                }
                struct.addValues(this.getValue(fieldIndex).toProto());
            }
            return com.google.protobuf.Value.newBuilder().setListValue(struct).build();
        }
    }

    private static abstract class PrimitiveArrayValueFactory<A, T> {
        private PrimitiveArrayValueFactory() {
        }

        Value create(A v, int pos, int length) {
            if (v == null) {
                return this.newValue(true, null, null);
            }
            A copy = this.newArray(length);
            System.arraycopy(v, pos, copy, 0, length);
            return this.newValue(false, null, copy);
        }

        Value create(@Nullable Iterable<T> v) {
            if (v == null) {
                return this.newValue(true, null, null);
            }
            Collection values = v instanceof Collection ? (Collection)v : Lists.newArrayList(v);
            BitSet nulls = null;
            A arr = this.newArray(values.size());
            int i = 0;
            for (Object element : values) {
                if (element == null) {
                    if (nulls == null) {
                        nulls = new BitSet();
                    }
                    nulls.set(i);
                } else {
                    this.set(arr, i, element);
                }
                ++i;
            }
            return this.newValue(false, nulls, arr);
        }

        abstract A newArray(int var1);

        abstract void set(A var1, int var2, T var3);

        abstract Value newValue(boolean var1, BitSet var2, A var3);
    }

    private static class NumericArrayImpl
    extends AbstractArrayValue<BigDecimal> {
        private NumericArrayImpl(boolean isNull, @Nullable List<BigDecimal> values) {
            super(isNull, Type.numeric(), values);
        }

        @Override
        public List<BigDecimal> getNumericArray() {
            this.checkNotNull();
            return (List)this.value;
        }

        @Override
        void appendElement(StringBuilder b, BigDecimal element) {
            b.append(element);
        }
    }

    private static class PgNumericArrayImpl
    extends AbstractArrayValue<String> {
        private List<BigDecimal> valuesAsBigDecimal;
        private NumberFormatException bigDecimalConversionError;
        private List<Double> valuesAsDouble;
        private NumberFormatException doubleConversionError;

        private PgNumericArrayImpl(boolean isNull, @Nullable List<String> values) {
            super(isNull, Type.pgNumeric(), values);
        }

        @Override
        public List<String> getStringArray() {
            this.checkNotNull();
            return (List)this.value;
        }

        @Override
        public List<BigDecimal> getNumericArray() {
            this.checkNotNull();
            if (this.bigDecimalConversionError != null) {
                throw this.bigDecimalConversionError;
            }
            if (this.valuesAsBigDecimal == null) {
                try {
                    this.valuesAsBigDecimal = ((List)this.value).stream().map(v -> v == null ? null : new BigDecimal((String)v)).collect(Collectors.toList());
                }
                catch (NumberFormatException e) {
                    this.bigDecimalConversionError = e;
                    throw e;
                }
            }
            return this.valuesAsBigDecimal;
        }

        @Override
        public List<Double> getFloat64Array() {
            this.checkNotNull();
            if (this.doubleConversionError != null) {
                throw this.doubleConversionError;
            }
            if (this.valuesAsDouble == null) {
                try {
                    this.valuesAsDouble = ((List)this.value).stream().map(v -> v == null ? null : Double.valueOf(v)).collect(Collectors.toList());
                }
                catch (NumberFormatException e) {
                    this.doubleConversionError = e;
                    throw e;
                }
            }
            return this.valuesAsDouble;
        }

        @Override
        void appendElement(StringBuilder b, String element) {
            b.append(element);
        }
    }

    private static class StringArrayImpl
    extends AbstractArrayValue<String> {
        private StringArrayImpl(boolean isNull, @Nullable List<String> values) {
            super(isNull, Type.string(), values);
        }

        @Override
        public List<String> getStringArray() {
            this.checkNotNull();
            return (List)this.value;
        }

        @Override
        void appendElement(StringBuilder b, String element) {
            b.append(element);
        }
    }

    private static class JsonArrayImpl
    extends AbstractArrayValue<String> {
        private JsonArrayImpl(boolean isNull, @Nullable List<String> values) {
            super(isNull, Type.json(), values);
        }

        @Override
        public List<String> getJsonArray() {
            this.checkNotNull();
            return (List)this.value;
        }

        @Override
        public List<String> getStringArray() {
            return this.getJsonArray();
        }

        @Override
        void appendElement(StringBuilder b, String element) {
            b.append(element);
        }
    }

    private static class PgJsonbArrayImpl
    extends AbstractArrayValue<String> {
        private PgJsonbArrayImpl(boolean isNull, @Nullable List<String> values) {
            super(isNull, Type.pgJsonb(), values);
        }

        @Override
        public List<String> getPgJsonbArray() {
            this.checkNotNull();
            return (List)this.value;
        }

        @Override
        public List<String> getStringArray() {
            return this.getPgJsonbArray();
        }

        @Override
        void appendElement(StringBuilder b, String element) {
            b.append(element);
        }
    }

    private static class ProtoMessageArrayImpl
    extends AbstractArrayValue<ByteArray> {
        private ProtoMessageArrayImpl(boolean isNull, @Nullable List<ByteArray> values, String protoTypeFqn) {
            super(isNull, Type.proto(protoTypeFqn), values);
        }

        @Override
        public List<ByteArray> getBytesArray() {
            return (List)this.value;
        }

        @Override
        public <T extends AbstractMessage> List<T> getProtoMessageArray(T m) {
            Preconditions.checkNotNull(m, (Object)"Proto message may not be null. Use MyProtoClass.getDefaultInstance() as a parameter value.");
            this.checkNotNull();
            try {
                ArrayList<AbstractMessage> protoMessagesList = new ArrayList<AbstractMessage>(((List)this.value).size());
                for (ByteArray protoMessageBytes : (List)this.value) {
                    if (protoMessageBytes == null) {
                        protoMessagesList.add(null);
                        continue;
                    }
                    protoMessagesList.add((AbstractMessage)m.toBuilder().mergeFrom(protoMessageBytes.toByteArray()).build());
                }
                return protoMessagesList;
            }
            catch (InvalidProtocolBufferException e) {
                throw SpannerExceptionFactory.asSpannerException(e);
            }
        }

        @Override
        String elementToString(ByteArray element) {
            return element.toBase64();
        }

        @Override
        void appendElement(StringBuilder b, ByteArray element) {
            b.append(element.toBase64());
        }
    }

    private static class ProtoEnumArrayImpl
    extends AbstractArrayValue<Long> {
        private ProtoEnumArrayImpl(boolean isNull, @Nullable List<Long> values, String protoTypeFqn) {
            super(isNull, Type.protoEnum(protoTypeFqn), values);
        }

        @Override
        public List<Long> getInt64Array() {
            return (List)this.value;
        }

        @Override
        public <T extends ProtocolMessageEnum> List<T> getProtoEnumArray(Function<Integer, ProtocolMessageEnum> method) {
            Preconditions.checkNotNull(method, (Object)"Method may not be null. Use 'MyProtoEnum::forNumber' as a parameter value.");
            this.checkNotNull();
            ArrayList<ProtocolMessageEnum> protoEnumList = new ArrayList<ProtocolMessageEnum>();
            for (Long enumIntValue : (List)this.value) {
                if (enumIntValue == null) {
                    protoEnumList.add(null);
                    continue;
                }
                protoEnumList.add(method.apply(enumIntValue.intValue()));
            }
            return protoEnumList;
        }

        @Override
        String elementToString(Long element) {
            return Long.toString(element);
        }

        @Override
        void appendElement(StringBuilder b, Long element) {
            b.append(element);
        }
    }

    private static class LazyBytesArrayImpl
    extends AbstractArrayValue<AbstractResultSet.LazyByteArray> {
        private transient AbstractLazyInitializer<List<ByteArray>> bytesArray = this.defaultInitializer();

        private LazyBytesArrayImpl(boolean isNull, @Nullable List<AbstractResultSet.LazyByteArray> values) {
            super(isNull, Type.bytes(), values);
        }

        private AbstractLazyInitializer<List<ByteArray>> defaultInitializer() {
            return new AbstractLazyInitializer<List<ByteArray>>(){

                @Override
                protected List<ByteArray> initialize() {
                    return ((List)value).stream().map(element -> element == null ? null : element.getByteArray()).collect(Collectors.toList());
                }
            };
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.bytesArray = this.defaultInitializer();
        }

        @Override
        public List<ByteArray> getBytesArray() {
            this.checkNotNull();
            try {
                return this.bytesArray.get();
            }
            catch (Exception e) {
                throw SpannerExceptionFactory.asSpannerException(e);
            }
        }

        @Override
        public <T extends AbstractMessage> List<T> getProtoMessageArray(T m) {
            Preconditions.checkNotNull(m, (Object)"Proto message may not be null. Use MyProtoClass.getDefaultInstance() as a parameter value.");
            this.checkNotNull();
            try {
                ArrayList<AbstractMessage> protoMessagesList = new ArrayList<AbstractMessage>(((List)this.value).size());
                for (AbstractResultSet.LazyByteArray protoMessageBytes : (List)this.value) {
                    if (protoMessageBytes == null) {
                        protoMessagesList.add(null);
                        continue;
                    }
                    protoMessagesList.add((AbstractMessage)m.toBuilder().mergeFrom(Base64.getDecoder().wrap(CharSource.wrap((CharSequence)protoMessageBytes.getBase64String()).asByteSource(StandardCharsets.UTF_8).openStream())).build());
                }
                return protoMessagesList;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        String elementToString(AbstractResultSet.LazyByteArray element) {
            return element.getBase64String();
        }

        @Override
        void appendElement(StringBuilder b, AbstractResultSet.LazyByteArray element) {
            b.append(this.elementToString(element));
        }
    }

    private static class TimestampArrayImpl
    extends AbstractArrayValue<Timestamp> {
        private TimestampArrayImpl(boolean isNull, @Nullable List<Timestamp> values) {
            super(isNull, Type.timestamp(), values);
        }

        @Override
        public List<Timestamp> getTimestampArray() {
            this.checkNotNull();
            return (List)this.value;
        }

        @Override
        void appendElement(StringBuilder b, Timestamp element) {
            b.append(element);
        }
    }

    private static class DateArrayImpl
    extends AbstractArrayValue<Date> {
        private DateArrayImpl(boolean isNull, @Nullable List<Date> values) {
            super(isNull, Type.date(), values);
        }

        @Override
        public List<Date> getDateArray() {
            this.checkNotNull();
            return (List)this.value;
        }

        @Override
        void appendElement(StringBuilder b, Date element) {
            b.append(element);
        }
    }

    private static class StructArrayImpl
    extends AbstractArrayValue<Struct> {
        private static final Joiner joiner = Joiner.on((char)',').useForNull("NULL");

        private StructArrayImpl(Type elementType, @Nullable List<Struct> values) {
            super(values == null, elementType, values);
        }

        @Override
        public List<Struct> getStructArray() {
            this.checkNotNull();
            return (List)this.value;
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            ListValue.Builder list = ListValue.newBuilder();
            for (Struct element : (List)this.value) {
                if (element == null) {
                    list.addValues(NULL_PROTO);
                    continue;
                }
                list.addValues(Value.struct(element).toProto());
            }
            return com.google.protobuf.Value.newBuilder().setListValue(list).build();
        }

        @Override
        void appendElement(StringBuilder b, Struct element) {
            b.append(element);
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append('[');
            joiner.appendTo(b, (Iterable)this.value);
            b.append(']');
        }

        @Override
        boolean valueEquals(Value v) {
            return ((List)((StructArrayImpl)v).value).equals(this.value);
        }

        @Override
        int valueHash() {
            return ((List)this.value).hashCode();
        }
    }

    static abstract class AbstractArrayValue<T>
    extends AbstractObjectValue<List<T>> {
        private AbstractArrayValue(boolean isNull, Type elementType, @Nullable List<T> values) {
            super(isNull, Type.array(elementType), values);
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            ListValue.Builder list = ListValue.newBuilder();
            for (Object element : (List)this.value) {
                if (element == null) {
                    list.addValues(NULL_PROTO);
                    continue;
                }
                list.addValuesBuilder().setStringValue(this.elementToString(element));
            }
            return com.google.protobuf.Value.newBuilder().setListValue(list).build();
        }

        @Override
        @Nonnull
        public ImmutableList<String> getAsStringList() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object element : (List)this.value) {
                builder.add((Object)(element == null ? Value.NULL_STRING : this.elementToString(element)));
            }
            return builder.build();
        }

        String elementToString(T element) {
            return element.toString();
        }

        abstract void appendElement(StringBuilder var1, T var2);

        @Override
        void valueToString(StringBuilder b) {
            b.append('[');
            for (int i = 0; i < ((List)this.value).size(); ++i) {
                Object v;
                if (i > 0) {
                    b.append(',');
                }
                if ((v = ((List)this.value).get(i)) == null) {
                    b.append(Value.NULL_STRING);
                    continue;
                }
                this.appendElement(b, v);
            }
            b.append(']');
        }
    }

    private static class Float64ArrayImpl
    extends PrimitiveArrayImpl<Double> {
        private final double[] values;

        private Float64ArrayImpl(boolean isNull, BitSet nulls, double[] values) {
            super(isNull, Type.float64(), nulls);
            this.values = values;
        }

        @Override
        public List<Double> getFloat64Array() {
            return this.getArray();
        }

        @Override
        boolean valueEquals(Value v) {
            Float64ArrayImpl that = (Float64ArrayImpl)v;
            return Arrays.equals(this.values, that.values);
        }

        @Override
        int size() {
            return this.values.length;
        }

        @Override
        Double getValue(int i) {
            return this.values[i];
        }

        @Override
        com.google.protobuf.Value getValueAsProto(int i) {
            return com.google.protobuf.Value.newBuilder().setNumberValue(this.values[i]).build();
        }

        @Override
        int arrayHash() {
            return Arrays.hashCode(this.values);
        }
    }

    private static class Float32ArrayImpl
    extends PrimitiveArrayImpl<Float> {
        private final float[] values;

        private Float32ArrayImpl(boolean isNull, BitSet nulls, float[] values) {
            super(isNull, Type.float32(), nulls);
            this.values = values;
        }

        @Override
        public List<Float> getFloat32Array() {
            return this.getArray();
        }

        @Override
        boolean valueEquals(Value v) {
            Float32ArrayImpl that = (Float32ArrayImpl)v;
            return Arrays.equals(this.values, that.values);
        }

        @Override
        int size() {
            return this.values.length;
        }

        @Override
        Float getValue(int i) {
            return Float.valueOf(this.values[i]);
        }

        @Override
        com.google.protobuf.Value getValueAsProto(int i) {
            return com.google.protobuf.Value.newBuilder().setNumberValue((double)this.values[i]).build();
        }

        @Override
        int arrayHash() {
            return Arrays.hashCode(this.values);
        }
    }

    private static class Int64ArrayImpl
    extends PrimitiveArrayImpl<Long> {
        private final long[] values;

        private Int64ArrayImpl(boolean isNull, BitSet nulls, long[] values) {
            super(isNull, Type.int64(), nulls);
            this.values = values;
        }

        @Override
        public List<Long> getInt64Array() {
            return this.getArray();
        }

        @Override
        public <T extends ProtocolMessageEnum> List<T> getProtoEnumArray(Function<Integer, ProtocolMessageEnum> method) {
            Preconditions.checkNotNull(method, (Object)"Method may not be null. Use 'MyProtoEnum::forNumber' as a parameter value.");
            this.checkNotNull();
            ArrayList<ProtocolMessageEnum> protoEnumList = new ArrayList<ProtocolMessageEnum>();
            long[] lArray = this.values;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long enumIntValue = lArray[i];
                if (enumIntValue == null) {
                    protoEnumList.add(null);
                    continue;
                }
                protoEnumList.add(method.apply(enumIntValue.intValue()));
            }
            return protoEnumList;
        }

        @Override
        boolean valueEquals(Value v) {
            Int64ArrayImpl that = (Int64ArrayImpl)v;
            return Arrays.equals(this.values, that.values);
        }

        @Override
        int size() {
            return this.values.length;
        }

        @Override
        Long getValue(int i) {
            return this.values[i];
        }

        @Override
        com.google.protobuf.Value getValueAsProto(int i) {
            return com.google.protobuf.Value.newBuilder().setStringValue(Long.toString(this.values[i])).build();
        }

        @Override
        int arrayHash() {
            return Arrays.hashCode(this.values);
        }
    }

    private static class BoolArrayImpl
    extends PrimitiveArrayImpl<Boolean> {
        private final boolean[] values;

        private BoolArrayImpl(boolean isNull, BitSet nulls, boolean[] values) {
            super(isNull, Type.bool(), nulls);
            this.values = values;
        }

        @Override
        public List<Boolean> getBoolArray() {
            return this.getArray();
        }

        @Override
        boolean valueEquals(Value v) {
            BoolArrayImpl that = (BoolArrayImpl)v;
            return Arrays.equals(this.values, that.values);
        }

        @Override
        int size() {
            return this.values.length;
        }

        @Override
        Boolean getValue(int i) {
            return this.values[i];
        }

        @Override
        com.google.protobuf.Value getValueAsProto(int i) {
            return com.google.protobuf.Value.newBuilder().setBoolValue(this.values[i]).build();
        }

        @Override
        int arrayHash() {
            return Arrays.hashCode(this.values);
        }
    }

    private static abstract class PrimitiveArrayImpl<T>
    extends AbstractValue {
        private final BitSet nulls;

        private PrimitiveArrayImpl(boolean isNull, Type elementType, BitSet nulls) {
            super(isNull, Type.array(elementType));
            this.nulls = nulls;
        }

        boolean isElementNull(int i) {
            return this.nulls != null && this.nulls.get(i);
        }

        List<T> getArray() {
            this.checkNotNull();
            ArrayList<Object> r = new ArrayList<Object>(this.size());
            for (int i = 0; i < this.size(); ++i) {
                r.add(this.isElementNull(i) ? null : (Object)this.getValue(i));
            }
            return r;
        }

        abstract int size();

        abstract T getValue(int var1);

        abstract com.google.protobuf.Value getValueAsProto(int var1);

        @Override
        @Nonnull
        public ImmutableList<String> getAsStringList() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < this.size(); ++i) {
                builder.add((Object)(this.isElementNull(i) ? Value.NULL_STRING : String.valueOf(this.getValue(i))));
            }
            return builder.build();
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append('[');
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    b.append(',');
                }
                if (this.nulls != null && this.nulls.get(i)) {
                    b.append(Value.NULL_STRING);
                    continue;
                }
                b.append(this.getValue(i));
            }
            b.append(']');
        }

        @Override
        int valueHash() {
            return 31 * Objects.hashCode(this.nulls) + this.arrayHash();
        }

        abstract int arrayHash();

        @Override
        com.google.protobuf.Value valueToProto() {
            ListValue.Builder list = ListValue.newBuilder();
            for (int i = 0; i < this.size(); ++i) {
                if (this.isElementNull(i)) {
                    list.addValues(NULL_PROTO);
                    continue;
                }
                list.addValues(this.getValueAsProto(i));
            }
            return com.google.protobuf.Value.newBuilder().setListValue(list).build();
        }
    }

    static abstract class AbstractObjectValue<T>
    extends AbstractValue {
        final T value;

        private AbstractObjectValue(boolean isNull, Type type, T value) {
            super(isNull, type);
            this.value = value;
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            return com.google.protobuf.Value.newBuilder().setStringValue(this.value.toString()).build();
        }

        @Override
        boolean valueEquals(Value v) {
            return ((AbstractObjectValue)v).value.equals(this.value);
        }

        @Override
        int valueHash() {
            return this.value.hashCode();
        }
    }

    private static abstract class AbstractValue
    extends Value {
        private final boolean isNull;
        private final Type type;

        private AbstractValue(boolean isNull, Type type) {
            this.isNull = isNull;
            this.type = type;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public final boolean isNull() {
            return this.isNull;
        }

        @Override
        public boolean isCommitTimestamp() {
            return false;
        }

        @Override
        public boolean getBool() {
            throw this.defaultGetter(Type.bool());
        }

        @Override
        public long getInt64() {
            throw this.defaultGetter(Type.int64());
        }

        @Override
        public float getFloat32() {
            throw this.defaultGetter(Type.float32());
        }

        @Override
        public double getFloat64() {
            throw this.defaultGetter(Type.float64());
        }

        @Override
        public BigDecimal getNumeric() {
            throw this.defaultGetter(Type.numeric());
        }

        @Override
        public String getString() {
            throw this.defaultGetter(Type.string());
        }

        @Override
        public String getJson() {
            throw this.defaultGetter(Type.json());
        }

        @Override
        public String getPgJsonb() {
            throw this.defaultGetter(Type.pgJsonb());
        }

        @Override
        public ByteArray getBytes() {
            throw this.defaultGetter(Type.bytes());
        }

        @Override
        public Timestamp getTimestamp() {
            throw this.defaultGetter(Type.timestamp());
        }

        @Override
        public Date getDate() {
            throw this.defaultGetter(Type.date());
        }

        @Override
        public Struct getStruct() {
            if (this.getType().getCode() != Type.Code.STRUCT) {
                throw new IllegalStateException("Illegal call to getter of incorrect type. Expected: STRUCT<...> actual: " + this.getType());
            }
            throw new AssertionError((Object)"Should have been overridden");
        }

        @Override
        public List<Boolean> getBoolArray() {
            throw this.defaultGetter(Type.array(Type.bool()));
        }

        @Override
        public List<Long> getInt64Array() {
            throw this.defaultGetter(Type.array(Type.int64()));
        }

        @Override
        public List<Float> getFloat32Array() {
            throw this.defaultGetter(Type.array(Type.float32()));
        }

        @Override
        public List<Double> getFloat64Array() {
            throw this.defaultGetter(Type.array(Type.float64()));
        }

        @Override
        public List<BigDecimal> getNumericArray() {
            throw this.defaultGetter(Type.array(Type.numeric()));
        }

        @Override
        public List<String> getStringArray() {
            throw this.defaultGetter(Type.array(Type.string()));
        }

        @Override
        public List<String> getJsonArray() {
            throw this.defaultGetter(Type.array(Type.json()));
        }

        @Override
        public List<String> getPgJsonbArray() {
            throw this.defaultGetter(Type.array(Type.pgJsonb()));
        }

        @Override
        public List<ByteArray> getBytesArray() {
            throw this.defaultGetter(Type.array(Type.bytes()));
        }

        @Override
        public List<Timestamp> getTimestampArray() {
            throw this.defaultGetter(Type.array(Type.timestamp()));
        }

        @Override
        public List<Date> getDateArray() {
            throw this.defaultGetter(Type.array(Type.date()));
        }

        @Override
        public List<Struct> getStructArray() {
            if (this.getType().getCode() != Type.Code.ARRAY || this.getType().getArrayElementType().getCode() != Type.Code.STRUCT) {
                throw new IllegalStateException("Illegal call to getter of incorrect type.  Expected: ARRAY<STRUCT<...>> actual: " + this.getType());
            }
            throw new AssertionError((Object)"Should have been overridden");
        }

        @Override
        final void toString(StringBuilder b) {
            if (this.isNull()) {
                b.append(Value.NULL_STRING);
            } else {
                this.valueToString(b);
            }
        }

        abstract void valueToString(StringBuilder var1);

        @Override
        final com.google.protobuf.Value toProto() {
            return this.isNull() ? NULL_PROTO : this.valueToProto();
        }

        abstract com.google.protobuf.Value valueToProto();

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractValue that = (AbstractValue)o;
            if (!Objects.equals(this.getType(), that.getType()) || this.isNull != that.isNull) {
                return false;
            }
            return this.isNull || this.valueEquals(that);
        }

        abstract boolean valueEquals(Value var1);

        public final int hashCode() {
            int valueHash;
            Type typeToHash = this.getType();
            int n = valueHash = this.isNull ? 0 : this.valueHash();
            if (this.type.getCode() == Type.Code.FLOAT32 && !this.isNull && Float.isNaN(this.getFloat32())) {
                typeToHash = Type.float64();
            }
            int result = Objects.hash(typeToHash, this.isNull);
            if (!this.isNull) {
                result = 31 * result + valueHash;
            }
            return result;
        }

        abstract int valueHash();

        private AssertionError defaultGetter(Type expectedType) {
            this.checkType(expectedType);
            throw new AssertionError((Object)"Should have been overridden");
        }

        final void checkType(Type expected) {
            if (!this.getType().equals(expected)) {
                throw new IllegalStateException("Illegal call to getter of incorrect type.  Expected: " + expected + " actual: " + this.getType());
            }
        }

        final void checkNotNull() {
            Preconditions.checkState((!this.isNull() ? 1 : 0) != 0, (Object)"Illegal call to getter of null value.");
        }
    }
}

