/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformMetaDataCombi;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.validator.HopValidatorException;
import org.apache.hop.pipeline.transforms.validator.Validation;
import org.apache.hop.pipeline.transforms.validator.ValidatorData;
import org.apache.hop.pipeline.transforms.validator.ValidatorMeta;

public class Validator
extends BaseTransform<ValidatorMeta, ValidatorData>
implements ITransform {
    private static final Class<?> PKG = ValidatorMeta.class;

    public Validator(TransformMeta transformMeta, ValidatorMeta meta, ValidatorData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processRow() throws HopException {
        Object[] r;
        block18: {
            Iterator<HopValidatorException> iterator;
            boolean notFirst;
            StringBuilder codes;
            StringBuilder fields;
            StringBuilder messages;
            List<HopValidatorException> exceptions;
            block17: {
                if (this.first) {
                    this.first = false;
                    this.readSourceValuesFromInfoTransforms();
                    r = this.getRow();
                    if (r == null) {
                        this.setOutputDone();
                        return false;
                    }
                    this.calculateFieldIndexes();
                } else {
                    r = this.getRow();
                    if (r == null) {
                        this.setOutputDone();
                        return false;
                    }
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel("Read row #" + this.getLinesRead() + " : " + this.getInputRowMeta().getString(r));
                }
                try {
                    exceptions = this.validateFields(this.getInputRowMeta(), r);
                    if (!exceptions.isEmpty()) {
                        if (!this.getTransformMeta().isDoingErrorHandling()) {
                            HopValidatorException e = exceptions.get(0);
                            throw new HopException(e.getMessage(), (Throwable)((Object)e));
                        }
                        if (((ValidatorMeta)this.meta).isConcatenatingErrors()) {
                            messages = new StringBuilder();
                            fields = new StringBuilder();
                            codes = new StringBuilder();
                            notFirst = false;
                            iterator = exceptions.iterator();
                            break block17;
                        }
                        for (HopValidatorException e : exceptions) {
                            this.putError(((ValidatorData)this.data).inputRowMeta, r, 1L, e.getMessage(), e.getFieldName(), e.getCodeDesc());
                        }
                        break block18;
                    }
                    this.putRow(this.getInputRowMeta(), r);
                }
                catch (HopValidatorException e) {
                    if (!this.getTransformMeta().isDoingErrorHandling()) {
                        throw new HopException(e.getMessage(), (Throwable)((Object)e));
                    }
                    this.putError(((ValidatorData)this.data).inputRowMeta, r, 1L, e.getMessage(), e.getFieldName(), e.getCodeDesc());
                }
                break block18;
            }
            while (iterator.hasNext()) {
                HopValidatorException e = iterator.next();
                if (notFirst) {
                    messages.append(((ValidatorMeta)this.meta).getConcatenationSeparator());
                    fields.append(((ValidatorMeta)this.meta).getConcatenationSeparator());
                    codes.append(((ValidatorMeta)this.meta).getConcatenationSeparator());
                } else {
                    notFirst = true;
                }
                messages.append(e.getMessage());
                fields.append(e.getFieldName());
                codes.append(e.getCodeDesc());
            }
            this.putError(((ValidatorData)this.data).inputRowMeta, r, exceptions.size(), messages.toString(), fields.toString(), codes.toString());
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel("Wrote row #" + this.getLinesWritten() + " : " + this.getInputRowMeta().getString(r));
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    private void calculateFieldIndexes() throws HopTransformException {
        ((ValidatorData)this.data).fieldIndexes = new int[((ValidatorMeta)this.meta).getValidations().size()];
        for (int i = 0; i < ((ValidatorMeta)this.meta).getValidations().size(); ++i) {
            Validation field = ((ValidatorMeta)this.meta).getValidations().get(i);
            if (StringUtils.isNotEmpty((String)field.getFieldName())) {
                ((ValidatorData)this.data).fieldIndexes[i] = this.getInputRowMeta().indexOfValue(field.getFieldName());
                if (((ValidatorData)this.data).fieldIndexes[i] >= 0) continue;
                throw new HopTransformException("Unable to find the specified field name '" + field.getFieldName() + "' for validation number " + (i + 1));
            }
            throw new HopTransformException("There is no name specified for validator field #" + (i + 1));
        }
    }

    private void readSourceValuesFromInfoTransforms() throws HopTransformException {
        ((ValidatorData)this.data).inputRowMeta = this.getPipelineMeta().getTransformFields(this.variables, this.getTransformName());
        HashMap<String, Integer> inputTransformWasProcessed = new HashMap<String, Integer>();
        for (int i = 0; i < ((ValidatorMeta)this.meta).getValidations().size(); ++i) {
            Validation field = ((ValidatorMeta)this.meta).getValidations().get(i);
            List streams = ((ValidatorMeta)this.meta).getTransformIOMeta().getInfoStreams();
            if (!field.isSourcingValues()) continue;
            if (((IStream)streams.get(i)).getTransformMeta() == null) {
                throw new HopTransformException("There is no valid source transform specified for the allowed values of validation [" + field.getName() + "]");
            }
            if (StringUtils.isEmpty((String)field.getSourcingField())) {
                throw new HopTransformException("There is no valid source field specified for the allowed values of validation [" + field.getName() + "]");
            }
            String transformName = ((IStream)streams.get(i)).getTransformName();
            if (inputTransformWasProcessed.containsKey(transformName)) {
                ((ValidatorData)this.data).listValues[i] = ((ValidatorData)this.data).listValues[(Integer)inputTransformWasProcessed.get(transformName)];
                ((ValidatorData)this.data).constantsMeta[i] = ((ValidatorData)this.data).constantsMeta[(Integer)inputTransformWasProcessed.get(transformName)];
                continue;
            }
            IRowSet allowedRowSet = this.findInputRowSet(transformName);
            int fieldIndex = -1;
            ArrayList<Object> allowedValues = new ArrayList<Object>();
            Object[] allowedRowData = this.getRowFrom(allowedRowSet);
            while (allowedRowData != null) {
                Object allowedValue;
                IRowMeta allowedRowMeta = allowedRowSet.getRowMeta();
                if (fieldIndex < 0) {
                    fieldIndex = allowedRowMeta.indexOfValue(field.getSourcingField());
                    if (fieldIndex < 0) {
                        throw new HopTransformException("Source field [" + field.getSourcingField() + "] is not found in the source row data");
                    }
                    ((ValidatorData)this.data).constantsMeta[i] = allowedRowMeta.getValueMeta(fieldIndex);
                }
                if ((allowedValue = allowedRowData[fieldIndex]) != null) {
                    allowedValues.add(allowedValue);
                }
                allowedRowData = this.getRowFrom(allowedRowSet);
            }
            ((ValidatorData)this.data).listValues[i] = allowedValues.toArray(new Object[0]);
            inputTransformWasProcessed.put(transformName, i);
        }
    }

    private List<HopValidatorException> validateFields(IRowMeta inputRowMeta, Object[] r) throws HopValueException {
        ArrayList<HopValidatorException> exceptions = new ArrayList<HopValidatorException>();
        for (int i = 0; i < ((ValidatorMeta)this.meta).getValidations().size(); ++i) {
            Matcher matcher;
            HopValidatorException exception;
            HopValidatorException exception2;
            HopValidatorException exception3;
            HopValidatorException exception4;
            Validation field = ((ValidatorMeta)this.meta).getValidations().get(i);
            int valueIndex = ((ValidatorData)this.data).fieldIndexes[i];
            IValueMeta validatorMeta = ((ValidatorData)this.data).constantsMeta[i];
            IValueMeta valueMeta = inputRowMeta.getValueMeta(valueIndex);
            Object valueData = r[valueIndex];
            boolean isNull = valueMeta.isNull(valueData);
            if (!field.isNullAllowed() && isNull) {
                exception4 = new HopValidatorException(this, field, 1, BaseMessages.getString(PKG, (String)"Validator.Exception.NullNotAllowed", (String[])new String[]{field.getFieldName(), inputRowMeta.getString(r)}), field.getFieldName());
                exceptions.add(exception4);
                if (!((ValidatorMeta)this.meta).isValidatingAll()) {
                    return exceptions;
                }
            }
            if (field.isOnlyNullAllowed() && !isNull) {
                exception4 = new HopValidatorException(this, field, 15, BaseMessages.getString(PKG, (String)"Validator.Exception.OnlyNullAllowed", (String[])new String[]{field.getFieldName(), inputRowMeta.getString(r)}), field.getFieldName());
                exceptions.add(exception4);
                if (!((ValidatorMeta)this.meta).isValidatingAll()) {
                    return exceptions;
                }
            }
            int dataType = ValueMetaFactory.getIdForValueMeta((String)field.getDataType());
            if (field.isDataTypeVerified() && dataType != 0 && dataType != valueMeta.getType()) {
                HopValidatorException exception5 = new HopValidatorException(this, field, 4, BaseMessages.getString(PKG, (String)"Validator.Exception.UnexpectedDataType", (String[])new String[]{field.getFieldName(), valueMeta.toStringMeta(), validatorMeta.toStringMeta()}), field.getFieldName());
                exceptions.add(exception5);
                if (!((ValidatorMeta)this.meta).isValidatingAll()) {
                    return exceptions;
                }
            }
            if (isNull || ((ValidatorData)this.data).fieldsMinimumLengthAsInt[i] < 0 && ((ValidatorData)this.data).fieldsMaximumLengthAsInt[i] < 0 && ((ValidatorData)this.data).minimumValue[i] == null && ((ValidatorData)this.data).maximumValue[i] == null && ((ValidatorData)this.data).listValues[i].length <= 0 && !field.isSourcingValues() && !StringUtils.isNotEmpty((String)((ValidatorData)this.data).startString[i]) && !StringUtils.isNotEmpty((String)((ValidatorData)this.data).endString[i]) && !StringUtils.isNotEmpty((String)((ValidatorData)this.data).startStringNotAllowed[i]) && !StringUtils.isNotEmpty((String)((ValidatorData)this.data).endStringNotAllowed[i]) && !field.isOnlyNumericAllowed() && ((ValidatorData)this.data).patternExpected[i] == null && ((ValidatorData)this.data).patternDisallowed[i] == null) continue;
            String stringValue = valueMeta.getString(valueData);
            int stringLength = stringValue.length();
            if (((ValidatorData)this.data).fieldsMinimumLengthAsInt[i] >= 0 && stringLength < ((ValidatorData)this.data).fieldsMinimumLengthAsInt[i]) {
                exception3 = new HopValidatorException(this, field, 3, BaseMessages.getString(PKG, (String)"Validator.Exception.ShorterThanMininumLength", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), Integer.toString(stringValue.length()), field.getMinimumLength()}), field.getFieldName());
                exceptions.add(exception3);
                if (!((ValidatorMeta)this.meta).isValidatingAll()) {
                    return exceptions;
                }
            }
            if (((ValidatorData)this.data).fieldsMaximumLengthAsInt[i] >= 0 && stringLength > ((ValidatorData)this.data).fieldsMaximumLengthAsInt[i]) {
                exception3 = new HopValidatorException(this, field, 2, BaseMessages.getString(PKG, (String)"Validator.Exception.LongerThanMaximumLength", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), Integer.toString(stringValue.length()), field.getMaximumLength()}), field.getFieldName());
                exceptions.add(exception3);
                if (!((ValidatorMeta)this.meta).isValidatingAll()) {
                    return exceptions;
                }
            }
            if (((ValidatorData)this.data).minimumValue[i] != null && valueMeta.compare(valueData, validatorMeta, ((ValidatorData)this.data).minimumValue[i]) < 0) {
                exception3 = new HopValidatorException(this, field, 5, BaseMessages.getString(PKG, (String)"Validator.Exception.LowerThanMinimumValue", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), ((ValidatorData)this.data).constantsMeta[i].getString(((ValidatorData)this.data).minimumValue[i])}), field.getFieldName());
                exceptions.add(exception3);
                if (!((ValidatorMeta)this.meta).isValidatingAll()) {
                    return exceptions;
                }
            }
            if (((ValidatorData)this.data).maximumValue[i] != null && valueMeta.compare(valueData, validatorMeta, ((ValidatorData)this.data).maximumValue[i]) > 0) {
                exception3 = new HopValidatorException(this, field, 6, BaseMessages.getString(PKG, (String)"Validator.Exception.HigherThanMaximumValue", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), ((ValidatorData)this.data).constantsMeta[i].getString(((ValidatorData)this.data).maximumValue[i])}), field.getFieldName());
                exceptions.add(exception3);
                if (!((ValidatorMeta)this.meta).isValidatingAll()) {
                    return exceptions;
                }
            }
            if (field.isSourcingValues() || ((ValidatorData)this.data).listValues[i].length > 0) {
                boolean found = false;
                for (Object object : ((ValidatorData)this.data).listValues[i]) {
                    if (object == null || ((ValidatorData)this.data).listValues[i] == null || valueMeta.compare(valueData, validatorMeta, object) != 0) continue;
                    found = true;
                }
                if (!found) {
                    exception2 = new HopValidatorException(this, field, 7, BaseMessages.getString(PKG, (String)"Validator.Exception.NotInList", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData)}), field.getFieldName());
                    exceptions.add(exception2);
                    if (!((ValidatorMeta)this.meta).isValidatingAll()) {
                        return exceptions;
                    }
                }
            }
            if (field.isOnlyNumericAllowed() && (exception = this.assertNumeric(valueMeta, valueData, field)) != null) {
                exceptions.add(exception);
                if (!((ValidatorMeta)this.meta).isValidatingAll()) {
                    return exceptions;
                }
            }
            if (StringUtils.isNotEmpty((String)((ValidatorData)this.data).startString[i]) && !stringValue.startsWith(((ValidatorData)this.data).startString[i])) {
                exception = new HopValidatorException(this, field, 9, BaseMessages.getString(PKG, (String)"Validator.Exception.DoesNotStartWithString", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), field.getStartString()}), field.getFieldName());
                exceptions.add(exception);
                if (!((ValidatorMeta)this.meta).isValidatingAll()) {
                    return exceptions;
                }
            }
            if (StringUtils.isNotEmpty((String)((ValidatorData)this.data).endString[i]) && !stringValue.endsWith(((ValidatorData)this.data).endString[i])) {
                exception = new HopValidatorException(this, field, 10, BaseMessages.getString(PKG, (String)"Validator.Exception.DoesNotEndWithString", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), field.getEndString()}), field.getFieldName());
                exceptions.add(exception);
                if (!((ValidatorMeta)this.meta).isValidatingAll()) {
                    return exceptions;
                }
            }
            if (StringUtils.isNotEmpty((String)((ValidatorData)this.data).startStringNotAllowed[i]) && stringValue.startsWith(((ValidatorData)this.data).startStringNotAllowed[i])) {
                exception = new HopValidatorException(this, field, 11, BaseMessages.getString(PKG, (String)"Validator.Exception.StartsWithString", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), field.getStartStringNotAllowed()}), field.getFieldName());
                exceptions.add(exception);
                if (!((ValidatorMeta)this.meta).isValidatingAll()) {
                    return exceptions;
                }
            }
            if (StringUtils.isNotEmpty((String)((ValidatorData)this.data).endStringNotAllowed[i]) && stringValue.endsWith(((ValidatorData)this.data).endStringNotAllowed[i])) {
                exception = new HopValidatorException(this, field, 12, BaseMessages.getString(PKG, (String)"Validator.Exception.EndsWithString", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), field.getEndStringNotAllowed()}), field.getFieldName());
                exceptions.add(exception);
                if (!((ValidatorMeta)this.meta).isValidatingAll()) {
                    return exceptions;
                }
            }
            if (((ValidatorData)this.data).patternExpected[i] != null && !(matcher = ((ValidatorData)this.data).patternExpected[i].matcher(stringValue)).matches()) {
                exception2 = new HopValidatorException(this, field, 13, BaseMessages.getString(PKG, (String)"Validator.Exception.MatchingRegExpExpected", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), ((ValidatorData)this.data).regularExpression[i]}), field.getFieldName());
                exceptions.add(exception2);
                if (!((ValidatorMeta)this.meta).isValidatingAll()) {
                    return exceptions;
                }
            }
            if (((ValidatorData)this.data).patternDisallowed[i] == null || !(matcher = ((ValidatorData)this.data).patternDisallowed[i].matcher(stringValue)).matches()) continue;
            exception2 = new HopValidatorException(this, field, 14, BaseMessages.getString(PKG, (String)"Validator.Exception.MatchingRegExpNotAllowed", (String[])new String[]{field.getFieldName(), valueMeta.getString(valueData), ((ValidatorData)this.data).regularExpressionNotAllowed[i]}), field.getFieldName());
            exceptions.add(exception2);
            if (((ValidatorMeta)this.meta).isValidatingAll()) continue;
            return exceptions;
        }
        return exceptions;
    }

    HopValidatorException assertNumeric(IValueMeta valueMeta, Object valueData, Validation field) throws HopValueException {
        if (valueMeta.isNumeric() || this.containsOnlyDigits(valueMeta.getString(valueData))) {
            return null;
        }
        return new HopValidatorException(this, field, 8, BaseMessages.getString(PKG, (String)"Validator.Exception.NonNumericDataNotAllowed", (String[])new String[]{field.getFieldName(), valueMeta.toStringMeta(), valueMeta.getString(valueData)}), field.getFieldName());
    }

    private boolean containsOnlyDigits(String string) {
        for (char c : string.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public boolean init() {
        if (!super.init()) {
            return false;
        }
        ArrayList<TransformMeta> transforms = new ArrayList<TransformMeta>();
        List pipelineTransforms = ((LocalPipelineEngine)this.getPipeline()).getTransforms();
        if (pipelineTransforms != null) {
            for (TransformMetaDataCombi s : pipelineTransforms) {
                transforms.add(s.transformMeta);
            }
        }
        ((ValidatorMeta)this.meta).searchInfoAndTargetTransforms(transforms);
        ((ValidatorData)this.data).constantsMeta = new IValueMeta[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).minimumValueAsString = new String[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).maximumValueAsString = new String[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).fieldsMinimumLengthAsInt = new int[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).fieldsMaximumLengthAsInt = new int[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).minimumValue = new Object[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).maximumValue = new Object[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).listValues = new Object[((ValidatorMeta)this.meta).getValidations().size()][];
        ((ValidatorData)this.data).errorCode = new String[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).errorDescription = new String[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).conversionMask = new String[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).decimalSymbol = new String[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).groupingSymbol = new String[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).maximumLength = new String[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).minimumLength = new String[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).startString = new String[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).endString = new String[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).startStringNotAllowed = new String[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).endStringNotAllowed = new String[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).regularExpression = new String[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).regularExpressionNotAllowed = new String[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).patternExpected = new Pattern[((ValidatorMeta)this.meta).getValidations().size()];
        ((ValidatorData)this.data).patternDisallowed = new Pattern[((ValidatorMeta)this.meta).getValidations().size()];
        for (int i = 0; i < ((ValidatorMeta)this.meta).getValidations().size(); ++i) {
            Validation field = ((ValidatorMeta)this.meta).getValidations().get(i);
            int dataType = ValueMetaFactory.getIdForValueMeta((String)field.getDataType());
            try {
                this.initBasics(i, field);
                IValueMeta stringMeta = this.cloneValueMeta(((ValidatorData)this.data).constantsMeta[i], 2);
                this.initMinMaxValues(i, stringMeta);
                this.initMinStringLength(i);
                this.initMaxStringLength(i);
                this.initListValues(i, field, stringMeta);
            }
            catch (HopException e) {
                if (dataType == 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"Validator.Exception.SpecifyDataType", (String[])new String[0]), e);
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"Validator.Exception.DataConversionErrorEncountered", (String[])new String[0]), e);
                }
                return false;
            }
            if (StringUtils.isNotEmpty((String)((ValidatorData)this.data).regularExpression[i])) {
                ((ValidatorData)this.data).patternExpected[i] = Pattern.compile(((ValidatorData)this.data).regularExpression[i]);
            }
            if (!StringUtils.isNotEmpty((String)((ValidatorData)this.data).regularExpressionNotAllowed[i])) continue;
            ((ValidatorData)this.data).patternDisallowed[i] = Pattern.compile(((ValidatorData)this.data).regularExpressionNotAllowed[i]);
        }
        return true;
    }

    private void initBasics(int i, Validation field) throws HopPluginException {
        ((ValidatorData)this.data).constantsMeta[i] = this.createValueMeta(field.getFieldName(), field.getDataType());
        ((ValidatorData)this.data).constantsMeta[i].setConversionMask(field.getConversionMask());
        ((ValidatorData)this.data).constantsMeta[i].setDecimalSymbol(field.getDecimalSymbol());
        ((ValidatorData)this.data).constantsMeta[i].setGroupingSymbol(field.getGroupingSymbol());
        ((ValidatorData)this.data).errorCode[i] = this.resolve(Const.NVL((String)field.getErrorCode(), (String)""));
        ((ValidatorData)this.data).errorDescription[i] = this.resolve(Const.NVL((String)field.getErrorDescription(), (String)""));
        ((ValidatorData)this.data).conversionMask[i] = this.resolve(Const.NVL((String)field.getConversionMask(), (String)""));
        ((ValidatorData)this.data).decimalSymbol[i] = this.resolve(Const.NVL((String)field.getDecimalSymbol(), (String)""));
        ((ValidatorData)this.data).groupingSymbol[i] = this.resolve(Const.NVL((String)field.getGroupingSymbol(), (String)""));
        ((ValidatorData)this.data).maximumLength[i] = this.resolve(Const.NVL((String)field.getMaximumLength(), (String)""));
        ((ValidatorData)this.data).minimumLength[i] = this.resolve(Const.NVL((String)field.getMinimumLength(), (String)""));
        ((ValidatorData)this.data).maximumValueAsString[i] = this.resolve(Const.NVL((String)field.getMaximumValue(), (String)""));
        ((ValidatorData)this.data).minimumValueAsString[i] = this.resolve(Const.NVL((String)field.getMinimumValue(), (String)""));
        ((ValidatorData)this.data).startString[i] = this.resolve(Const.NVL((String)field.getStartString(), (String)""));
        ((ValidatorData)this.data).endString[i] = this.resolve(Const.NVL((String)field.getEndString(), (String)""));
        ((ValidatorData)this.data).startStringNotAllowed[i] = this.resolve(Const.NVL((String)field.getStartStringNotAllowed(), (String)""));
        ((ValidatorData)this.data).endStringNotAllowed[i] = this.resolve(Const.NVL((String)field.getEndStringNotAllowed(), (String)""));
        ((ValidatorData)this.data).regularExpression[i] = this.resolve(Const.NVL((String)field.getRegularExpression(), (String)""));
        ((ValidatorData)this.data).regularExpressionNotAllowed[i] = this.resolve(Const.NVL((String)field.getRegularExpressionNotAllowed(), (String)""));
    }

    private void initMinMaxValues(int i, IValueMeta stringMeta) throws HopValueException {
        ((ValidatorData)this.data).minimumValue[i] = StringUtils.isEmpty((String)((ValidatorData)this.data).minimumValueAsString[i]) ? null : ((ValidatorData)this.data).constantsMeta[i].convertData(stringMeta, (Object)((ValidatorData)this.data).minimumValueAsString[i]);
        ((ValidatorData)this.data).maximumValue[i] = StringUtils.isEmpty((String)((ValidatorData)this.data).maximumValueAsString[i]) ? null : ((ValidatorData)this.data).constantsMeta[i].convertData(stringMeta, (Object)((ValidatorData)this.data).maximumValueAsString[i]);
    }

    private void initListValues(int i, Validation field, IValueMeta stringMeta) throws HopValueException {
        int listSize = field.getAllowedValues() != null ? field.getAllowedValues().size() : 0;
        ((ValidatorData)this.data).listValues[i] = new Object[listSize];
        for (int s = 0; s < listSize; ++s) {
            ((ValidatorData)this.data).listValues[i][s] = StringUtils.isEmpty((String)field.getAllowedValues().get(s)) ? null : ((ValidatorData)this.data).constantsMeta[i].convertData(stringMeta, (Object)this.resolve(field.getAllowedValues().get(s)));
        }
    }

    private void initMaxStringLength(int i) throws HopValueException {
        try {
            ((ValidatorData)this.data).fieldsMaximumLengthAsInt[i] = Integer.parseInt(Const.NVL((String)((ValidatorData)this.data).maximumLength[i], (String)"-1"));
        }
        catch (NumberFormatException nfe) {
            throw new HopValueException("Caught a number format exception converting minimum length with value " + ((ValidatorData)this.data).maximumLength[i] + " to an int.", (Throwable)nfe);
        }
    }

    private void initMinStringLength(int i) throws HopValueException {
        try {
            ((ValidatorData)this.data).fieldsMinimumLengthAsInt[i] = Integer.parseInt(Const.NVL((String)((ValidatorData)this.data).minimumLength[i], (String)"-1"));
        }
        catch (NumberFormatException nfe) {
            throw new HopValueException("Caught a number format exception converting minimum length with value " + ((ValidatorData)this.data).minimumLength[i] + " to an int.", (Throwable)nfe);
        }
    }

    protected IValueMeta createValueMeta(String name, String type) throws HopPluginException {
        int dataType = ValueMetaFactory.getIdForValueMeta((String)type);
        return ValueMetaFactory.createValueMeta((String)name, (int)dataType);
    }

    protected IValueMeta cloneValueMeta(IValueMeta valueMeta, int type) throws HopPluginException {
        return ValueMetaFactory.cloneValueMeta((IValueMeta)valueMeta, (int)type);
    }
}

