/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fuzzymatch;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.fuzzymatch.FuzzyMatchMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FuzzyMatchDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = FuzzyMatchMeta.class;
    private CCombo wTransform;
    private CCombo wAlgorithm;
    private ComboVar wMainStreamField;
    private ComboVar wLookupField;
    private ColumnInfo[] ciReturn;
    private Label wlReturn;
    private TableView wReturn;
    private TextVar wMatchField;
    private Label wlValueField;
    private TextVar wValueField;
    private Label wlCaseSensitive;
    private Button wCaseSensitive;
    private Label wlGetCloserValue;
    private Button wGetCloserValue;
    private Label wlMinValue;
    private TextVar wMinValue;
    private Label wlMaxValue;
    private TextVar wMaxValue;
    private Label wlSeparator;
    private TextVar wSeparator;
    private Button wGetLookup;
    private final FuzzyMatchMeta input;
    private boolean gotPreviousFields = false;
    private boolean gotLookupFields = false;

    public FuzzyMatchDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)((FuzzyMatchMeta)((Object)in)), pipelineMeta, sname);
        this.input = (FuzzyMatchMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.General.Tab", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wLookupGroup = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wLookupGroup);
        wLookupGroup.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Group.Lookup.Label", (String[])new String[0]));
        FormLayout lookupGroupLayout = new FormLayout();
        lookupGroupLayout.marginWidth = 10;
        lookupGroupLayout.marginHeight = 10;
        wLookupGroup.setLayout((Layout)lookupGroupLayout);
        Label wlTransform = new Label((Composite)wLookupGroup, 131072);
        wlTransform.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.SourceTransform.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTransform);
        FormData fdlTransform = new FormData();
        fdlTransform.left = new FormAttachment(0, 0);
        fdlTransform.right = new FormAttachment(middle, -margin);
        fdlTransform.top = new FormAttachment((Control)this.wTransformName, margin);
        wlTransform.setLayoutData((Object)fdlTransform);
        this.wTransform = new CCombo((Composite)wLookupGroup, 18436);
        PropsUi.setLook((Widget)this.wTransform);
        List transforms = this.pipelineMeta.findPreviousTransforms(this.pipelineMeta.findTransform(this.transformName), true);
        for (TransformMeta transformMeta : transforms) {
            this.wTransform.add(transformMeta.getName());
        }
        this.wTransform.addListener(13, e -> this.setComboBoxesLookup());
        FormData fdTransform = new FormData();
        fdTransform.left = new FormAttachment(middle, 0);
        fdTransform.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTransform.right = new FormAttachment(100, 0);
        this.wTransform.setLayoutData((Object)fdTransform);
        Label wlLookupField = new Label((Composite)wLookupGroup, 131072);
        wlLookupField.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.wlLookupField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLookupField);
        FormData fdlLookupField = new FormData();
        fdlLookupField.left = new FormAttachment(0, 0);
        fdlLookupField.top = new FormAttachment((Control)this.wTransform, margin);
        fdlLookupField.right = new FormAttachment(middle, -2 * margin);
        wlLookupField.setLayoutData((Object)fdlLookupField);
        this.wLookupField = new ComboVar(this.variables, (Composite)wLookupGroup, 2056);
        this.wLookupField.setEditable(true);
        PropsUi.setLook((Widget)this.wLookupField);
        FormData fdLookupField = new FormData();
        fdLookupField.left = new FormAttachment(middle, 0);
        fdLookupField.top = new FormAttachment((Control)this.wTransform, margin);
        fdLookupField.right = new FormAttachment(100, -margin);
        this.wLookupField.setLayoutData((Object)fdLookupField);
        this.wLookupField.addListener(15, e -> this.setLookupField());
        FormData fdLookupGroup = new FormData();
        fdLookupGroup.left = new FormAttachment(0, margin);
        fdLookupGroup.top = new FormAttachment((Control)this.wTransformName, margin);
        fdLookupGroup.right = new FormAttachment(100, -margin);
        wLookupGroup.setLayoutData((Object)fdLookupGroup);
        Group wMainStreamGroup = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wMainStreamGroup);
        wMainStreamGroup.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Group.MainStreamGroup.Label", (String[])new String[0]));
        FormLayout mainStreamGroupLayout = new FormLayout();
        mainStreamGroupLayout.marginWidth = 10;
        mainStreamGroupLayout.marginHeight = 10;
        wMainStreamGroup.setLayout((Layout)mainStreamGroupLayout);
        Label wlMainStreamField = new Label((Composite)wMainStreamGroup, 131072);
        wlMainStreamField.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.wlMainStreamField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMainStreamField);
        FormData fdlMainStreamField = new FormData();
        fdlMainStreamField.left = new FormAttachment(0, 0);
        fdlMainStreamField.top = new FormAttachment((Control)wLookupGroup, margin);
        fdlMainStreamField.right = new FormAttachment(middle, -2 * margin);
        wlMainStreamField.setLayoutData((Object)fdlMainStreamField);
        this.wMainStreamField = new ComboVar(this.variables, (Composite)wMainStreamGroup, 2056);
        this.wMainStreamField.setEditable(true);
        PropsUi.setLook((Widget)this.wMainStreamField);
        FormData fdMainStreamField = new FormData();
        fdMainStreamField.left = new FormAttachment(middle, 0);
        fdMainStreamField.top = new FormAttachment((Control)wLookupGroup, margin);
        fdMainStreamField.right = new FormAttachment(100, -margin);
        this.wMainStreamField.setLayoutData((Object)fdMainStreamField);
        this.wMainStreamField.addListener(15, e -> this.setMainStreamField());
        FormData fdMainStreamGroup = new FormData();
        fdMainStreamGroup.left = new FormAttachment(0, margin);
        fdMainStreamGroup.top = new FormAttachment((Control)wLookupGroup, margin);
        fdMainStreamGroup.right = new FormAttachment(100, -margin);
        wMainStreamGroup.setLayoutData((Object)fdMainStreamGroup);
        Group wSettingsGroup = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wSettingsGroup);
        wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Group.SettingsGroup.Label", (String[])new String[0]));
        FormLayout settingsGroupLayout = new FormLayout();
        settingsGroupLayout.marginWidth = 10;
        settingsGroupLayout.marginHeight = 10;
        wSettingsGroup.setLayout((Layout)settingsGroupLayout);
        Label wlAlgorithm = new Label((Composite)wSettingsGroup, 131072);
        wlAlgorithm.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Algorithm.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAlgorithm);
        FormData fdlAlgorithm = new FormData();
        fdlAlgorithm.left = new FormAttachment(0, 0);
        fdlAlgorithm.right = new FormAttachment(middle, -margin);
        fdlAlgorithm.top = new FormAttachment((Control)wMainStreamGroup, margin);
        wlAlgorithm.setLayoutData((Object)fdlAlgorithm);
        this.wAlgorithm = new CCombo((Composite)wSettingsGroup, 2056);
        PropsUi.setLook((Widget)this.wAlgorithm);
        FormData fdAlgorithm = new FormData();
        fdAlgorithm.left = new FormAttachment(middle, 0);
        fdAlgorithm.top = new FormAttachment((Control)wMainStreamGroup, margin);
        fdAlgorithm.right = new FormAttachment(100, -margin);
        this.wAlgorithm.setLayoutData((Object)fdAlgorithm);
        this.wAlgorithm.setItems(FuzzyMatchMeta.Algorithm.getDescriptions());
        this.wAlgorithm.addListener(13, e -> this.activeAlgorithm());
        this.wlCaseSensitive = new Label((Composite)wSettingsGroup, 131072);
        this.wlCaseSensitive.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.caseSensitive.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlCaseSensitive);
        FormData fdlCaseSensitive = new FormData();
        fdlCaseSensitive.left = new FormAttachment(0, 0);
        fdlCaseSensitive.top = new FormAttachment((Control)this.wAlgorithm, margin);
        fdlCaseSensitive.right = new FormAttachment(middle, -2 * margin);
        this.wlCaseSensitive.setLayoutData((Object)fdlCaseSensitive);
        this.wCaseSensitive = new Button((Composite)wSettingsGroup, 32);
        PropsUi.setLook((Widget)this.wCaseSensitive);
        this.wCaseSensitive.setToolTipText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.caseSensitive.Tooltip", (String[])new String[0]));
        FormData fdcaseSensitive = new FormData();
        fdcaseSensitive.left = new FormAttachment(middle, 0);
        fdcaseSensitive.top = new FormAttachment((Control)this.wlCaseSensitive, 0, 0x1000000);
        this.wCaseSensitive.setLayoutData((Object)fdcaseSensitive);
        this.wlGetCloserValue = new Label((Composite)wSettingsGroup, 131072);
        this.wlGetCloserValue.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.getCloserValue.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlGetCloserValue);
        FormData fdlGetCloserValue = new FormData();
        fdlGetCloserValue.left = new FormAttachment(0, 0);
        fdlGetCloserValue.top = new FormAttachment((Control)this.wCaseSensitive, margin);
        fdlGetCloserValue.right = new FormAttachment(middle, -2 * margin);
        this.wlGetCloserValue.setLayoutData((Object)fdlGetCloserValue);
        this.wGetCloserValue = new Button((Composite)wSettingsGroup, 32);
        PropsUi.setLook((Widget)this.wGetCloserValue);
        this.wGetCloserValue.setToolTipText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.getCloserValue.Tooltip", (String[])new String[0]));
        FormData fdgetCloserValue = new FormData();
        fdgetCloserValue.left = new FormAttachment(middle, 0);
        fdgetCloserValue.top = new FormAttachment((Control)this.wlGetCloserValue, 0, 0x1000000);
        this.wGetCloserValue.setLayoutData((Object)fdgetCloserValue);
        this.wGetCloserValue.addListener(13, e -> this.activeGetCloserValue());
        this.wlMinValue = new Label((Composite)wSettingsGroup, 131072);
        this.wlMinValue.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.minValue.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlMinValue);
        FormData fdlminValue = new FormData();
        fdlminValue.left = new FormAttachment(0, 0);
        fdlminValue.top = new FormAttachment((Control)this.wGetCloserValue, margin);
        fdlminValue.right = new FormAttachment(middle, -margin);
        this.wlMinValue.setLayoutData((Object)fdlminValue);
        this.wMinValue = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        PropsUi.setLook((Widget)this.wMinValue);
        this.wMinValue.setToolTipText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.minValue.Tooltip", (String[])new String[0]));
        FormData fdminValue = new FormData();
        fdminValue.left = new FormAttachment(middle, 0);
        fdminValue.top = new FormAttachment((Control)this.wGetCloserValue, margin);
        fdminValue.right = new FormAttachment(100, 0);
        this.wMinValue.setLayoutData((Object)fdminValue);
        this.wlMaxValue = new Label((Composite)wSettingsGroup, 131072);
        this.wlMaxValue.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.maxValue.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlMaxValue);
        FormData fdlmaxValue = new FormData();
        fdlmaxValue.left = new FormAttachment(0, 0);
        fdlmaxValue.top = new FormAttachment((Control)this.wMinValue, margin);
        fdlmaxValue.right = new FormAttachment(middle, -margin);
        this.wlMaxValue.setLayoutData((Object)fdlmaxValue);
        this.wMaxValue = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        PropsUi.setLook((Widget)this.wMaxValue);
        this.wMaxValue.setToolTipText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.maxValue.Tooltip", (String[])new String[0]));
        FormData fdmaxValue = new FormData();
        fdmaxValue.left = new FormAttachment(middle, 0);
        fdmaxValue.top = new FormAttachment((Control)this.wMinValue, margin);
        fdmaxValue.right = new FormAttachment(100, 0);
        this.wMaxValue.setLayoutData((Object)fdmaxValue);
        this.wlSeparator = new Label((Composite)wSettingsGroup, 131072);
        this.wlSeparator.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.separator.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSeparator);
        FormData fdlSeparator = new FormData();
        fdlSeparator.left = new FormAttachment(0, 0);
        fdlSeparator.top = new FormAttachment((Control)this.wMaxValue, margin);
        fdlSeparator.right = new FormAttachment(middle, -margin);
        this.wlSeparator.setLayoutData((Object)fdlSeparator);
        this.wSeparator = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        PropsUi.setLook((Widget)this.wSeparator);
        FormData fdSeparator = new FormData();
        fdSeparator.left = new FormAttachment(middle, 0);
        fdSeparator.top = new FormAttachment((Control)this.wMaxValue, margin);
        fdSeparator.right = new FormAttachment(100, 0);
        this.wSeparator.setLayoutData((Object)fdSeparator);
        FormData fdSettingsGroup = new FormData();
        fdSettingsGroup.left = new FormAttachment(0, margin);
        fdSettingsGroup.top = new FormAttachment((Control)wMainStreamGroup, margin);
        fdSettingsGroup.right = new FormAttachment(100, -margin);
        wSettingsGroup.setLayoutData((Object)fdSettingsGroup);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Fields.Tab", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 3;
        fieldsLayout.marginHeight = 3;
        wFieldsComp.setLayout((Layout)fieldsLayout);
        Group wOutputFieldsGroup = new Group(wFieldsComp, 32);
        PropsUi.setLook((Widget)wOutputFieldsGroup);
        wOutputFieldsGroup.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Group.OutputFieldsGroup.Label", (String[])new String[0]));
        FormLayout outputFieldsGroupLayout = new FormLayout();
        outputFieldsGroupLayout.marginWidth = 10;
        outputFieldsGroupLayout.marginHeight = 10;
        wOutputFieldsGroup.setLayout((Layout)outputFieldsGroupLayout);
        Label wlMatchField = new Label((Composite)wOutputFieldsGroup, 131072);
        wlMatchField.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.MatchField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMatchField);
        FormData fdlMatchField = new FormData();
        fdlMatchField.left = new FormAttachment(0, 0);
        fdlMatchField.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdlMatchField.right = new FormAttachment(middle, -margin);
        wlMatchField.setLayoutData((Object)fdlMatchField);
        this.wMatchField = new TextVar(this.variables, (Composite)wOutputFieldsGroup, 18436);
        PropsUi.setLook((Widget)this.wMatchField);
        FormData fdMatchField = new FormData();
        fdMatchField.left = new FormAttachment(middle, 0);
        fdMatchField.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdMatchField.right = new FormAttachment(100, 0);
        this.wMatchField.setLayoutData((Object)fdMatchField);
        this.wlValueField = new Label((Composite)wOutputFieldsGroup, 131072);
        this.wlValueField.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.valueField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlValueField);
        FormData fdlValueField = new FormData();
        fdlValueField.left = new FormAttachment(0, 0);
        fdlValueField.top = new FormAttachment((Control)this.wMatchField, margin);
        fdlValueField.right = new FormAttachment(middle, -margin);
        this.wlValueField.setLayoutData((Object)fdlValueField);
        this.wValueField = new TextVar(this.variables, (Composite)wOutputFieldsGroup, 18436);
        PropsUi.setLook((Widget)this.wValueField);
        this.wValueField.setToolTipText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.valueField.Tooltip", (String[])new String[0]));
        FormData fdValueField = new FormData();
        fdValueField.left = new FormAttachment(middle, 0);
        fdValueField.top = new FormAttachment((Control)this.wMatchField, margin);
        fdValueField.right = new FormAttachment(100, 0);
        this.wValueField.setLayoutData((Object)fdValueField);
        FormData fdOutputFieldsGroup = new FormData();
        fdOutputFieldsGroup.left = new FormAttachment(0, margin);
        fdOutputFieldsGroup.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdOutputFieldsGroup.right = new FormAttachment(100, -margin);
        wOutputFieldsGroup.setLayoutData((Object)fdOutputFieldsGroup);
        this.wlReturn = new Label(wFieldsComp, 0);
        this.wlReturn.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.ReturnFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlReturn);
        FormData fdlReturn = new FormData();
        fdlReturn.left = new FormAttachment(0, 0);
        fdlReturn.top = new FormAttachment((Control)wOutputFieldsGroup, margin);
        this.wlReturn.setLayoutData((Object)fdlReturn);
        this.wGetLookup = new Button(wFieldsComp, 8);
        this.wGetLookup.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.GetLookupFields.Button", (String[])new String[0]));
        FormData fdlGetLookup = new FormData();
        fdlGetLookup.top = new FormAttachment((Control)this.wlReturn, margin);
        fdlGetLookup.right = new FormAttachment(100, 0);
        this.wGetLookup.setLayoutData((Object)fdlGetLookup);
        this.wGetLookup.addListener(13, e -> this.getlookup());
        int upInsCols = 2;
        int upInsRows = this.input.getLookupValues().size();
        this.ciReturn = new ColumnInfo[upInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.ColumnInfo.FieldReturn", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.ColumnInfo.NewName", (String[])new String[0]), 1, false);
        this.wReturn = new TableView(this.variables, wFieldsComp, 68354, this.ciReturn, upInsRows, null, this.props);
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment((Control)this.wlReturn, margin);
        fdReturn.right = new FormAttachment((Control)this.wGetLookup, -margin);
        fdReturn.bottom = new FormAttachment(100, -3 * margin);
        this.wReturn.setLayoutData((Object)fdReturn);
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        wTabFolder.setSelection(0);
        this.getData();
        this.setComboBoxesLookup();
        this.activeAlgorithm();
        this.activeGetCloserValue();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getAlgorithm() != null) {
            this.wAlgorithm.setText(this.input.getAlgorithm().getDescription());
        }
        this.wMainStreamField.setText(Const.NVL((String)this.input.getMainStreamField(), (String)""));
        this.wLookupField.setText(Const.NVL((String)this.input.getLookupField(), (String)""));
        this.wCaseSensitive.setSelection(this.input.isCaseSensitive());
        this.wGetCloserValue.setSelection(this.input.isCloserValue());
        this.wMinValue.setText(Const.NVL((String)this.input.getMinimalValue(), (String)""));
        this.wMaxValue.setText(Const.NVL((String)this.input.getMaximalValue(), (String)""));
        this.wMatchField.setText(Const.NVL((String)this.input.getOutputMatchField(), (String)""));
        this.wValueField.setText(Const.NVL((String)this.input.getOutputValueField(), (String)""));
        this.wSeparator.setText(Const.NVL((String)this.input.getSeparator(), (String)""));
        for (int i = 0; i < this.input.getLookupValues().size(); ++i) {
            FuzzyMatchMeta.FMLookupValue lookupValue = this.input.getLookupValues().get(i);
            TableItem item = this.wReturn.table.getItem(i);
            item.setText(1, Const.NVL((String)lookupValue.getName(), (String)""));
            item.setText(2, Const.NVL((String)lookupValue.getRename(), (String)""));
        }
        IStream infoStream = (IStream)this.input.getTransformIOMeta().getInfoStreams().get(0);
        this.wTransform.setText(Const.NVL((String)infoStream.getTransformName(), (String)""));
        this.wReturn.optimizeTableView();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setMainStreamField(this.wMainStreamField.getText());
        this.input.setLookupTransformName(this.wTransform.getText());
        this.input.setLookupField(this.wLookupField.getText());
        this.input.setAlgorithm(FuzzyMatchMeta.Algorithm.lookupDescription(this.wAlgorithm.getText()));
        this.input.setCaseSensitive(this.wCaseSensitive.getSelection());
        this.input.setCloserValue(this.wGetCloserValue.getSelection());
        this.input.setMaximalValue(this.wMaxValue.getText());
        this.input.setMinimalValue(this.wMinValue.getText());
        this.input.setOutputMatchField(this.wMatchField.getText());
        this.input.setOutputValueField(this.wValueField.getText());
        this.input.setSeparator(this.wSeparator.getText());
        this.input.getLookupValues().clear();
        for (TableItem item : this.wReturn.getNonEmptyItems()) {
            FuzzyMatchMeta.FMLookupValue lookupValue = new FuzzyMatchMeta.FMLookupValue();
            lookupValue.setName(item.getText(1));
            lookupValue.setRename(item.getText(2));
            this.input.getLookupValues().add(lookupValue);
        }
        this.transformName = this.wTransformName.getText();
        this.input.setChanged();
        this.dispose();
    }

    private void setMainStreamField() {
        if (!this.gotPreviousFields) {
            String field = this.wMainStreamField.getText();
            try {
                this.wMainStreamField.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wMainStreamField.setItems(r.getFieldNames());
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            if (field != null) {
                this.wMainStreamField.setText(field);
            }
            this.gotPreviousFields = true;
        }
    }

    private void setLookupField() {
        if (!this.gotLookupFields) {
            String field = this.wLookupField.getText();
            try {
                this.wLookupField.removeAll();
                IRowMeta r = this.pipelineMeta.getTransformFields(this.variables, this.wTransform.getText());
                if (r != null) {
                    this.wLookupField.setItems(r.getFieldNames());
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetLookupFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetLookupFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            if (field != null) {
                this.wLookupField.setText(field);
            }
            this.gotLookupFields = true;
        }
    }

    private void activeGetCloserValue() {
        FuzzyMatchMeta.Algorithm algorithm = FuzzyMatchMeta.Algorithm.lookupDescription(this.wAlgorithm.getText());
        boolean enableRange = (algorithm == FuzzyMatchMeta.Algorithm.LEVENSHTEIN || algorithm == FuzzyMatchMeta.Algorithm.NEEDLEMAN_WUNSH || algorithm == FuzzyMatchMeta.Algorithm.DAMERAU_LEVENSHTEIN || algorithm == FuzzyMatchMeta.Algorithm.JARO || algorithm == FuzzyMatchMeta.Algorithm.JARO_WINKLER || algorithm == FuzzyMatchMeta.Algorithm.PAIR_SIMILARITY) && !this.wGetCloserValue.getSelection();
        this.wlSeparator.setEnabled(enableRange);
        this.wSeparator.setEnabled(enableRange);
        this.wlValueField.setEnabled(this.wGetCloserValue.getSelection());
        this.wValueField.setEnabled(this.wGetCloserValue.getSelection());
        this.activeAddFields();
    }

    private void activeAddFields() {
        FuzzyMatchMeta.Algorithm algorithm = FuzzyMatchMeta.Algorithm.lookupDescription(this.wAlgorithm.getText());
        boolean activate = this.wGetCloserValue.getSelection() || algorithm == FuzzyMatchMeta.Algorithm.DOUBLE_METAPHONE || algorithm == FuzzyMatchMeta.Algorithm.SOUNDEX || algorithm == FuzzyMatchMeta.Algorithm.REFINED_SOUNDEX || algorithm == FuzzyMatchMeta.Algorithm.METAPHONE;
        this.wlReturn.setEnabled(activate);
        this.wReturn.setEnabled(activate);
        this.wGetLookup.setEnabled(activate);
    }

    private void activeAlgorithm() {
        FuzzyMatchMeta.Algorithm algorithm = FuzzyMatchMeta.Algorithm.lookupDescription(this.wAlgorithm.getText());
        boolean enable = algorithm == FuzzyMatchMeta.Algorithm.LEVENSHTEIN || algorithm == FuzzyMatchMeta.Algorithm.NEEDLEMAN_WUNSH || algorithm == FuzzyMatchMeta.Algorithm.DAMERAU_LEVENSHTEIN || algorithm == FuzzyMatchMeta.Algorithm.JARO || algorithm == FuzzyMatchMeta.Algorithm.JARO_WINKLER || algorithm == FuzzyMatchMeta.Algorithm.PAIR_SIMILARITY;
        this.wlGetCloserValue.setEnabled(enable);
        this.wGetCloserValue.setEnabled(enable);
        this.wlMinValue.setEnabled(enable);
        this.wMinValue.setEnabled(enable);
        this.wlMaxValue.setEnabled(enable);
        this.wMaxValue.setEnabled(enable);
        if (algorithm == FuzzyMatchMeta.Algorithm.JARO || algorithm == FuzzyMatchMeta.Algorithm.JARO_WINKLER || algorithm == FuzzyMatchMeta.Algorithm.PAIR_SIMILARITY) {
            if (Const.toDouble((String)this.variables.resolve(this.wMinValue.getText()), (double)0.0) > 1.0) {
                this.wMinValue.setText(String.valueOf(1));
            }
            if (Const.toDouble((String)this.variables.resolve(this.wMaxValue.getText()), (double)0.0) > 1.0) {
                this.wMaxValue.setText(String.valueOf(1));
            }
        }
        boolean enableCaseSensitive = algorithm == FuzzyMatchMeta.Algorithm.LEVENSHTEIN || algorithm == FuzzyMatchMeta.Algorithm.DAMERAU_LEVENSHTEIN;
        this.wlCaseSensitive.setEnabled(enableCaseSensitive);
        this.wCaseSensitive.setEnabled(enableCaseSensitive);
        this.activeGetCloserValue();
    }

    private void getlookup() {
        try {
            String transformFrom = this.wTransform.getText();
            if (!Utils.isEmpty((CharSequence)transformFrom)) {
                IRowMeta r = this.pipelineMeta.getTransformFields(this.variables, transformFrom);
                if (r != null && !r.isEmpty()) {
                    BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1}, (int[])new int[]{4}, (int)-1, (int)-1, null);
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.CouldNotFindFields.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.CouldNotFindFields.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.TransformNameRequired.DialogMessage", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.TransformNameRequired.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    protected void setComboBoxesLookup() {
        Runnable fieldLoader = () -> {
            TransformMeta lookupTransformMeta = this.pipelineMeta.findTransform(this.wTransform.getText());
            if (lookupTransformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getTransformFields(this.variables, lookupTransformMeta);
                    ArrayList<String> lookupFields = new ArrayList<String>();
                    for (int i = 0; i < row.size(); ++i) {
                        lookupFields.add(row.getValueMeta(i).getName());
                    }
                    String[] fieldNames = ConstUi.sortFieldNames(lookupFields);
                    this.ciReturn[0].setComboValues(fieldNames);
                }
                catch (HopException e) {
                    this.logError("It was not possible to retrieve the list of fields for transform [" + this.wTransform.getText() + "]!");
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }
}

