/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.Iterator;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class Count {
    private Count() {
    }

    public static <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized Long> combineFn() {
        return new CountFn();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Long>> globally() {
        return Combine.globally(new CountFn());
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Long>>> perKey() {
        return Combine.perKey(new CountFn());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<T, @UnknownKeyFor @NonNull @Initialized Long>>> perElement() {
        return new PerElement();
    }

    private static class CountFn<@UnknownKeyFor T>
    extends Combine.CombineFn<T, long[], Long> {
        private CountFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] createAccumulator() {
            return new long[]{0L};
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] addInput(@UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] accumulator, T input) {
            accumulator[0] = accumulator[0] + 1L;
            return accumulator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized []> accumulators) {
            Iterator<long[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            long[] running = iter.next();
            while (iter.hasNext()) {
                running[0] = running[0] + iter.next()[0];
            }
            return running;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Long extractOutput(@UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] accumulator) {
            return accumulator[0];
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized []> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<T> inputCoder) {
            return new AtomicCoder<long[]>(){

                @Override
                public void encode(@UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
                    VarInt.encode(value[0], outStream);
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
                    try {
                        return new long[]{VarInt.decodeLong(inStream)};
                    }
                    catch (EOFException | UTFDataFormatException exn) {
                        throw new CoderException(exn);
                    }
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] value) {
                    return true;
                }

                @Override
                protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] value) {
                    return VarInt.getLength(value[0]);
                }
            };
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            return other != null && this.getClass().equals(other.getClass());
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getIncompatibleGlobalWindowErrorMessage() {
            return "If the input collection uses a windowing strategy other than GlobalWindows, use Combine.globally(Count.<T>combineFn()).withoutDefaults() instead.";
        }
    }

    private static class PerElement<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<KV<T, Long>>> {
        private PerElement() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<T, @UnknownKeyFor @NonNull @Initialized Long>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            return ((PCollection)input.apply("Init", MapElements.via(new SimpleFunction<T, KV<T, Void>>(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized KV<T, @UnknownKeyFor @Nullable @Initialized Void> apply(T element) {
                    return KV.of(element, null);
                }
            }))).apply(Count.perKey());
        }
    }
}

