/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SignonDialogAdapter;
import com.ibm.as400.access.ResourceBundleLoader;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;

class ChangePasswordDialog
extends Dialog {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private AS400SignonDialogAdapter listener_ = new AS400SignonDialogAdapter(this);
    private TextField systemNameTextField_;
    private TextField userIdTextField_;
    private TextField oldTextField_;
    private TextField newTextField_;
    private TextField confirmTextField_;
    private Button okButton_;
    private Button cancelButton_;
    private Label passwordLabel_;
    private Panel centeringPanel_;

    ChangePasswordDialog(Frame parent, String titleText) {
        super(parent, titleText, true);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(8, 8, 0, 8);
        this.setLayout(new GridBagLayout());
        this.setResizable(false);
        this.setBackground(Color.lightGray);
        Label label = new Label(ResourceBundleLoader.getCoreText("DLG_SYSTEM_LABEL"), 0);
        this.add(this, label, constraints, 0, 0, 1, 1);
        this.systemNameTextField_ = new TextField(10);
        this.systemNameTextField_.setEnabled(false);
        this.add(this, this.systemNameTextField_, constraints, 1, 0, 1, 1);
        label = new Label(ResourceBundleLoader.getCoreText("DLG_USER_ID_LABEL"), 0);
        this.add(this, label, constraints, 0, 1, 1, 1);
        this.userIdTextField_ = new TextField(10);
        this.userIdTextField_.setEnabled(false);
        this.add(this, this.userIdTextField_, constraints, 1, 1, 1, 1);
        this.passwordLabel_ = new Label(ResourceBundleLoader.getText("DLG_PASSWORDS_LABEL"), 1);
        this.add(this, this.passwordLabel_, constraints, 0, 2, 1, 1);
        label = new Label(ResourceBundleLoader.getText("DLG_OLD_LABEL"), 0);
        this.add(this, label, constraints, 0, 3, 1, 1);
        this.oldTextField_ = new TextField(10);
        this.oldTextField_.setEchoChar('*');
        this.oldTextField_.addFocusListener(this.listener_);
        this.oldTextField_.addKeyListener(this.listener_);
        this.add(this, this.oldTextField_, constraints, 1, 3, 1, 1);
        label = new Label(ResourceBundleLoader.getText("DLG_NEW_LABEL"), 0);
        this.add(this, label, constraints, 0, 4, 1, 1);
        this.newTextField_ = new TextField(10);
        this.newTextField_.setEchoChar('*');
        this.newTextField_.addFocusListener(this.listener_);
        this.newTextField_.addKeyListener(this.listener_);
        this.add(this, this.newTextField_, constraints, 1, 4, 1, 1);
        label = new Label(ResourceBundleLoader.getText("DLG_CONFIRM_LABEL"), 0);
        this.add(this, label, constraints, 0, 5, 1, 1);
        this.confirmTextField_ = new TextField(10);
        this.confirmTextField_.setEchoChar('*');
        this.confirmTextField_.addFocusListener(this.listener_);
        this.confirmTextField_.addKeyListener(this.listener_);
        this.add(this, this.confirmTextField_, constraints, 1, 5, 1, 1);
        this.centeringPanel_ = new Panel();
        this.centeringPanel_.setLayout(new FlowLayout(1));
        constraints.insets = new Insets(8, 8, 8, 8);
        this.add(this, this.centeringPanel_, constraints, 0, 6, 2, 1);
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new GridLayout(1, 2, 8, 0));
        this.centeringPanel_.add(buttonPanel);
        this.okButton_ = new Button(ResourceBundleLoader.getCoreText("DLG_OK_BUTTON"));
        this.okButton_.addActionListener(this.listener_);
        this.okButton_.addFocusListener(this.listener_);
        this.okButton_.addKeyListener(this.listener_);
        buttonPanel.add(this.okButton_);
        this.cancelButton_ = new Button(ResourceBundleLoader.getCoreText("DLG_CANCEL_BUTTON"));
        this.cancelButton_.addActionListener(this.listener_);
        this.cancelButton_.addFocusListener(this.listener_);
        this.cancelButton_.addKeyListener(this.listener_);
        buttonPanel.add(this.cancelButton_);
        this.pack();
        this.addWindowListener(this.listener_);
    }

    @Override
    public void paint(Graphics gc) {
        Rectangle pos = this.passwordLabel_.getBounds();
        int left = pos.x / 2;
        int top = pos.height / 2 + pos.y;
        int right = (this.getBounds().width + this.confirmTextField_.getBounds().x + this.confirmTextField_.getBounds().width) / 2;
        int bottom = (this.centeringPanel_.getBounds().y + this.confirmTextField_.getBounds().y + this.confirmTextField_.getBounds().height) / 2;
        gc.setColor(Color.white);
        gc.drawRect(left + 1, top + 1, right - left, bottom - top);
        gc.setColor(Color.black);
        gc.drawRect(left, top, right - left, bottom - top);
        super.paint(gc);
    }

    boolean prompt(String systemName, String userId) {
        this.systemNameTextField_.setText(systemName);
        this.userIdTextField_.setText(userId);
        this.oldTextField_.setText("");
        this.newTextField_.setText("");
        this.confirmTextField_.setText("");
        this.listener_.setFocalPoint(this.oldTextField_);
        this.show();
        return this.listener_.getFocalPoint() != this.cancelButton_;
    }

    String getOldPassword() {
        return this.oldTextField_.getText();
    }

    String getNewPassword() {
        return this.newTextField_.getText();
    }

    String getConfirmPassword() {
        return this.confirmTextField_.getText();
    }

    protected void add(Container container, Component component, GridBagConstraints constraints, int x, int y, int width, int height) {
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        LayoutManager layout = container.getLayout();
        if (layout != null && layout instanceof GridBagLayout) {
            ((GridBagLayout)layout).setConstraints(component, constraints);
        }
        container.add(component);
    }
}

