/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import com.ibm.as400.security.auth.SwapFailedException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class Swapper {
    private Swapper() {
    }

    public static void swap(AS400 system, ProfileTokenCredential newCredential) throws AS400SecurityException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (newCredential == null) {
            throw new NullPointerException("newCredential");
        }
        if (system.canUseNativeOptimizations()) {
            Trace.log(4, "When running natively, swaps should be performed via ProfileTokenCredential.swap() instead of Swapper.swap().");
        }
        Swapper.swapToToken(system, newCredential.getToken());
        newCredential.fireSwapped();
    }

    public static void swap(Connection connection, ProfileTokenCredential newCredential) throws AS400SecurityException, IOException, SQLException {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        if (newCredential == null) {
            throw new NullPointerException("newCredential");
        }
        Swapper.swapToToken(connection, newCredential.getToken());
        newCredential.fireSwapped();
    }

    public static void swapToToken(AS400 system, byte[] token) throws AS400SecurityException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (token == null) {
            throw new NullPointerException("token");
        }
        ProgramParameter[] parmList = new ProgramParameter[]{new ProgramParameter(token), new ErrorCodeParameter()};
        ProgramCall pgm = new ProgramCall(system, "/QSYS.LIB/QSYSETPT.PGM", parmList);
        pgm.suggestThreadsafe();
        try {
            if (!pgm.run()) {
                throw new SwapFailedException(pgm.getMessageList());
            }
            AS400Message[] msgs = pgm.getMessageList();
            if (msgs != null && msgs.length != 0) {
                System.out.println("Messages returned from QSYSETPT:");
                for (int i = 0; i < msgs.length; ++i) {
                    System.out.println(msgs[i].toString());
                }
            }
        }
        catch (AS400SecurityException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void swapToToken(Connection connection, byte[] token) throws AS400SecurityException, IOException, SQLException {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        if (token == null) {
            throw new NullPointerException("token");
        }
        StringBuffer sql = new StringBuffer(80);
        sql.append("CALL QSYS");
        sql.append(connection.getMetaData().getCatalogSeparator());
        sql.append("QSYSETPT (X'");
        for (int i = 0; i < token.length; ++i) {
            int unsignedByte = token[i];
            if (unsignedByte < 0) {
                unsignedByte = 256 + unsignedByte;
            } else if (unsignedByte < 16) {
                sql.append('0');
            }
            sql.append(Integer.toHexString(unsignedByte).toUpperCase());
        }
        sql.append("', X'0000')");
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.execute(sql.toString());
            SQLWarning warning = stmt.getWarnings();
            if (warning != null) {
                System.out.println("SQLWarning: " + warning.getErrorCode() + ": " + warning.getSQLState());
            }
        }
        finally {
            block16: {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {
                        if (!Trace.isTraceOn()) break block16;
                        Trace.log(2, "Error while closing statement", (Throwable)e);
                    }
                }
            }
        }
    }
}

