/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class HTMLMeta
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -7017914111994779942L;
    private String content_;
    private String name_;
    private String HttpEquiv_;
    private String url_;
    private String lang_;
    private String dir_;

    public HTMLMeta() {
    }

    public HTMLMeta(String HttpEquiv, String content) {
        this.setHttpEquiv(HttpEquiv);
        this.setContent(content);
    }

    public HTMLMeta(String HttpEquiv, String content, String url) {
        this.setHttpEquiv(HttpEquiv);
        this.setContent(content);
        this.setUrl(url);
    }

    public String getContent() {
        return this.content_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    public String getHttpEquiv() {
        return this.HttpEquiv_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    public String getName() {
        return this.name_;
    }

    public String getUrl() {
        return this.url_;
    }

    @Override
    public String getTag() {
        if (this.content_ == null) {
            Trace.log(2, "Attempting to get tag before setting meta content.");
            throw new ExtendedIllegalStateException("content", 4);
        }
        if (this.name_ == null && this.HttpEquiv_ == null) {
            Trace.log(2, "Attempting to get tag before setting name or http-equiv attributes.");
            throw new ExtendedIllegalStateException("name/HttpEquiv", 4);
        }
        StringBuffer s = new StringBuffer("<meta");
        if (this.HttpEquiv_ != null) {
            s.append(" http-equiv=\"");
            s.append(this.HttpEquiv_);
            s.append("\"");
        } else {
            s.append(" name=\"");
            s.append(this.name_);
            s.append("\"");
        }
        if (this.url_ != null) {
            s.append(" content=\"");
            s.append(this.content_);
            s.append("; URL=");
            s.append(this.url_);
            s.append("\"");
        } else {
            s.append(" content=\"");
            s.append(this.content_);
            s.append("\"");
        }
        s.append(this.getLanguageAttributeTag());
        s.append(this.getDirectionAttributeTag());
        s.append(this.getAttributeString());
        s.append(" />\n");
        return s.toString();
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLMeta was here -->";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setContent(String content) {
        if (content == null) {
            throw new NullPointerException("content");
        }
        String old = this.content_;
        this.content_ = content;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("content", old, content);
        }
    }

    public void setDirection(String dir) {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setHttpEquiv(String HttpEquiv) {
        if (HttpEquiv == null) {
            throw new NullPointerException("HttpEquiv");
        }
        String old = this.HttpEquiv_;
        this.HttpEquiv_ = HttpEquiv;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("HttpEquiv", old, HttpEquiv);
        }
    }

    public void setLanguage(String lang) {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String old = this.name_;
        this.name_ = name;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", old, name);
        }
    }

    public void setUrl(String url) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        String old = this.url_;
        this.url_ = url;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("url", old, url);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

