/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.awt.Color;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class HTMLText
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 8640694441108878894L;
    private String text_;
    private String alignment_;
    private Color color_;
    private int size_ = 0;
    private boolean bold_ = false;
    private boolean fixed_ = false;
    private boolean italic_ = false;
    private boolean underscore_ = false;
    private String lang_;
    private String dir_;
    private boolean useFO_;
    private transient VetoableChangeSupport vetos_;

    public HTMLText() {
    }

    public HTMLText(String text) {
        this();
        try {
            this.setText(text);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    public String getAlignment() {
        return this.alignment_;
    }

    public Color getColor() {
        return this.color_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    String getEndTextAlignmentTag() {
        if (this.alignment_ != null) {
            return "</div>";
        }
        return "";
    }

    String getEndTextFontTag() {
        if (this.size_ != 0 || this.color_ != null || this.getAttributeString().length() != 0) {
            return "</font>";
        }
        return "";
    }

    String getEndTextStyleTag() {
        StringBuffer tag = new StringBuffer();
        if (this.fixed_ && !this.useFO_) {
            tag.append("</tt>");
        }
        if (this.underscore_) {
            if (!this.useFO_) {
                tag.append("</u>");
            } else {
                tag.append("</fo:inline>\n");
            }
        }
        if (this.italic_ && !this.useFO_) {
            tag.append("</i>");
        }
        if (this.bold_ && !this.useFO_) {
            tag.append("</b>");
        }
        return tag.toString();
    }

    String getFontColorAttribute() {
        StringBuffer colorBuffer = new StringBuffer("");
        if (this.color_ != null) {
            colorBuffer.append(" color=\"#");
            String rgb = Integer.toHexString(this.color_.getRGB());
            colorBuffer.append(rgb.substring(2));
            colorBuffer.append("\"");
        }
        return new String(colorBuffer);
    }

    String getFontSizeAttribute() {
        StringBuffer tag = new StringBuffer("");
        if (this.size_ != 0) {
            if (!this.useFO_) {
                tag.append(" size=\"");
                tag.append(this.size_);
                tag.append("\"");
            } else {
                tag.append(" font-size='");
                tag.append(this.size_ * 3);
                tag.append("pt'");
            }
        }
        return tag.toString();
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    public int getSize() {
        return this.size_;
    }

    @Override
    public String getTag() {
        return this.getTag(this.text_, false);
    }

    @Override
    public String getFOTag() {
        return this.getFOTag(this.text_, false);
    }

    public String getTag(boolean useAlignment) {
        return this.getTag(this.text_, useAlignment);
    }

    public String getFOTag(boolean useAlignment) {
        return this.getFOTag(this.text_, useAlignment);
    }

    public String getTag(String text) {
        return this.getTag(text, false);
    }

    public String getFOTag(String text) {
        return this.getFOTag(text, false);
    }

    public String getTag(String text, boolean useAlignment) {
        if (this.useFO_) {
            return this.getFOTag(text, useAlignment);
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        StringBuffer tag = new StringBuffer();
        if (useAlignment) {
            tag.append(this.getTextAlignmentTag());
        }
        tag.append(this.getTextFontTag());
        if (this.lang_ != null || this.dir_ != null) {
            tag.append("\n<bdo");
            tag.append(this.getLanguageAttributeTag());
            tag.append(this.getDirectionAttributeTag());
            tag.append(">\n");
            tag.append(this.getTextStyleTag());
            tag.append(text);
            tag.append(this.getEndTextStyleTag());
            tag.append("\n</bdo>\n");
        } else {
            tag.append(this.getTextStyleTag());
            tag.append(text);
            tag.append(this.getEndTextStyleTag());
        }
        tag.append(this.getEndTextFontTag());
        if (useAlignment) {
            tag.append(this.getEndTextAlignmentTag());
        }
        return tag.toString();
    }

    public String getFOTag(String text, boolean useAlignment) {
        boolean useFO = this.useFO_;
        this.setUseFO(true);
        if (text == null) {
            throw new NullPointerException("text");
        }
        StringBuffer tag = new StringBuffer();
        if (this.dir_ != null) {
            tag.append("<fo:block-container");
            tag.append(this.getDirectionAttributeTag());
            tag.append(">\n");
        }
        tag.append("<fo:block");
        if (useAlignment) {
            tag.append(this.getTextAlignmentTag());
        }
        tag.append(this.getTextFontTag());
        tag.append(this.getTextStyleTag());
        tag.append(">");
        tag.append(text);
        tag.append(this.getEndTextStyleTag());
        tag.append("</fo:block>\n");
        if (this.dir_ != null) {
            tag.append("</fo:block-container>\n");
        }
        this.setUseFO(useFO);
        return tag.toString();
    }

    public String getText() {
        return this.text_;
    }

    String getTextAlignmentTag() {
        if (!this.useFO_) {
            if (this.alignment_ != null) {
                StringBuffer tag = new StringBuffer();
                tag.append("<div align=\"");
                tag.append(this.alignment_);
                tag.append("\">");
                return tag.toString();
            }
            return "";
        }
        if (this.alignment_ != null) {
            StringBuffer tag = new StringBuffer();
            tag.append(" text-align='");
            if (this.alignment_.equals("center")) {
                tag.append("center'");
            } else if (this.alignment_.equals("right")) {
                tag.append("end'");
            } else if (this.alignment_.equals("left")) {
                tag.append("start'");
            } else if (this.alignment_.equals("justify")) {
                tag.append("justify'");
            }
            return tag.toString();
        }
        return "";
    }

    String getTextFontTag() {
        StringBuffer tag = new StringBuffer("");
        String extraAttributes = this.getAttributeString();
        if (this.size_ != 0 || this.color_ != null || extraAttributes.length() != 0) {
            if (!this.useFO_) {
                tag.append("<font");
                tag.append(this.getFontSizeAttribute());
                tag.append(this.getFontColorAttribute());
                tag.append(extraAttributes);
                tag.append(">");
            } else {
                tag.append(this.getFontSizeAttribute());
                tag.append(this.getFontColorAttribute());
            }
        }
        return tag.toString();
    }

    String getTextStyleTag() {
        StringBuffer tag = new StringBuffer();
        if (this.bold_) {
            if (!this.useFO_) {
                tag.append("<b>");
            } else {
                tag.append(" font-weight='bold'");
            }
        }
        if (this.italic_) {
            if (!this.useFO_) {
                tag.append("<i>");
            } else {
                tag.append(" font-style='italic'");
            }
        }
        if (this.underscore_) {
            if (!this.useFO_) {
                tag.append("<u>");
            } else {
                tag.append(">\n<fo:inline text-decoration='underline'");
            }
        }
        if (this.fixed_ && !this.useFO_) {
            tag.append("<tt>");
        }
        return tag.toString();
    }

    public boolean isBold() {
        return this.bold_;
    }

    public boolean isFixed() {
        return this.fixed_;
    }

    public boolean isItalic() {
        return this.italic_;
    }

    public boolean isUnderscore() {
        return this.underscore_;
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setAlignment(String alignment) throws PropertyVetoException {
        if (alignment == null) {
            throw new NullPointerException("alignment");
        }
        if (alignment.equalsIgnoreCase("left") || alignment.equalsIgnoreCase("center") || alignment.equalsIgnoreCase("right") || alignment.equalsIgnoreCase("justify")) {
            String old = this.alignment_;
            if (this.vetos_ != null) {
                this.vetos_.fireVetoableChange("alignment", old, alignment);
            }
            this.alignment_ = alignment;
            if (this.changes_ != null) {
                this.changes_.firePropertyChange("alignment", old, alignment);
            }
        } else {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
    }

    public void setBold(boolean bold) throws PropertyVetoException {
        boolean oldBold = this.bold_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("bold", (Object)oldBold, (Object)bold);
        }
        this.bold_ = bold;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("bold", (Object)oldBold, (Object)bold);
        }
    }

    public void setColor(Color color) throws PropertyVetoException {
        Color oldColor = this.color_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("color", oldColor, color);
        }
        this.color_ = color;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("color", oldColor, color);
        }
    }

    public void setDirection(String dir) throws PropertyVetoException {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", old, dir);
        }
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setFixed(boolean fixed) throws PropertyVetoException {
        boolean oldFixed = this.fixed_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("fixed", (Object)oldFixed, (Object)fixed);
        }
        this.fixed_ = fixed;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("fixed", (Object)oldFixed, (Object)fixed);
        }
    }

    public void setItalic(boolean italic) throws PropertyVetoException {
        boolean oldItalic = this.italic_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("italic", (Object)oldItalic, (Object)italic);
        }
        this.italic_ = italic;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("italic", (Object)oldItalic, (Object)italic);
        }
    }

    public void setLanguage(String lang) throws PropertyVetoException {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", old, lang);
        }
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setSize(int size) throws PropertyVetoException {
        if (size < 0 || size > 7) {
            throw new ExtendedIllegalArgumentException("size", 4);
        }
        int oldSize = this.size_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("size", (Object)oldSize, (Object)size);
        }
        this.size_ = size;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("size", (Object)oldSize, (Object)size);
        }
    }

    public void setText(String text) throws PropertyVetoException {
        if (text == null) {
            throw new NullPointerException("text");
        }
        String old = this.text_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("text", old, text);
        }
        this.text_ = text;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", old, text);
        }
    }

    public void setUnderscore(boolean underscore) throws PropertyVetoException {
        boolean oldUnderscore = this.underscore_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("underscore", (Object)oldUnderscore, (Object)underscore);
        }
        this.underscore_ = underscore;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("underscore", (Object)oldUnderscore, (Object)underscore);
        }
    }

    public void setUseFO(boolean useFO) {
        boolean old = this.useFO_;
        this.useFO_ = useFO;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", old, useFO);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

