/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.AddressResolver;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.tracing.NoopTracing;
import org.apache.ignite.internal.processors.tracing.Tracing;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.AttributeNames;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationMetricsListener;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionPolicy;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionRequestor;
import org.apache.ignite.spi.communication.tcp.internal.FirstConnectionPolicy;
import org.apache.ignite.spi.communication.tcp.internal.TcpCommunicationConfiguration;

public abstract class TcpCommunicationConfigInitializer
extends IgniteSpiAdapter
implements CommunicationSpi<Message> {
    protected final TcpCommunicationConfiguration cfg = new TcpCommunicationConfiguration();
    protected AttributeNames attributeNames;
    protected TcpCommunicationMetricsListener metricsLsnr;
    protected ConnectionPolicy connPlc = new FirstConnectionPolicy();
    protected Tracing tracing;

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setAddressResolver(AddressResolver addrRslvr) {
        if (this.cfg.addrRslvr() == null) {
            this.cfg.addrRslvr(addrRslvr);
        }
        return (TcpCommunicationSpi)this;
    }

    public AddressResolver getAddressResolver() {
        return this.cfg.addrRslvr();
    }

    @Override
    @IgniteInstanceResource
    protected void injectResources(Ignite ignite) {
        super.injectResources(ignite);
        if (ignite != null) {
            this.setAddressResolver(ignite.configuration().getAddressResolver());
            this.setLocalAddress(ignite.configuration().getLocalHost());
            this.tracing = ignite instanceof IgniteEx ? ((IgniteEx)ignite).context().tracing() : new NoopTracing();
        }
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setLocalAddress(String locAddr) {
        if (this.cfg.localAddress() == null) {
            this.cfg.localAddress(locAddr);
        }
        return (TcpCommunicationSpi)this;
    }

    public String getLocalAddress() {
        return this.cfg.localAddress();
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setLocalPort(int locPort) {
        this.cfg.localPort(locPort);
        return (TcpCommunicationSpi)this;
    }

    public int getLocalPort() {
        return this.cfg.localPort();
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setLocalPortRange(int locPortRange) {
        A.ensure(locPortRange >= 0, "The port range must be positive.");
        this.cfg.localPortRange(locPortRange);
        return (TcpCommunicationSpi)this;
    }

    public int getLocalPortRange() {
        return this.cfg.localPortRange();
    }

    public boolean isUsePairedConnections() {
        return this.cfg.usePairedConnections();
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setUsePairedConnections(boolean usePairedConnections) {
        this.cfg.usePairedConnections(usePairedConnections);
        return (TcpCommunicationSpi)this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setConnectionsPerNode(int maxConnectionsPerNode) {
        this.cfg.connectionsPerNode(maxConnectionsPerNode);
        return (TcpCommunicationSpi)this;
    }

    public int getConnectionsPerNode() {
        return this.cfg.connectionsPerNode();
    }

    @IgniteSpiConfiguration(optional=true)
    @Deprecated
    public TcpCommunicationSpi setSharedMemoryPort(int shmemPort) {
        return (TcpCommunicationSpi)this;
    }

    @Deprecated
    public int getSharedMemoryPort() {
        return -1;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setIdleConnectionTimeout(long idleConnTimeout) {
        this.cfg.idleConnectionTimeout(idleConnTimeout);
        return (TcpCommunicationSpi)this;
    }

    public long getIdleConnectionTimeout() {
        return this.cfg.idleConnectionTimeout();
    }

    public long getSocketWriteTimeout() {
        return this.cfg.socketWriteTimeout();
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setSocketWriteTimeout(long sockWriteTimeout) {
        this.cfg.socketWriteTimeout(sockWriteTimeout);
        return (TcpCommunicationSpi)this;
    }

    public int getAckSendThreshold() {
        return this.cfg.ackSendThreshold();
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setAckSendThreshold(int ackSndThreshold) {
        this.cfg.ackSendThreshold(ackSndThreshold);
        return (TcpCommunicationSpi)this;
    }

    public int getUnacknowledgedMessagesBufferSize() {
        return this.cfg.unackedMsgsBufferSize();
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setUnacknowledgedMessagesBufferSize(int unackedMsgsBufSize) {
        this.cfg.unackedMsgsBufferSize(unackedMsgsBufSize);
        return (TcpCommunicationSpi)this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setConnectTimeout(long connTimeout) {
        this.cfg.connectionTimeout(connTimeout);
        this.failureDetectionTimeoutEnabled(false);
        return (TcpCommunicationSpi)this;
    }

    public long getConnectTimeout() {
        return this.cfg.connectionTimeout();
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setMaxConnectTimeout(long maxConnTimeout) {
        this.cfg.maxConnectionTimeout(maxConnTimeout);
        this.failureDetectionTimeoutEnabled(false);
        return (TcpCommunicationSpi)this;
    }

    public long getMaxConnectTimeout() {
        return this.cfg.maxConnectionTimeout();
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setReconnectCount(int reconCnt) {
        this.cfg.reconCount(reconCnt);
        this.failureDetectionTimeoutEnabled(false);
        return (TcpCommunicationSpi)this;
    }

    public int getReconnectCount() {
        return this.cfg.reconCount();
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setDirectBuffer(boolean directBuf) {
        this.cfg.directBuffer(directBuf);
        return (TcpCommunicationSpi)this;
    }

    public boolean isDirectBuffer() {
        return this.cfg.directBuffer();
    }

    public boolean isDirectSendBuffer() {
        return this.cfg.directSendBuffer();
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setDirectSendBuffer(boolean directSndBuf) {
        this.cfg.directSendBuffer(directSndBuf);
        return (TcpCommunicationSpi)this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setSelectorsCount(int selectorsCnt) {
        this.cfg.selectorsCount(selectorsCnt);
        return (TcpCommunicationSpi)this;
    }

    public int getSelectorsCount() {
        return this.cfg.selectorsCount();
    }

    public long getSelectorSpins() {
        return this.cfg.selectorSpins();
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setSelectorSpins(long selectorSpins) {
        this.cfg.selectorSpins(selectorSpins);
        return (TcpCommunicationSpi)this;
    }

    @IgniteExperimental
    public void setConnectionRequestor(ConnectionRequestor connectionRequestor) {
        this.cfg.connectionRequestor(connectionRequestor);
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setTcpNoDelay(boolean tcpNoDelay) {
        this.cfg.tcpNoDelay(tcpNoDelay);
        return (TcpCommunicationSpi)this;
    }

    public boolean isTcpNoDelay() {
        return this.cfg.tcpNoDelay();
    }

    public boolean isFilterReachableAddresses() {
        return this.cfg.filterReachableAddresses();
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setFilterReachableAddresses(boolean filterReachableAddresses) {
        this.cfg.filterReachableAddresses(filterReachableAddresses);
        return (TcpCommunicationSpi)this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setSocketReceiveBuffer(int sockRcvBuf) {
        this.cfg.socketReceiveBuffer(sockRcvBuf);
        return (TcpCommunicationSpi)this;
    }

    public int getSocketReceiveBuffer() {
        return this.cfg.socketReceiveBuffer();
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setSocketSendBuffer(int sockSndBuf) {
        this.cfg.socketSendBuffer(sockSndBuf);
        return (TcpCommunicationSpi)this;
    }

    public int getSocketSendBuffer() {
        return this.cfg.socketSendBuffer();
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setMessageQueueLimit(int msgQueueLimit) {
        this.cfg.messageQueueLimit(msgQueueLimit);
        return (TcpCommunicationSpi)this;
    }

    public int getMessageQueueLimit() {
        return this.cfg.messageQueueLimit();
    }

    public int getSlowClientQueueLimit() {
        return this.cfg.slowClientQueueLimit();
    }

    @Override
    public void failureDetectionTimeoutEnabled(boolean enabled) {
        super.failureDetectionTimeoutEnabled(enabled);
        this.cfg.failureDetectionTimeoutEnabled(enabled);
    }

    @Override
    public boolean failureDetectionTimeoutEnabled() {
        boolean spiVal = super.failureDetectionTimeoutEnabled();
        boolean cfgVal = this.cfg.failureDetectionTimeoutEnabled();
        assert (spiVal == cfgVal) : "Inconsistent value [spi=" + spiVal + ", cfg=" + cfgVal + "]";
        return spiVal;
    }

    @Override
    public long failureDetectionTimeout() {
        long spiVal = super.failureDetectionTimeout();
        long cfgVal = this.cfg.failureDetectionTimeout();
        assert (spiVal == cfgVal) : "Inconsistent value [spi=" + spiVal + ", cfg=" + cfgVal + "]";
        return spiVal;
    }

    @IgniteExperimental
    public boolean forceClientToServerConnections() {
        return this.cfg.forceClientToSrvConnections();
    }

    @IgniteExperimental
    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setForceClientToServerConnections(boolean forceClientToSrvConnections) {
        this.cfg.forceClientToSrvConnections(forceClientToSrvConnections);
        return (TcpCommunicationSpi)this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpCommunicationSpi setSlowClientQueueLimit(int slowClientQueueLimit) {
        this.cfg.slowClientQueueLimit(slowClientQueueLimit);
        return (TcpCommunicationSpi)this;
    }

    public int boundPort() {
        return this.cfg.boundTcpPort();
    }

    @Override
    public TcpCommunicationSpi setName(String name) {
        super.setName(name);
        return (TcpCommunicationSpi)this;
    }

    @Override
    public Map<String, Object> getNodeAttributes() throws IgniteSpiException {
        this.initFailureDetectionTimeout();
        if (Boolean.TRUE.equals(this.ignite.configuration().isClientMode())) {
            this.assertParameter(this.cfg.localPort() > 1023 || this.cfg.localPort() == -1, "localPort > 1023 || localPort == -1");
        } else {
            this.assertParameter(this.cfg.localPort() > 1023, "localPort > 1023");
        }
        this.assertParameter(this.cfg.localPort() <= 65535, "locPort < 0xffff");
        this.assertParameter(this.cfg.localPortRange() >= 0, "locPortRange >= 0");
        this.assertParameter(this.cfg.idleConnectionTimeout() > 0L, "idleConnTimeout > 0");
        this.assertParameter(this.cfg.socketReceiveBuffer() >= 0, "sockRcvBuf >= 0");
        this.assertParameter(this.cfg.socketSendBuffer() >= 0, "sockSndBuf >= 0");
        this.assertParameter(this.cfg.messageQueueLimit() >= 0, "msgQueueLimit >= 0");
        this.assertParameter(this.cfg.selectorsCount() > 0, "selectorsCnt > 0");
        this.assertParameter(this.cfg.connectionsPerNode() > 0, "connectionsPerNode > 0");
        this.assertParameter(this.cfg.connectionsPerNode() <= 1024, "connectionsPerNode <= 1024");
        if (!this.failureDetectionTimeoutEnabled()) {
            this.assertParameter(this.cfg.reconCount() > 0, "reconnectCnt > 0");
            this.assertParameter(this.cfg.connectionTimeout() >= 0L, "connTimeout >= 0");
            this.assertParameter(this.cfg.maxConnectionTimeout() >= this.cfg.connectionTimeout(), "maxConnTimeout >= connTimeout");
        }
        this.assertParameter(this.cfg.socketWriteTimeout() >= 0L, "sockWriteTimeout >= 0");
        this.assertParameter(this.cfg.ackSendThreshold() > 0, "ackSndThreshold > 0");
        this.assertParameter(this.cfg.unackedMsgsBufferSize() >= 0, "unackedMsgsBufSize >= 0");
        if (this.cfg.unackedMsgsBufferSize() > 0) {
            this.assertParameter(this.cfg.unackedMsgsBufferSize() >= this.cfg.messageQueueLimit() * 5, "Specified 'unackedMsgsBufSize' is too low, it should be at least 'msgQueueLimit * 5'.");
            this.assertParameter(this.cfg.unackedMsgsBufferSize() >= this.cfg.ackSendThreshold() * 5, "Specified 'unackedMsgsBufSize' is too low, it should be at least 'ackSndThreshold * 5'.");
        }
        try {
            IgniteBiTuple<Collection<String>, Collection<String>> addrs = U.resolveLocalAddresses(this.cfg.localHost());
            if (this.cfg.localPort() != -1 && addrs.get1().isEmpty() && addrs.get2().isEmpty()) {
                throw new IgniteCheckedException("No network addresses found (is networking enabled?).");
            }
            Collection<InetSocketAddress> extAddrs = this.cfg.addrRslvr() == null ? null : U.resolveAddresses(this.cfg.addrRslvr(), F.flat(Arrays.asList(addrs.get1(), addrs.get2())), this.cfg.boundTcpPort());
            HashMap<String, Object> res = new HashMap<String, Object>(5);
            boolean setEmptyHostNamesAttr = !IgniteSystemProperties.getBoolean("IGNITE_TCP_COMM_SET_ATTR_HOST_NAMES", false) && !F.isEmpty(this.cfg.localAddress()) && this.cfg.localHost().getHostAddress().equals(this.cfg.localAddress()) && !this.cfg.localHost().isAnyLocalAddress() && !this.cfg.localHost().isLoopbackAddress();
            res.put(this.createSpiAttributeName("comm.tcp.addrs"), addrs.get1());
            res.put(this.createSpiAttributeName("comm.tcp.host.names"), setEmptyHostNamesAttr ? Collections.emptyList() : addrs.get2());
            res.put(this.createSpiAttributeName("comm.tcp.port"), this.cfg.boundTcpPort() == -1 ? TcpCommunicationSpi.DISABLED_CLIENT_PORT.intValue() : this.cfg.boundTcpPort());
            res.put(this.createSpiAttributeName("comm.tcp.ext-addrs"), extAddrs);
            res.put(this.createSpiAttributeName("comm.tcp.pairedConnection"), this.cfg.usePairedConnections());
            res.put(this.createSpiAttributeName("comm.force.client.srv.connections"), this.cfg.forceClientToSrvConnections());
            return res;
        }
        catch (IOException | IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to resolve local host to addresses: " + this.cfg.localHost(), e);
        }
    }
}

