/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.metric.MetricRegistryImpl;
import org.apache.ignite.internal.processors.metric.impl.IntMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.GridBoundedLinkedHashMap;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;

public class TcpDiscoveryStatistics {
    private final AtomicLong crdSinceTs = new AtomicLong();
    private final IntMetricImpl joinedNodesCnt;
    private final IntMetricImpl failedNodesCnt;
    private final IntMetricImpl leftNodesCnt;
    @GridToStringInclude
    private final Map<String, Integer> rcvdMsgs = new HashMap<String, Integer>();
    @GridToStringInclude
    private final Map<String, Integer> procMsgs = new HashMap<String, Integer>();
    @GridToStringInclude
    private final Map<String, Integer> sentMsgs = new HashMap<String, Integer>();
    private final Map<IgniteUuid, Long> msgsProcStartTs = new GridBoundedLinkedHashMap<IgniteUuid, Long>(1024);
    private long avgMsgProcTime;
    private long maxMsgProcTime;
    private final IntMetricImpl pendingMsgsRegistered;
    private final IntMetricImpl rejectedSslConnectionsCnt;

    public TcpDiscoveryStatistics() {
        this.joinedNodesCnt = new IntMetricImpl(MetricUtils.metricName(GridDiscoveryManager.DISCO_METRICS, "JoinedNodes"), "Joined nodes count");
        this.failedNodesCnt = new IntMetricImpl(MetricUtils.metricName(GridDiscoveryManager.DISCO_METRICS, "FailedNodes"), "Failed nodes count");
        this.leftNodesCnt = new IntMetricImpl(MetricUtils.metricName(GridDiscoveryManager.DISCO_METRICS, "LeftNodes"), "Left nodes count");
        this.pendingMsgsRegistered = new IntMetricImpl(MetricUtils.metricName(GridDiscoveryManager.DISCO_METRICS, "PendingMessagesRegistered"), "Pending messages registered count");
        this.rejectedSslConnectionsCnt = new IntMetricImpl(MetricUtils.metricName(GridDiscoveryManager.DISCO_METRICS, "RejectedSslConnectionsCount"), "TCP discovery connections count that were rejected due to SSL errors.");
    }

    public void registerMetrics(MetricRegistryImpl discoReg) {
        discoReg.register("TotalProcessedMessages", this::totalProcessedMessages, "Total processed messages count");
        discoReg.register("TotalReceivedMessages", this::totalReceivedMessages, "Total received messages count");
        discoReg.register(this.joinedNodesCnt);
        discoReg.register(this.failedNodesCnt);
        discoReg.register(this.leftNodesCnt);
        discoReg.register(this.pendingMsgsRegistered);
        discoReg.register(this.rejectedSslConnectionsCnt);
    }

    public void onNodeJoined() {
        this.joinedNodesCnt.increment();
    }

    public void onNodeLeft() {
        this.leftNodesCnt.increment();
    }

    public void onNodeFailed() {
        this.failedNodesCnt.increment();
    }

    public void onBecomingCoordinator() {
        this.crdSinceTs.compareAndSet(0L, U.currentTimeMillis());
    }

    public void onSslConnectionRejected() {
        this.rejectedSslConnectionsCnt.increment();
    }

    public synchronized void onMessageReceived(TcpDiscoveryAbstractMessage msg) {
        assert (msg != null);
        Integer cnt = F.addIfAbsent(this.rcvdMsgs, msg.getClass().getSimpleName(), Integer.valueOf(0));
        cnt = cnt + 1;
        this.rcvdMsgs.put(msg.getClass().getSimpleName(), cnt);
    }

    public synchronized void onMessageProcessingStarted(TcpDiscoveryAbstractMessage msg) {
        assert (msg != null);
        Integer cnt = F.addIfAbsent(this.procMsgs, msg.getClass().getSimpleName(), Integer.valueOf(0));
        cnt = cnt + 1;
        this.procMsgs.put(msg.getClass().getSimpleName(), cnt);
        this.msgsProcStartTs.put(msg.id(), U.currentTimeMillis());
    }

    public synchronized void onMessageProcessingFinished(TcpDiscoveryAbstractMessage msg) {
        assert (msg != null);
        Long startTs = this.msgsProcStartTs.remove(msg.id());
        if (startTs != null) {
            long duration = U.currentTimeMillis() - startTs;
            int totalProcMsgs = this.totalProcessedMessages();
            if (totalProcMsgs != 0) {
                this.avgMsgProcTime = (this.avgMsgProcTime * (long)(totalProcMsgs - 1) + duration) / (long)totalProcMsgs;
            }
            if (duration > this.maxMsgProcTime) {
                this.maxMsgProcTime = duration;
            }
        }
    }

    public synchronized void onMessageSent(TcpDiscoveryAbstractMessage msg, long time) {
        assert (msg != null);
        assert (time >= 0L) : time;
        Integer cnt = F.addIfAbsent(this.sentMsgs, msg.getClass().getSimpleName(), Integer.valueOf(0));
        cnt = cnt + 1;
        this.sentMsgs.put(msg.getClass().getSimpleName(), cnt);
    }

    public void onPendingMessageRegistered() {
        this.pendingMsgsRegistered.increment();
    }

    public synchronized Map<String, Integer> processedMessages() {
        return new HashMap<String, Integer>(this.procMsgs);
    }

    public synchronized Map<String, Integer> receivedMessages() {
        return new HashMap<String, Integer>(this.rcvdMsgs);
    }

    public synchronized Map<String, Integer> sentMessages() {
        return new HashMap<String, Integer>(this.sentMsgs);
    }

    public synchronized int totalReceivedMessages() {
        return F.sumInt(this.rcvdMsgs.values());
    }

    public synchronized int totalProcessedMessages() {
        return F.sumInt(this.procMsgs.values());
    }

    public synchronized long maxMessageProcessingTime() {
        return this.maxMsgProcTime;
    }

    public synchronized long avgMessageProcessingTime() {
        return this.avgMsgProcTime;
    }

    public long pendingMessagesRegistered() {
        return this.pendingMsgsRegistered.value();
    }

    public int joinedNodesCount() {
        return this.joinedNodesCnt.value();
    }

    public int leftNodesCount() {
        return this.leftNodesCnt.value();
    }

    public int failedNodesCount() {
        return this.failedNodesCnt.value();
    }

    public long coordinatorSinceTimestamp() {
        return this.crdSinceTs.get();
    }

    public synchronized void clear() {
        this.avgMsgProcTime = 0L;
        this.crdSinceTs.set(0L);
        this.failedNodesCnt.reset();
        this.joinedNodesCnt.reset();
        this.leftNodesCnt.reset();
        this.maxMsgProcTime = 0L;
        this.pendingMsgsRegistered.reset();
        this.procMsgs.clear();
        this.rcvdMsgs.clear();
        this.sentMsgs.clear();
        this.rejectedSslConnectionsCnt.reset();
    }

    public synchronized String toString() {
        return S.toString(TcpDiscoveryStatistics.class, this);
    }
}

