/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryBean;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryFutureAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryInfo;
import org.apache.ignite.internal.processors.cache.query.reducer.CacheQueryReducer;
import org.apache.ignite.internal.processors.cache.query.reducer.NodePageStream;
import org.apache.ignite.internal.processors.cache.query.reducer.UnsortedCacheQueryReducer;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.marshaller.Marshaller;

public class GridCacheLocalQueryFuture<K, V, R>
extends GridCacheQueryFutureAdapter<K, V, R> {
    private Runnable run = new LocalQueryRunnable();
    private IgniteInternalFuture<?> fut;
    private final NodePageStream<R> stream;

    protected GridCacheLocalQueryFuture(GridCacheContext<K, V> ctx, GridCacheQueryBean qry) {
        super(ctx, qry, true);
        this.stream = new NodePageStream(ctx.localNodeId(), () -> {}, () -> {});
        this.reducer = new UnsortedCacheQueryReducer<R>(F.asMap(this.stream.nodeId(), this.stream));
    }

    void execute() {
        this.fut = this.cctx.kernalContext().closure().runLocalSafe(this.run, (byte)10);
    }

    @Override
    protected void cancelQuery(Throwable err) throws IgniteCheckedException {
        if (this.fut != null) {
            this.fut.cancel();
        }
        this.stream.cancel(err);
    }

    @Override
    public void awaitFirstItemAvailable() throws IgniteCheckedException {
        CacheQueryReducer.get(this.stream.headPage());
    }

    @Override
    protected void onError(Throwable err) {
        if (this.onDone(err)) {
            this.stream.cancel(err);
        }
    }

    @Override
    protected void onPage(UUID nodeId, Collection<R> data, boolean lastPage) {
        this.stream.addPage(data, lastPage);
    }

    private class LocalQueryRunnable
    implements GridPlainRunnable {
        private LocalQueryRunnable() {
        }

        @Override
        public void run() {
            block4: {
                try {
                    GridCacheLocalQueryFuture.this.qry.query().validate();
                    if (GridCacheLocalQueryFuture.this.fields()) {
                        GridCacheLocalQueryFuture.this.cctx.queries().runFieldsQuery(this.localQueryInfo());
                    } else {
                        GridCacheLocalQueryFuture.this.cctx.queries().runQuery(this.localQueryInfo());
                    }
                }
                catch (Throwable e) {
                    GridCacheLocalQueryFuture.this.onDone(e);
                    if (!(e instanceof Error)) break block4;
                    throw (Error)e;
                }
            }
        }

        private GridCacheQueryInfo localQueryInfo() throws IgniteCheckedException {
            GridCacheQueryBean qry = GridCacheLocalQueryFuture.this.query();
            Marshaller marsh = GridCacheLocalQueryFuture.this.cctx.marshaller();
            IgniteReducer rdc = qry.reducer() != null ? (IgniteReducer)U.unmarshal(marsh, U.marshal(marsh, qry.reducer()), U.resolveClassLoader(GridCacheLocalQueryFuture.this.cctx.gridConfig())) : null;
            IgniteClosure trans = qry.transform() != null ? (IgniteClosure)U.unmarshal(marsh, U.marshal(marsh, qry.transform()), U.resolveClassLoader(GridCacheLocalQueryFuture.this.cctx.gridConfig())) : null;
            return new GridCacheQueryInfo(true, trans, rdc, qry.query(), GridCacheLocalQueryFuture.this, GridCacheLocalQueryFuture.this.cctx.localNodeId(), GridCacheLocalQueryFuture.this.cctx.io().nextIoId(), qry.query().includeMetadata(), true, qry.arguments());
        }
    }
}

