/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.continuous;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.IncompleteDeserializationException;
import org.apache.ignite.internal.processors.continuous.AbstractContinuousMessage;
import org.apache.ignite.internal.processors.continuous.StartRequestData;
import org.apache.ignite.internal.processors.continuous.StartRoutineAckDiscoveryMessage;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class StartRoutineDiscoveryMessage
extends AbstractContinuousMessage {
    private static final long serialVersionUID = 0L;
    private final StartRequestData startReqData;
    private Map<UUID, IgniteCheckedException> errs = new HashMap<UUID, IgniteCheckedException>();
    private Map<Integer, T2<Long, Long>> updateCntrs;
    private Map<UUID, Map<Integer, T2<Long, Long>>> updateCntrsPerNode;
    private boolean keepBinary;
    private transient ClassNotFoundException deserEx;

    public StartRoutineDiscoveryMessage(UUID routineId, StartRequestData startReqData, boolean keepBinary) {
        super(routineId);
        this.startReqData = startReqData;
        this.keepBinary = keepBinary;
    }

    public StartRequestData startRequestData() {
        return this.startReqData;
    }

    public void addError(UUID nodeId, IgniteCheckedException e) {
        if (this.errs == null) {
            this.errs = new HashMap<UUID, IgniteCheckedException>();
        }
        this.errs.put(nodeId, e);
    }

    private void addUpdateCounters(Map<Integer, T2<Long, Long>> cntrs) {
        if (this.updateCntrs == null) {
            this.updateCntrs = new HashMap<Integer, T2<Long, Long>>();
        }
        for (Map.Entry<Integer, T2<Long, Long>> e : cntrs.entrySet()) {
            T2<Long, Long> cntr0 = this.updateCntrs.get(e.getKey());
            T2<Long, Long> cntr1 = e.getValue();
            if (cntr0 != null && (Long)cntr1.get2() <= (Long)cntr0.get2()) continue;
            this.updateCntrs.put(e.getKey(), cntr1);
        }
    }

    public void addUpdateCounters(UUID nodeId, Map<Integer, T2<Long, Long>> cntrs) {
        this.addUpdateCounters(cntrs);
        if (this.updateCntrsPerNode == null) {
            this.updateCntrsPerNode = new HashMap<UUID, Map<Integer, T2<Long, Long>>>();
        }
        Map<Integer, T2<Long, Long>> old = this.updateCntrsPerNode.put(nodeId, cntrs);
        assert (old == null) : old;
    }

    public Map<UUID, IgniteCheckedException> errs() {
        return this.errs != null ? this.errs : Collections.emptyMap();
    }

    public boolean keepBinary() {
        return this.keepBinary;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public DiscoveryCustomMessage ackMessage() {
        return new StartRoutineAckDiscoveryMessage(this.routineId, this.errs(), this.updateCntrs, this.updateCntrsPerNode);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            in.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            this.deserEx = e;
            throw new IncompleteDeserializationException(this);
        }
    }

    @Nullable
    public ClassNotFoundException deserializationException() {
        return this.deserEx;
    }

    public String toString() {
        return S.toString(StartRoutineDiscoveryMessage.class, this, "routineId", (Object)this.routineId());
    }
}

