/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.compute;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.ClusterService;
import org.jetbrains.annotations.NotNull;

public class ClientComputeExecuteRequest {
    public static CompletableFuture<Void> process(ClientMessageUnpacker in, ClientMessagePacker out, IgniteCompute compute, ClusterService cluster) {
        ClusterNode node;
        String nodeName = in.tryUnpackNil() ? null : in.unpackString();
        ClusterNode clusterNode = node = nodeName == null ? cluster.topologyService().localMember() : cluster.topologyService().getByConsistentId(nodeName);
        if (node == null) {
            throw new IgniteException("Specified node is not present in the cluster: " + nodeName);
        }
        String jobClassName = in.unpackString();
        Object[] args = ClientComputeExecuteRequest.unpackArgs(in);
        return compute.execute(Set.of(node), jobClassName, args).thenAccept(arg_0 -> ((ClientMessagePacker)out).packObjectAsBinaryTuple(arg_0));
    }

    @NotNull
    public static Object[] unpackArgs(ClientMessageUnpacker in) {
        return in.unpackObjectArrayFromBinaryTuple();
    }
}

