/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Flow;
import org.jetbrains.annotations.Nullable;

public class CompositePublisher<T>
implements Flow.Publisher<T> {
    final Collection<? extends Flow.Publisher<T>> publishers;

    public CompositePublisher(Collection<? extends Flow.Publisher<T>> publishers) {
        this.publishers = publishers;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> downstream) {
        this.subscribe(new CompositeSubscription<T>(downstream), downstream);
    }

    void subscribe(CompositeSubscription<T> subscription, Flow.Subscriber<? super T> downstream) {
        subscription.subscribe(this.publishers);
        downstream.onSubscribe(subscription);
    }

    public static class CompositeSubscription<T>
    implements Flow.Subscription {
        private final List<Flow.Subscription> subscriptions = new ArrayList<Flow.Subscription>();
        protected final Flow.Subscriber<? super T> downstream;
        private int subscriptionIdx = 0;
        private long remaining;
        private boolean cancelled;

        public CompositeSubscription(Flow.Subscriber<? super T> downstream) {
            this.downstream = downstream;
        }

        public void subscribe(Collection<? extends Flow.Publisher<? extends T>> sources) {
            for (Flow.Publisher<T> publisher : sources) {
                publisher.subscribe(new PlainSubscriber());
            }
        }

        @Override
        public void request(long n) {
            this.remaining = n;
            this.requestInternal();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            Flow.Subscription subscription = this.activeSubscription();
            if (subscription != null) {
                subscription.cancel();
            }
        }

        private void requestInternal() {
            Flow.Subscription subscription = this.activeSubscription();
            if (subscription != null) {
                subscription.request(this.remaining);
            }
        }

        @Nullable
        private Flow.Subscription activeSubscription() {
            if (this.subscriptionIdx >= this.subscriptions.size()) {
                return null;
            }
            return this.subscriptions.get(this.subscriptionIdx);
        }

        protected class PlainSubscriber
        implements Flow.Subscriber<T> {
            protected PlainSubscriber() {
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                CompositeSubscription.this.subscriptions.add(subscription);
            }

            @Override
            public void onNext(T item) {
                --CompositeSubscription.this.remaining;
                CompositeSubscription.this.downstream.onNext(item);
            }

            @Override
            public void onError(Throwable throwable) {
                CompositeSubscription.this.downstream.onError(throwable);
            }

            @Override
            public void onComplete() {
                if (CompositeSubscription.this.cancelled) {
                    return;
                }
                if (++CompositeSubscription.this.subscriptionIdx == CompositeSubscription.this.subscriptions.size()) {
                    CompositeSubscription.this.downstream.onComplete();
                    return;
                }
                if (CompositeSubscription.this.remaining > 0L) {
                    CompositeSubscription.this.requestInternal();
                }
            }
        }
    }
}

