/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.meta.io;

import java.util.UUID;
import org.apache.ignite.internal.pagememory.util.PageUtils;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMeta;

public interface IndexMetaIo {
    public static final int INDEX_ID_MSB_OFFSET = 0;
    public static final int INDEX_ID_LSB_OFFSET = 8;
    public static final int INDEX_TREE_META_PAGE_ID_OFFSET = 16;
    public static final int SIZE_IN_BYTES = 26;

    public int offset(int var1);

    default public int compare(long pageAddr, int idx, IndexMeta indexMeta) {
        int elementOffset = this.offset(idx);
        int cmp = Long.compare(PageUtils.getLong((long)pageAddr, (int)(elementOffset + 0)), indexMeta.id().getMostSignificantBits());
        if (cmp != 0) {
            return cmp;
        }
        return Long.compare(PageUtils.getLong((long)pageAddr, (int)(elementOffset + 8)), indexMeta.id().getLeastSignificantBits());
    }

    default public IndexMeta getRow(long pageAddr, int idx) {
        int elementOffset = this.offset(idx);
        long indexIdMsb = PageUtils.getLong((long)pageAddr, (int)(elementOffset + 0));
        long indexIdLsb = PageUtils.getLong((long)pageAddr, (int)(elementOffset + 8));
        long indexTreeMetaPageId = PageUtils.getLong((long)pageAddr, (int)(elementOffset + 16));
        return new IndexMeta(new UUID(indexIdMsb, indexIdLsb), indexTreeMetaPageId);
    }

    default public void store(long dstPageAddr, int dstIdx, long srcPageAddr, int srcIdx) {
        int dstOffset = this.offset(dstIdx);
        int srcOffset = this.offset(srcIdx);
        PageUtils.copyMemory((long)srcPageAddr, (long)srcOffset, (long)dstPageAddr, (long)dstOffset, (long)26L);
    }

    default public void storeByOffset(long pageAddr, int off, IndexMeta row) {
        PageUtils.putLong((long)pageAddr, (int)(off + 0), (long)row.id().getMostSignificantBits());
        PageUtils.putLong((long)pageAddr, (int)(off + 8), (long)row.id().getLeastSignificantBits());
        PageUtils.putLong((long)pageAddr, (int)(off + 16), (long)row.metaPageId());
    }
}

