/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft.commands;

import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite.internal.cluster.management.raft.commands.ClusterNodeMessage;
import org.apache.ignite.internal.cluster.management.raft.commands.ClusterNodeMessageBuilder;
import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;

class ClusterNodeMessageDeserializer
implements MessageDeserializer<ClusterNodeMessage> {
    private final ClusterNodeMessageBuilder msg;

    ClusterNodeMessageDeserializer(CmgMessagesFactory messageFactory) {
        this.msg = messageFactory.clusterNodeMessage();
    }

    public Class<ClusterNodeMessage> klass() {
        return ClusterNodeMessage.class;
    }

    public ClusterNodeMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.host(reader.readString("host"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.id(reader.readString("id"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.name(reader.readString("name"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.msg.port(reader.readInt("port"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ClusterNodeMessage.class);
    }
}

