/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.internal.util.FastTimestamps;

public class CheckpointMetricsTracker {
    private static final AtomicIntegerFieldUpdater<CheckpointMetricsTracker> DATA_PAGES_WRITTEN_UPDATER = AtomicIntegerFieldUpdater.newUpdater(CheckpointMetricsTracker.class, "dataPagesWritten");
    private static final AtomicIntegerFieldUpdater<CheckpointMetricsTracker> COPY_ON_WRITE_PAGES_WRITTEN_UPDATER = AtomicIntegerFieldUpdater.newUpdater(CheckpointMetricsTracker.class, "copyOnWritePagesWritten");
    private volatile int dataPagesWritten;
    private volatile int copyOnWritePagesWritten;
    private final long checkpointStartTimestamp = FastTimestamps.coarseCurrentTimeMillis();
    private long checkpointWriteLockWaitStartTimestamp;
    private long checkpointOnMarkCheckpointBeginStartTimestamp;
    private long checkpointWriteLockReleaseTimestamp;
    private long checkpointPagesWriteStartTimestamp;
    private long checkpointFsyncStartTimestamp;
    private long checkpointEndTimestamp;
    private long splitAndSortCheckpointPagesStartTimestamp;
    private long splitAndSortCheckpointPagesEndTimestamp;
    private long checkpointOnMarkCheckpointBeginEndTimestamp;

    public long checkpointStartTime() {
        return this.checkpointStartTimestamp;
    }

    public void onCheckpointEnd() {
        this.checkpointEndTimestamp = FastTimestamps.coarseCurrentTimeMillis();
    }

    public void onCopyOnWritePageWritten() {
        COPY_ON_WRITE_PAGES_WRITTEN_UPDATER.incrementAndGet(this);
    }

    public void onDataPageWritten() {
        DATA_PAGES_WRITTEN_UPDATER.incrementAndGet(this);
    }

    public int copyOnWritePagesWritten() {
        return this.copyOnWritePagesWritten;
    }

    public int dataPagesWritten() {
        return this.dataPagesWritten;
    }

    public void onWriteLockWaitStart() {
        this.checkpointWriteLockWaitStartTimestamp = FastTimestamps.coarseCurrentTimeMillis();
    }

    public void onWriteLockRelease() {
        this.checkpointWriteLockReleaseTimestamp = FastTimestamps.coarseCurrentTimeMillis();
    }

    public void onMarkCheckpointBeginStart() {
        this.checkpointOnMarkCheckpointBeginStartTimestamp = FastTimestamps.coarseCurrentTimeMillis();
    }

    public void onMarkCheckpointBeginEnd() {
        this.checkpointOnMarkCheckpointBeginEndTimestamp = FastTimestamps.coarseCurrentTimeMillis();
    }

    public void onPagesWriteStart() {
        this.checkpointPagesWriteStartTimestamp = FastTimestamps.coarseCurrentTimeMillis();
    }

    public void onFsyncStart() {
        this.checkpointFsyncStartTimestamp = FastTimestamps.coarseCurrentTimeMillis();
    }

    public void onSplitAndSortCheckpointPagesStart() {
        this.splitAndSortCheckpointPagesStartTimestamp = FastTimestamps.coarseCurrentTimeMillis();
    }

    public void onSplitAndSortCheckpointPagesEnd() {
        this.splitAndSortCheckpointPagesEndTimestamp = FastTimestamps.coarseCurrentTimeMillis();
    }

    public long totalDuration() {
        return this.checkpointEndTimestamp - this.checkpointStartTimestamp;
    }

    public long writeLockWaitDuration() {
        return this.checkpointOnMarkCheckpointBeginStartTimestamp - this.checkpointWriteLockWaitStartTimestamp;
    }

    public long beforeWriteLockDuration() {
        return this.checkpointWriteLockWaitStartTimestamp - this.checkpointStartTimestamp;
    }

    public long onMarkCheckpointBeginDuration() {
        return this.checkpointOnMarkCheckpointBeginEndTimestamp - this.checkpointOnMarkCheckpointBeginStartTimestamp;
    }

    public long writeLockHoldDuration() {
        return this.checkpointWriteLockReleaseTimestamp - this.checkpointOnMarkCheckpointBeginStartTimestamp;
    }

    public long pagesWriteDuration() {
        return this.checkpointFsyncStartTimestamp - this.checkpointPagesWriteStartTimestamp;
    }

    public long fsyncDuration() {
        return this.checkpointEndTimestamp - this.checkpointFsyncStartTimestamp;
    }

    public long splitAndSortCheckpointPagesDuration() {
        return this.splitAndSortCheckpointPagesEndTimestamp - this.splitAndSortCheckpointPagesStartTimestamp;
    }
}

