/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.replacement;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.WriteDirtyPage;
import org.apache.ignite.internal.pagememory.persistence.replacement.DelayedPageReplacementTracker;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public class DelayedDirtyPageWrite
implements WriteDirtyPage {
    private final WriteDirtyPage flushDirtyPage;
    private final int pageSize;
    private final ThreadLocal<ByteBuffer> byteBufThreadLoc;
    private final DelayedPageReplacementTracker tracker;
    @Nullable
    private FullPageId fullPageId;
    @Nullable
    private PersistentPageMemory pageMemory;

    public DelayedDirtyPageWrite(WriteDirtyPage flushDirtyPage, ThreadLocal<ByteBuffer> byteBufThreadLoc, int pageSize, DelayedPageReplacementTracker tracker) {
        this.flushDirtyPage = flushDirtyPage;
        this.pageSize = pageSize;
        this.byteBufThreadLoc = byteBufThreadLoc;
        this.tracker = tracker;
    }

    @Override
    public void write(PersistentPageMemory pageMemory, FullPageId fullPageId, ByteBuffer byteBuf) {
        this.tracker.lock(fullPageId);
        ByteBuffer threadLocalBuf = this.byteBufThreadLoc.get();
        threadLocalBuf.rewind();
        long writeAddr = GridUnsafe.bufferAddress((ByteBuffer)threadLocalBuf);
        long origBufAddr = GridUnsafe.bufferAddress((ByteBuffer)byteBuf);
        GridUnsafe.copyMemory((long)origBufAddr, (long)writeAddr, (long)this.pageSize);
        this.fullPageId = fullPageId;
        this.pageMemory = pageMemory;
    }

    public void finishReplacement() throws IgniteInternalCheckedException {
        if (this.fullPageId == null && this.pageMemory == null) {
            return;
        }
        try {
            this.flushDirtyPage.write(this.pageMemory, this.fullPageId, this.byteBufThreadLoc.get());
        }
        finally {
            this.tracker.unlock(this.fullPageId);
            this.fullPageId = null;
            this.pageMemory = null;
        }
    }
}

