/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.context;

import java.io.PrintWriter;
import java.util.function.Consumer;
import org.apache.ignite.internal.cli.core.repl.context.CommandLineContext;
import picocli.CommandLine;

public class CommandLineContextProvider {
    private static volatile CommandLineContext context;
    private static volatile Consumer<Runnable> printWrapper;

    public static CommandLineContext getContext() {
        return context;
    }

    public static void setCmd(final CommandLine cmd) {
        context = new CommandLineContext(){

            @Override
            public PrintWriter out() {
                return cmd.getOut();
            }

            @Override
            public PrintWriter err() {
                return cmd.getErr();
            }
        };
    }

    public static void setWriters(final PrintWriter out, final PrintWriter err) {
        context = new CommandLineContext(){

            @Override
            public PrintWriter out() {
                return out;
            }

            @Override
            public PrintWriter err() {
                return err;
            }
        };
    }

    public static void setPrintWrapper(Consumer<Runnable> printWrapper) {
        CommandLineContextProvider.printWrapper = printWrapper;
    }

    public static void print(Runnable printer) {
        printWrapper.accept(printer);
    }

    static {
        printWrapper = Runnable::run;
    }
}

