/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server.persistence;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.ignite.internal.metastorage.server.Entry;
import org.apache.ignite.internal.metastorage.server.persistence.RocksDbKeyValueStorage;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RangeCursor
implements Cursor<Entry> {
    private final RocksDbKeyValueStorage storage;
    private final byte[] keyFrom;
    private final byte @Nullable [] keyTo;
    private final long rev;
    private final Iterator<Entry> it;
    @Nullable
    private Entry nextRetEntry;
    private byte[] lastRetKey;
    private final boolean includeTombstones;
    private boolean finished;

    RangeCursor(RocksDbKeyValueStorage storage, byte[] keyFrom, byte @Nullable [] keyTo, long rev, boolean includeTombstones) {
        this.storage = storage;
        this.keyFrom = keyFrom;
        this.keyTo = keyTo;
        this.rev = rev;
        this.includeTombstones = includeTombstones;
        this.it = this.createIterator();
    }

    public boolean hasNext() {
        return this.it.hasNext();
    }

    public Entry next() {
        return this.it.next();
    }

    public void close() throws Exception {
    }

    @NotNull
    private Iterator<Entry> createIterator() {
        return new Iterator<Entry>(){

            @Override
            public boolean hasNext() {
                RangeCursor.this.storage.lock().readLock().lock();
                try {
                    block5: while (true) {
                        if (RangeCursor.this.finished) {
                            boolean bl = false;
                            return bl;
                        }
                        if (RangeCursor.this.nextRetEntry != null) {
                            boolean bl = true;
                            return bl;
                        }
                        byte[] key = RangeCursor.this.lastRetKey;
                        while (true) {
                            Entry entry;
                            Map.Entry<byte[], long[]> e;
                            if (RangeCursor.this.nextRetEntry != null) continue block5;
                            Map.Entry<byte[], long[]> entry2 = e = key == null ? RangeCursor.this.storage.revisionCeilingEntry(RangeCursor.this.keyFrom) : RangeCursor.this.storage.revisionHigherEntry(key);
                            if (e == null) {
                                RangeCursor.this.finished = true;
                                continue block5;
                            }
                            key = e.getKey();
                            if (RangeCursor.this.keyTo != null && RocksDbKeyValueStorage.CMP.compare(key, RangeCursor.this.keyTo) >= 0) {
                                RangeCursor.this.finished = true;
                                continue block5;
                            }
                            long[] revs = e.getValue();
                            assert (revs != null && revs.length != 0) : "Revisions should not be empty or null: [revs=" + Arrays.toString(revs) + "]";
                            long lastRev = RocksDbKeyValueStorage.maxRevision(revs, RangeCursor.this.rev);
                            if (lastRev == -1L || (entry = RangeCursor.this.storage.doGetValue(key, lastRev)).tombstone() && !RangeCursor.this.includeTombstones) continue;
                            assert (!entry.empty()) : "Iterator should not return empty entry.";
                            RangeCursor.this.nextRetEntry = entry;
                        }
                        break;
                    }
                }
                finally {
                    RangeCursor.this.storage.lock().readLock().unlock();
                }
            }

            @Override
            public Entry next() {
                RangeCursor.this.storage.lock().readLock().lock();
                try {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry e = RangeCursor.this.nextRetEntry;
                    RangeCursor.this.nextRetEntry = null;
                    assert (e != null);
                    RangeCursor.this.lastRetKey = e.key();
                    Entry entry = e;
                    return entry;
                }
                finally {
                    RangeCursor.this.storage.lock().readLock().unlock();
                }
            }
        };
    }
}

