/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.util.CollectionUtils;

public class SortNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT> {
    private int requested;
    private int waiting;
    private boolean inLoop;
    private final PriorityQueue<RowT> rows;

    public SortNode(ExecutionContext<RowT> ctx, RelDataType rowType, Comparator<RowT> comp) {
        super(ctx, rowType);
        this.rows = comp == null ? new PriorityQueue() : new PriorityQueue<RowT>(comp);
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        this.rows.clear();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0 && this.requested == 0);
        assert (this.waiting <= 0);
        this.checkState();
        this.requested = rowsCnt;
        if (this.waiting == 0) {
            this.waiting = 512;
            this.source().request(512);
        } else if (!this.inLoop) {
            this.context().execute(this::flush, this::onError);
        }
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        --this.waiting;
        this.rows.add(row);
        if (this.waiting == 0) {
            this.waiting = 512;
            this.source().request(512);
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        this.waiting = -1;
        this.flush();
    }

    private void flush() throws Exception {
        if (this.isClosed()) {
            return;
        }
        assert (this.waiting == -1);
        int processed = 0;
        this.inLoop = true;
        try {
            while (this.requested > 0 && !this.rows.isEmpty()) {
                this.checkState();
                --this.requested;
                this.downstream().push(this.rows.poll());
                if (++processed < 512 || this.requested <= 0) continue;
                this.context().execute(this::flush, this::onError);
                return;
            }
            if (this.rows.isEmpty()) {
                if (this.requested > 0) {
                    this.downstream().end();
                }
                this.requested = 0;
            }
        }
        finally {
            this.inLoop = false;
        }
    }
}

