/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;
import org.apache.ignite.sql.ColumnType;

public class JdbcConverterUtils {
    public static Class<?> columnTypeToJdbcClass(ColumnType type) {
        assert (type != null);
        switch (type) {
            case DATE: {
                return Date.class;
            }
            case TIME: {
                return Time.class;
            }
            case DATETIME: 
            case TIMESTAMP: {
                return Timestamp.class;
            }
        }
        return type.javaClass();
    }

    @Nullable
    public static Object deriveValueFromBinaryTuple(ColumnType columnType, BinaryTupleReader binaryTuple, int idx, int decimalScale) {
        switch (columnType) {
            case INT8: {
                return binaryTuple.byteValueBoxed(idx);
            }
            case INT16: {
                return binaryTuple.shortValueBoxed(idx);
            }
            case INT32: {
                return binaryTuple.intValueBoxed(idx);
            }
            case INT64: {
                return binaryTuple.longValueBoxed(idx);
            }
            case FLOAT: {
                return binaryTuple.floatValueBoxed(idx);
            }
            case DOUBLE: {
                return binaryTuple.doubleValueBoxed(idx);
            }
            case DECIMAL: {
                return binaryTuple.decimalValue(idx, decimalScale);
            }
            case UUID: {
                return binaryTuple.uuidValue(idx);
            }
            case STRING: {
                return binaryTuple.stringValue(idx);
            }
            case BYTE_ARRAY: {
                return binaryTuple.bytesValue(idx);
            }
            case DATE: {
                return binaryTuple.dateValue(idx);
            }
            case TIME: {
                return binaryTuple.timeValue(idx);
            }
            case DATETIME: {
                return binaryTuple.dateTimeValue(idx);
            }
            case TIMESTAMP: {
                return binaryTuple.timestampValue(idx);
            }
            case BOOLEAN: {
                return binaryTuple.booleanValueBoxed(idx);
            }
            case DURATION: {
                return binaryTuple.durationValue(idx);
            }
            case PERIOD: {
                return binaryTuple.periodValue(idx);
            }
            case NULL: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported Column type " + String.valueOf((Object)columnType));
    }
}

