/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.cluster;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.cluster.ClusterState;
import org.apache.ignite.internal.rest.api.cluster.InitCommand;

@Controller(value="/management/v1/cluster")
@Tag(name="clusterManagement")
public interface ClusterManagementApi {
    @Get(value="state")
    @Operation(operationId="clusterState", summary="Get cluster state", description="Returns current cluster status.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Cluster status returned.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ClusterState.class))}), @ApiResponse(responseCode="404", description="Cluster status not found. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public CompletableFuture<ClusterState> clusterState();

    @Post(value="init")
    @Operation(operationId="init", summary="Initialize cluster", description="Initialize a new cluster.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Cluster initialized."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect configuration.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    public CompletableFuture<Void> init(@Body InitCommand var1);
}

